/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.ExportImportDateUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.lar.backgroundtask.LayoutExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class LayoutExportBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    public LayoutExportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutExportImportBackgroundTaskStatusMessageTranslator());
        this.setSerial(true);
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws PortalException {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long exportImportConfigurationId = MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId");
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)exportImportConfigurationId);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long groupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration, (String)"all");
        StringBundler sb = new StringBundler(4);
        sb.append(StringUtil.replace((String)exportImportConfiguration.getName(), (String)" ", (String)"_"));
        sb.append("-");
        sb.append(Time.getShortTimestamp());
        sb.append(".lar");
        File larFile = LayoutLocalServiceUtil.exportLayoutsAsFile((long)groupId, (boolean)privateLayout, (long[])layoutIds, (Map)parameterMap, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate());
        BackgroundTaskLocalServiceUtil.addBackgroundTaskAttachment((long)userId, (long)backgroundTask.getBackgroundTaskId(), (String)sb.toString(), (File)larFile);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
        if (updateLastPublishDate) {
            StagingUtil.updateLastPublishDate((long)groupId, (boolean)privateLayout, (Date)dateRange.getEndDate());
        }
        return BackgroundTaskResult.SUCCESS;
    }

    public String handleException(BackgroundTask backgroundTask, Exception e) {
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)this.getLocale(backgroundTask), (Exception)e, (Map)backgroundTask.getTaskContextMap());
        return jsonObject.toString();
    }
}

