/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.backgroundtask.DefaultExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BaseStagingBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    public BaseStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new DefaultExportImportBackgroundTaskStatusMessageTranslator());
        this.setSerial(true);
    }

    public String handleException(BackgroundTask backgroundTask, Exception e) {
        JSONObject jsonObject = StagingUtil.getExceptionMessagesJSONObject((Locale)this.getLocale(backgroundTask), (Exception)e, (Map)backgroundTask.getTaskContextMap());
        return jsonObject.toString();
    }

    protected void clearBackgroundTaskStatus(BackgroundTask backgroundTask) {
        BackgroundTaskStatus backgroundTaskStatus = BackgroundTaskStatusRegistryUtil.getBackgroundTaskStatus((long)backgroundTask.getBackgroundTaskId());
        backgroundTaskStatus.clearAttributes();
    }

    protected void markBackgroundTask(long backgroundTaskId, String backgroundTaskState) {
        BackgroundTask backgroundTask = BackgroundTaskLocalServiceUtil.fetchBackgroundTask((long)backgroundTaskId);
        if (backgroundTask == null || Validator.isNull((String)backgroundTaskState)) {
            return;
        }
        HashMap<String, Boolean> taskContextMap = backgroundTask.getTaskContextMap();
        if (taskContextMap == null) {
            taskContextMap = new HashMap<String, Boolean>();
        }
        taskContextMap.put(backgroundTaskState, Boolean.TRUE);
        backgroundTask.setTaskContextMap(taskContextMap);
        BackgroundTaskLocalServiceUtil.updateBackgroundTask((BackgroundTask)backgroundTask);
    }

    protected BackgroundTaskResult processMissingReferences(long backgroundTaskId, MissingReferences missingReferences) {
        BackgroundTaskResult backgroundTaskResult = new BackgroundTaskResult(3);
        Map weakMissingReferences = missingReferences.getWeakMissingReferences();
        if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
            BackgroundTask backgroundTask = BackgroundTaskLocalServiceUtil.fetchBackgroundTask((long)backgroundTaskId);
            JSONArray jsonArray = StagingUtil.getWarningMessagesJSONArray((Locale)this.getLocale(backgroundTask), (Map)weakMissingReferences, (Map)backgroundTask.getTaskContextMap());
            backgroundTaskResult.setStatusMessage(jsonArray.toString());
        }
        return backgroundTaskResult;
    }
}

