/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.NoSuchPortletPreferencesException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventImporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetLinkLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetTagUtil;
import com.liferay.portlet.expando.NoSuchTableException;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

public class PortletImporter {
    private static Log _log = LogFactoryUtil.getLog(PortletImporter.class);
    private static PortletImporter _instance = new PortletImporter();
    private DeletionSystemEventImporter _deletionSystemEventImporter = DeletionSystemEventImporter.getInstance();
    private PermissionImporter _permissionImporter = PermissionImporter.getInstance();

    public static PortletImporter getInstance() {
        return _instance;
    }

    public String importPortletData(PortletDataContext portletDataContext, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences, Element portletDataElement) throws Exception {
        String portletData;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = null;
        if (portletPreferences != null) {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        }
        if (Validator.isNull((String)(portletData = portletDataContext.getZipEntryAsString(portletDataElement.attributeValue("path"))))) {
            return null;
        }
        if ((portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.importData(portletDataContext, portletId, (PortletPreferences)portletPreferencesImpl, portletData)) == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferencesImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)true);
            this.doImportPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        finally {
            ExportImportThreadLocal.setPortletImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MissingReferences validateFile(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)true);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layout.getCompanyId(), groupId, portletId, zipReader);
            String userIdStrategyString = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
            UserIdStrategy userIdStrategy = ExportImportHelperUtil.getUserIdStrategy((long)userId, (String)userIdStrategyString);
            PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layout.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
            portletDataContext.setPrivateLayout(layout.isPrivateLayout());
            MissingReferences missingReferences = ExportImportHelperUtil.validateMissingReferences((PortletDataContext)portletDataContext);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                throw new MissingReferenceException(missingReferences);
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setPortletValidationInProcess((boolean)false);
        }
    }

    protected void deletePortletData(PortletDataContext portletDataContext, String portletId, long plid) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(portletDataContext, portletId, portletPreferences)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deletePortletData(PortletDataContext portletDataContext, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        try {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.deleteData(portletDataContext, portletId, (PortletPreferences)portletPreferencesImpl);
        }
        finally {
            portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        }
        if (portletPreferencesImpl == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferencesImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        boolean importPortletSetup;
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        String userIdStrategyString = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        User user = UserUtil.findByPrimaryKey((long)userId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(user.getCompanyId());
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(userId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        this.validateFile(layout.getCompanyId(), groupId, portletId, zipReader);
        UserIdStrategy userIdStrategy = ExportImportHelperUtil.getUserIdStrategy((long)userId, (String)userIdStrategyString);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layout.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
        portletDataContext.setPlid(plid);
        portletDataContext.setPrivateLayout(layout.isPrivateLayout());
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceGroupId(), groupId);
        ManifestSummary manifestSummary = ExportImportHelperUtil.getManifestSummary((PortletDataContext)portletDataContext);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
        }
        portletDataContext.setManifestSummary(manifestSummary);
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element portletElement = null;
        try {
            portletElement = rootElement.element("portlet");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletElement.attributeValue("path")));
            portletElement = portletDocument.getRootElement();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        LayoutCache layoutCache = new LayoutCache();
        if (importPermissions) {
            this._permissionImporter.checkRoles(layoutCache, layout.getCompanyId(), groupId, userId, portletElement);
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        this.readAssetTags(portletDataContext);
        this.readExpandoTables(portletDataContext);
        this.readLocks(portletDataContext);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Deleting portlet data");
        }
        if (deletePortletData) {
            this.deletePortletData(portletDataContext, portletId, plid);
        }
        Element portletDataElement = portletElement.element("portlet-data");
        Map importPortletControlsMap = ExportImportHelperUtil.getImportPortletControlsMap((long)layout.getCompanyId(), (String)portletId, parameterMap, (Element)portletDataElement, (ManifestSummary)manifestSummary);
        try {
            this.importPortletPreferences(portletDataContext, layout.getCompanyId(), groupId, layout, portletId, portletElement, true, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
            if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Importing portlet data");
                }
                this.importPortletData(portletDataContext, portletId, plid, portletDataElement);
            }
        }
        finally {
            this.resetPortletScope(portletDataContext, groupId);
        }
        if (importPermissions) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Importing portlet permissions");
            }
            this._permissionImporter.importPortletPermissions(layoutCache, layout.getCompanyId(), groupId, userId, layout, portletElement, portletId);
            if (userId > 0L) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex((Object)userId);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing asset links");
        }
        this.readAssetLinks(portletDataContext);
        this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet takes " + stopWatch.getTime() + " ms"));
        }
        if (importPortletSetup = ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue()) {
            try {
                List serviceElements = rootElement.elements("service");
                for (Element serviceElement : serviceElements) {
                    Document serviceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(serviceElement.attributeValue("path")));
                    this.importServicePortletPreferences(portletDataContext, serviceDocument.getRootElement());
                }
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
        }
        zipReader.close();
    }

    protected com.liferay.portal.model.PortletPreferences getPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String serviceName) throws PortalException {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = ownerType == 5 || ownerType == 1 || ownerType == 2 ? PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)0L, (String)serviceName) : PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)plid, (String)serviceName);
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            portletPreferences = PortletPreferencesLocalServiceUtil.addPortletPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)serviceName, null, null);
        }
        return portletPreferences;
    }

    protected void importAssetTag(PortletDataContext portletDataContext, Map<Long, Long> assetTagPKs, Element assetTagElement, AssetTag assetTag) throws PortalException {
        AssetTag existingAssetTag;
        String[] properties;
        AssetTag importedAssetTag;
        ServiceContext serviceContext;
        long userId;
        block5: {
            userId = portletDataContext.getUserId(assetTag.getUserUuid());
            serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setCreateDate(assetTag.getCreateDate());
            serviceContext.setModifiedDate(assetTag.getModifiedDate());
            serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
            importedAssetTag = null;
            List propertyElements = assetTagElement.elements("property");
            properties = new String[propertyElements.size()];
            for (int i = 0; i < propertyElements.size(); ++i) {
                Element propertyElement = (Element)propertyElements.get(i);
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.attributeValue("value");
                properties[i] = key.concat("_KEY_VALUE_").concat(value);
            }
            existingAssetTag = null;
            try {
                existingAssetTag = AssetTagUtil.findByG_N((long)portletDataContext.getScopeGroupId(), (String)assetTag.getName());
            }
            catch (NoSuchTagException nste) {
                if (!_log.isDebugEnabled()) break block5;
                StringBundler sb = new StringBundler(5);
                sb.append("No AssetTag exists with the key {groupId=");
                sb.append(portletDataContext.getScopeGroupId());
                sb.append(", name=");
                sb.append(assetTag.getName());
                sb.append("}");
                _log.debug((Object)sb.toString());
            }
        }
        try {
            importedAssetTag = existingAssetTag == null ? AssetTagLocalServiceUtil.addTag((long)userId, (String)assetTag.getName(), (String[])properties, (ServiceContext)serviceContext) : AssetTagLocalServiceUtil.updateTag((long)userId, (long)existingAssetTag.getTagId(), (String)assetTag.getName(), (String[])properties, (ServiceContext)serviceContext);
            assetTagPKs.put(assetTag.getTagId(), importedAssetTag.getTagId());
            portletDataContext.importPermissions(AssetTag.class, assetTag.getTagId(), importedAssetTag.getTagId());
        }
        catch (NoSuchTagException nste) {
            _log.error((Object)("Could not find the parent category for category " + assetTag.getTagId()));
        }
    }

    protected void importPortletData(PortletDataContext portletDataContext, String portletId, long plid, Element portletDataElement) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if (Validator.isNotNull((String)(xml = this.importPortletData(portletDataContext, portletId, portletPreferences, portletDataElement)))) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importPortletPreferences(PortletDataContext portletDataContext, long companyId, long groupId, Layout layout, String portletId, Element parentElement, boolean preserveScopeLayoutId, boolean importPortletArchivedSetups, boolean importPortletData, boolean importPortletSetup, boolean importPortletUserPreferences) throws Exception {
        if (portletId == null) {
            portletId = parentElement.attributeValue("portlet-id");
        }
        long plid = 0L;
        String scopeType = "";
        String scopeLayoutUuid = "";
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId && portletId != null) {
                PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
                scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
        List portletPreferencesElements = parentElement.elements("portlet-preferences");
        for (Element portletPreferencesElement : portletPreferencesElements) {
            boolean defaultUser;
            String userUuid;
            String path = portletPreferencesElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            String xml = null;
            Element element = null;
            try {
                xml = portletDataContext.getZipEntryAsString(path);
                Document preferencesDocument = SAXReaderUtil.read((String)xml);
                element = preferencesDocument.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long ownerId = GetterUtil.getLong((String)element.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)element.attributeValue("owner-type"));
            if (ownerType == 1 || !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importPortletUserPreferences) continue;
            long curPlid = plid;
            String curPortletId = portletId;
            if (ownerType == 2) {
                curPlid = 0L;
                curPortletId = PortletConstants.getRootPortletId((String)portletId);
                ownerId = portletDataContext.getScopeGroupId();
            }
            if (ownerType == 5) {
                userUuid = element.attributeValue("archive-user-uuid");
                long userId = portletDataContext.getUserId(userUuid);
                String name = element.attributeValue("archive-name");
                curPortletId = PortletConstants.getRootPortletId((String)portletId);
                PortletItem portletItem = PortletItemLocalServiceUtil.updatePortletItem((long)userId, (long)groupId, (String)name, (String)curPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
                curPlid = 0L;
                ownerId = portletItem.getPortletItemId();
            }
            if (ownerType == 4) {
                userUuid = element.attributeValue("user-uuid");
                ownerId = portletDataContext.getUserId(userUuid);
            }
            if (defaultUser = GetterUtil.getBoolean((String)element.attributeValue("default-user"))) {
                ownerId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            }
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)curPlid, (String)curPortletId, (String)xml);
            Element importDataRootElement = portletDataContext.getImportDataRootElement();
            try {
                Element preferenceDataElement = portletPreferencesElement.element("preference-data");
                if (preferenceDataElement != null) {
                    portletDataContext.setImportDataRootElement(preferenceDataElement);
                }
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)curPortletId);
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                jxPortletPreferences = portletDataHandler.processImportPortletPreferences(portletDataContext, curPortletId, jxPortletPreferences);
            }
            finally {
                portletDataContext.setImportDataRootElement(importDataRootElement);
            }
            this.updatePortletPreferences(portletDataContext, ownerId, ownerType, curPlid, curPortletId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences), importPortletData);
        }
        if (preserveScopeLayoutId && layout != null) {
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            try {
                jxPortletPreferences.setValue("lfrScopeType", scopeType);
                jxPortletPreferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
                jxPortletPreferences.store();
            }
            finally {
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
    }

    protected void importServicePortletPreferences(PortletDataContext portletDataContext, Element serviceElement) throws PortalException {
        long ownerId = GetterUtil.getLong((String)serviceElement.attributeValue("owner-id"));
        int ownerType = GetterUtil.getInteger((String)serviceElement.attributeValue("owner-type"));
        String serviceName = serviceElement.attributeValue("service-name");
        com.liferay.portal.model.PortletPreferences portletPreferences = this.getPortletPreferences(portletDataContext.getCompanyId(), ownerId, ownerType, 0L, serviceName);
        for (Attribute attribute : serviceElement.attributes()) {
            serviceElement.remove(attribute);
        }
        String xml = serviceElement.asXML();
        portletPreferences.setPreferences(xml);
        PortletPreferencesLocalServiceUtil.updatePortletPreferences((com.liferay.portal.model.PortletPreferences)portletPreferences);
    }

    protected void readAssetLinks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/links.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetLinkGroupElements = rootElement.elements("asset-link-group");
        for (Element assetLinkGroupElement : assetLinkGroupElements) {
            String sourceUuid = assetLinkGroupElement.attributeValue("source-uuid");
            AssetEntry sourceAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getScopeGroupId(), (String)sourceUuid);
            if (sourceAssetEntry == null) {
                sourceAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getCompanyGroupId(), (String)sourceUuid);
            }
            if (sourceAssetEntry == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find asset entry with uuid " + sourceUuid));
                continue;
            }
            List assetLinksElements = assetLinkGroupElement.elements("asset-link");
            for (Element assetLinkElement : assetLinksElements) {
                String path = assetLinkElement.attributeValue("path");
                if (!portletDataContext.isPathNotProcessed(path)) continue;
                String targetUuid = assetLinkElement.attributeValue("target-uuid");
                AssetEntry targetAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getScopeGroupId(), (String)targetUuid);
                if (targetAssetEntry == null) {
                    targetAssetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)portletDataContext.getCompanyGroupId(), (String)targetUuid);
                }
                if (targetAssetEntry == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to find asset entry with uuid " + targetUuid));
                    continue;
                }
                AssetLink assetLink = (AssetLink)portletDataContext.getZipEntryAsObject(path);
                long userId = portletDataContext.getUserId(assetLink.getUserUuid());
                AssetLinkLocalServiceUtil.updateLink((long)userId, (long)sourceAssetEntry.getEntryId(), (long)targetAssetEntry.getEntryId(), (int)assetLink.getType(), (int)assetLink.getWeight());
            }
        }
    }

    protected void readAssetTags(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/tags.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetTagElements = rootElement.elements("tag");
        for (Element assetTagElement : assetTagElements) {
            String path = assetTagElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetTag assetTag = (AssetTag)portletDataContext.getZipEntryAsObject(path);
            Map assetTagPKs = portletDataContext.getNewPrimaryKeysMap(AssetTag.class);
            this.importAssetTag(portletDataContext, assetTagPKs, assetTagElement, assetTag);
        }
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String className = GetterUtil.getString((String)assetElement.attributeValue("class-name"));
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            String assetTagNames = GetterUtil.getString((String)assetElement.attributeValue("tags"));
            portletDataContext.addAssetTags(className, classPK, StringUtil.split((String)assetTagNames));
        }
    }

    protected void readExpandoTables(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/expando-tables.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List expandoTableElements = rootElement.elements("expando-table");
        for (Element expandoTableElement : expandoTableElements) {
            String className = expandoTableElement.attributeValue("class-name");
            ExpandoTable expandoTable = null;
            try {
                expandoTable = ExpandoTableLocalServiceUtil.getDefaultTable((long)portletDataContext.getCompanyId(), (String)className);
            }
            catch (NoSuchTableException nste) {
                expandoTable = ExpandoTableLocalServiceUtil.addDefaultTable((long)portletDataContext.getCompanyId(), (String)className);
            }
            List expandoColumnElements = expandoTableElement.elements("expando-column");
            for (Element expandoColumnElement : expandoColumnElements) {
                long columnId = GetterUtil.getLong((String)expandoColumnElement.attributeValue("column-id"));
                String name = expandoColumnElement.attributeValue("name");
                int type = GetterUtil.getInteger((String)expandoColumnElement.attributeValue("type"));
                String defaultData = expandoColumnElement.elementText("default-data");
                String typeSettings = expandoColumnElement.elementText("type-settings");
                Serializable defaultDataObject = ExpandoConverterUtil.getAttributeFromString(type, defaultData);
                ExpandoColumn expandoColumn = ExpandoColumnLocalServiceUtil.getColumn((long)expandoTable.getTableId(), (String)name);
                if (expandoColumn != null) {
                    ExpandoColumnLocalServiceUtil.updateColumn((long)expandoColumn.getColumnId(), (String)name, (int)type, (Object)defaultDataObject);
                } else {
                    expandoColumn = ExpandoColumnLocalServiceUtil.addColumn((long)expandoTable.getTableId(), (String)name, (int)type, (Object)defaultDataObject);
                }
                ExpandoColumnLocalServiceUtil.updateTypeSettings((long)expandoColumn.getColumnId(), (String)typeSettings);
                portletDataContext.importPermissions(ExpandoColumn.class, columnId, expandoColumn.getColumnId());
            }
        }
    }

    protected void readLocks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/locks.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            String key = assetElement.attributeValue("key");
            Lock lock = (Lock)portletDataContext.getZipEntryAsObject(path);
            if (lock == null) continue;
            portletDataContext.addLocks(className, key, lock);
        }
    }

    protected void resetPortletScope(PortletDataContext portletDataContext, long groupId) {
        portletDataContext.setScopeGroupId(groupId);
        portletDataContext.setScopeLayoutUuid("");
        portletDataContext.setScopeType("");
    }

    protected void updatePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, long plid, String portletId, String xml, boolean importData) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not update portlet preferences for " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (importData || !MergeLayoutPrototypesThreadLocal.isInProgress()) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
            return;
        }
        Object[] dataPortletPreferences = portletDataHandler.getDataPortletPreferences();
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromXML((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Enumeration enu = jxPortletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String scopeLayoutUuid = portletDataContext.getScopeLayoutUuid();
            String scopeType = portletDataContext.getScopeType();
            if (ArrayUtil.contains((Object[])dataPortletPreferences, (Object)name) && (!Validator.isNull((String)scopeLayoutUuid) || !scopeType.equals("company"))) continue;
            String[] values = jxPortletPreferences.getValues(name, null);
            portletPreferences.setValues(name, values);
        }
        PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (PortletPreferences)portletPreferences);
    }

    protected void validateFile(long companyId, long groupId, String portletId, ZipReader zipReader) throws Exception {
        String xml = zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException((Throwable)e);
        }
        int buildNumber = ReleaseInfo.getBuildNumber();
        Element headerElement = rootElement.element("header");
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = headerElement.attributeValue("type");
        if (!larType.equals("portlet")) {
            throw new LARTypeException(larType);
        }
        String rootPortletId = headerElement.attributeValue("root-portlet-id");
        if (!PortletConstants.getRootPortletId((String)portletId).equals(rootPortletId)) {
            throw new PortletIdException("Invalid portlet id " + rootPortletId);
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler.isDataLocalized()) {
            Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)headerElement.attributeValue("available-locales")));
            Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales((long)PortalUtil.getSiteGroupId((long)groupId));
            for (Locale sourceAvailableLocale : sourceAvailableLocales) {
                if (ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) continue;
                LocaleException le = new LocaleException(2, "Locale " + sourceAvailableLocale + " is not " + "available in company " + companyId);
                le.setSourceAvailableLocales(sourceAvailableLocales);
                le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
                throw le;
            }
        }
    }

    private PortletImporter() {
    }
}

