/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventExporter;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.util.xml.DocUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

public class PortletExporter {
    private static Log _log = LogFactoryUtil.getLog(PortletExporter.class);
    private static PortletExporter _instance = new PortletExporter();
    private DeletionSystemEventExporter _deletionSystemEventExporter = DeletionSystemEventExporter.getInstance();
    private PermissionExporter _permissionExporter = PermissionExporter.getInstance();

    public static PortletExporter getInstance() {
        return _instance;
    }

    public void exportPortletData(PortletDataContext portletDataContext, Portlet portlet, Layout layout, PortletPreferences jxPortletPreferences, Element parentElement) throws Exception {
        boolean staged;
        if (portlet == null) {
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            return;
        }
        String portletId = portlet.getPortletId();
        Group liveGroup = layout.getGroup();
        if (liveGroup.isStagingGroup()) {
            liveGroup = liveGroup.getLiveGroup();
        }
        if (!(staged = liveGroup.isStagedPortlet(portlet.getRootPortletId())) && ExportImportThreadLocal.isLayoutExportInProcess()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because it is configured not to be staged"));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)portletId));
        sb.append("/");
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append(layout.getPlid());
        } else {
            sb.append(portletDataContext.getScopeGroupId());
        }
        sb.append("/portlet-data.xml");
        String path = sb.toString();
        if (portletDataContext.isPathProcessed(path)) {
            return;
        }
        String data = null;
        long groupId = portletDataContext.getGroupId();
        portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        portletDataContext.clearScopedPrimaryKeys();
        try {
            data = portletDataHandler.exportData(portletDataContext, portletId, jxPortletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            portletDataContext.setGroupId(groupId);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        Element portletDataElement = parentElement.addElement("portlet-data");
        portletDataElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, data);
        Date endDate = portletDataContext.getEndDate();
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (updateLastPublishDate) {
            StagingUtil.updateLastPublishDate((String)portletId, (PortletPreferences)jxPortletPreferences, (Date)endDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)true);
            File file = this.doExportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)false);
        }
    }

    protected File doExportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (!(layout.isTypeControlPanel() || layout.isTypePanel() || layout.isTypePortlet())) {
            throw new LayoutImportException("Layout type " + layout.getType() + " is not valid");
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(layout.getCompanyId());
            serviceContext.setSignedIn(false);
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        long layoutSetBranchId = MapUtil.getLong(parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        long scopeGroupId = groupId;
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
        String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
        if (Validator.isNotNull((String)scopeType)) {
            Group scopeGroup = null;
            if (scopeType.equals("company")) {
                scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
            } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                scopeGroup = layout.getScopeGroup();
            }
            if (scopeGroup != null) {
                scopeGroupId = scopeGroup.getGroupId();
            }
        }
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)layout.getCompanyId(), (long)scopeGroupId, parameterMap, (Date)startDate, (Date)endDate, (ZipWriter)zipWriter);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPlid(plid);
        portletDataContext.setOldPlid(plid);
        portletDataContext.setScopeType(scopeType);
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales((long)PortalUtil.getSiteGroupId((long)portletDataContext.getScopeGroupId()))));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("type", "portlet");
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(scopeGroupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        headerElement.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        Map exportPortletControlsMap = ExportImportHelperUtil.getExportPortletControlsMap((long)layout.getCompanyId(), (String)portletId, parameterMap);
        this.exportPortlet(portletDataContext, portletId, layout, rootElement, exportPermissions, (Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)exportPortletControlsMap.get("PORTLET_DATA"), (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"), (Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        this.exportService(portletDataContext, portletId, rootElement, (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"));
        this.exportAssetLinks(portletDataContext);
        this.exportAssetTags(portletDataContext);
        this.exportExpandoTables(portletDataContext);
        this.exportLocks(portletDataContext);
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        ExportImportHelperUtil.writeManifestSummary((Document)document, (ManifestSummary)portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return zipWriter.getFile();
    }

    protected void exportAssetLinks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("links");
        Map assetLinksMap = portletDataContext.getAssetLinksMap();
        for (Map.Entry entry : assetLinksMap.entrySet()) {
            String[] assetLinkNameParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            List assetLinks = (List)entry.getValue();
            String sourceAssetEntryUuid = assetLinkNameParts[0];
            Element assetElement = rootElement.addElement("asset-link-group");
            assetElement.addAttribute("source-uuid", sourceAssetEntryUuid);
            for (AssetLink assetLink : assetLinks) {
                String path = this.getAssetLinkPath(portletDataContext, assetLink.getLinkId());
                if (!portletDataContext.isPathNotProcessed(path)) {
                    return;
                }
                Element assetLinkElement = assetElement.addElement("asset-link");
                assetLinkElement.addAttribute("path", path);
                AssetEntry targetAssetEntry = AssetEntryLocalServiceUtil.fetchAssetEntry((long)assetLink.getEntryId2());
                assetLinkElement.addAttribute("target-uuid", targetAssetEntry.getClassUuid());
                portletDataContext.addZipEntry(path, (Object)assetLink);
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/links.xml", document.formattedString());
    }

    protected void exportAssetTag(PortletDataContext portletDataContext, AssetTag assetTag, Element assetTagsElement) throws PortalException {
        String path = this.getAssetTagPath(portletDataContext, assetTag.getTagId());
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element assetTagElement = assetTagsElement.addElement("tag");
        assetTagElement.addAttribute("path", path);
        assetTag.setUserUuid(assetTag.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetTag);
        List assetTagProperties = AssetTagPropertyLocalServiceUtil.getTagProperties((long)assetTag.getTagId());
        for (AssetTagProperty assetTagProperty : assetTagProperties) {
            Element propertyElement = assetTagElement.addElement("property");
            propertyElement.addAttribute("key", assetTagProperty.getKey());
            propertyElement.addAttribute("value", assetTagProperty.getValue());
        }
        portletDataContext.addPermissions(AssetTag.class, assetTag.getTagId());
    }

    protected void exportAssetTags(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("tags");
        Map assetTagNamesMap = portletDataContext.getAssetTagNamesMap();
        if (assetTagNamesMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : assetTagNamesMap.entrySet()) {
            String[] assetTagNameParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = assetTagNameParts[0];
            String classPK = assetTagNameParts[1];
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            assetElement.addAttribute("tags", StringUtil.merge((Object[])((Object[])entry.getValue())));
            List assetTags = AssetTagLocalServiceUtil.getTags((String)className, (long)GetterUtil.getLong((String)classPK));
            for (AssetTag assetTag : assetTags) {
                this.exportAssetTag(portletDataContext, assetTag, rootElement);
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/tags.xml", document.formattedString());
    }

    protected void exportExpandoTables(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("expando-tables");
        Map expandoColumnsMap = portletDataContext.getExpandoColumns();
        for (Map.Entry entry : expandoColumnsMap.entrySet()) {
            String className = (String)entry.getKey();
            Element expandoTableElement = rootElement.addElement("expando-table");
            expandoTableElement.addAttribute("class-name", className);
            List expandoColumns = (List)entry.getValue();
            for (ExpandoColumn expandoColumn : expandoColumns) {
                Element expandoColumnElement = expandoTableElement.addElement("expando-column");
                expandoColumnElement.addAttribute("column-id", String.valueOf(expandoColumn.getColumnId()));
                expandoColumnElement.addAttribute("name", expandoColumn.getName());
                expandoColumnElement.addAttribute("type", String.valueOf(expandoColumn.getType()));
                DocUtil.add((Element)expandoColumnElement, (String)"default-data", (String)expandoColumn.getDefaultData());
                Element typeSettingsElement = expandoColumnElement.addElement("type-settings");
                UnicodeProperties typeSettingsProperties = expandoColumn.getTypeSettingsProperties();
                typeSettingsElement.addCDATA(typeSettingsProperties.toString());
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/expando-tables.xml", document.formattedString());
    }

    protected void exportLocks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("locks");
        Map locksMap = portletDataContext.getLocks();
        for (Map.Entry entry : locksMap.entrySet()) {
            Lock lock = (Lock)entry.getValue();
            String entryKey = (String)entry.getKey();
            int pos = entryKey.indexOf(35);
            String className = entryKey.substring(0, pos);
            String key = entryKey.substring(pos + 1);
            String path = this.getLockPath(portletDataContext, className, key, lock);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", path);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("key", key);
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            portletDataContext.addZipEntry(path, (Object)lock);
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/locks.xml", document.formattedString());
    }

    protected void exportPortlet(PortletDataContext portletDataContext, String portletId, Layout layout, Element parentElement, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences) throws Exception {
        Portlet portlet;
        long plid = 0L;
        long layoutId = 0L;
        if (layout != null) {
            plid = layout.getPlid();
            layoutId = layout.getLayoutId();
        }
        if ((portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not export portlet " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && portletDataContext.hasNotUniquePerLayout(portletId)) {
            return;
        }
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            PortletDataContext clonedPortletDataContext = PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext);
            ManifestSummary manifestSummary = clonedPortletDataContext.getManifestSummary();
            manifestSummary.resetCounters();
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            portletDataHandler.prepareManifestSummary(clonedPortletDataContext);
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
        }
        Document document = SAXReaderUtil.createDocument();
        Element portletElement = document.addElement("portlet");
        portletElement.addAttribute("portlet-id", portletId);
        portletElement.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        portletElement.addAttribute("old-plid", String.valueOf(plid));
        portletElement.addAttribute("scope-group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        portletElement.addAttribute("scope-layout-type", portletDataContext.getScopeType());
        portletElement.addAttribute("scope-layout-uuid", portletDataContext.getScopeLayoutUuid());
        portletElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        if (exportPortletData) {
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
            if (!portlet.isPreferencesUniquePerLayout()) {
                StringBundler sb = new StringBundler(5);
                sb.append(portletId);
                sb.append("@");
                sb.append(portletDataContext.getScopeType());
                sb.append("@");
                sb.append(portletDataContext.getScopeLayoutUuid());
                String dataKey = sb.toString();
                if (!portletDataContext.hasNotUniquePerLayout(dataKey)) {
                    portletDataContext.putNotUniquePerLayout(dataKey);
                    this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
                }
            } else {
                this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
            }
        }
        if (exportPortletSetup) {
            this.exportPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, false, layout, plid, portlet.getRootPortletId(), portletElement);
            this.exportPortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, layout, 0L, portlet.getRootPortletId(), portletElement);
            this.exportPortletPreferences(portletDataContext, 0L, 3, false, layout, plid, portletId, portletElement);
        }
        if (exportPortletUserPreferences) {
            List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((int)4, (long)plid, (String)portletId);
            for (com.liferay.portal.model.PortletPreferences portletPreferences : portletPreferencesList) {
                boolean defaultUser = false;
                if (portletPreferences.getOwnerId() == 0L) {
                    defaultUser = true;
                }
                this.exportPortletPreferences(portletDataContext, portletPreferences.getOwnerId(), 4, defaultUser, layout, plid, portletId, portletElement);
            }
            try {
                com.liferay.portal.model.PortletPreferences groupPortletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)portletDataContext.getScopeGroupId(), (int)2, (long)0L, (String)portlet.getRootPortletId());
                this.exportPortletPreference(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, groupPortletPreferences, portlet.getRootPortletId(), 0L, portletElement);
            }
            catch (NoSuchPortletPreferencesException nsppe) {
                // empty catch block
            }
        }
        if (exportPortletArchivedSetups) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            List portletItems = PortletItemLocalServiceUtil.getPortletItems((long)portletDataContext.getGroupId(), (String)rootPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
            for (PortletItem portletItem : portletItems) {
                this.exportPortletPreferences(portletDataContext, portletItem.getPortletItemId(), 5, false, null, plid, portletItem.getPortletId(), portletElement);
            }
        }
        if (exportPermissions) {
            this._permissionExporter.exportPortletPermissions(portletDataContext, portletId, layout, portletElement);
        }
        StringBundler pathSB = new StringBundler(4);
        pathSB.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)portletId));
        pathSB.append("/");
        pathSB.append(plid);
        pathSB.append("/portlet.xml");
        String path = pathSB.toString();
        Element element = parentElement.addElement("portlet");
        element.addAttribute("portlet-id", portletId);
        element.addAttribute("layout-id", String.valueOf(layoutId));
        element.addAttribute("path", path);
        element.addAttribute("portlet-data", String.valueOf(exportPortletData));
        StringBundler configurationOptionsSB = new StringBundler(6);
        if (exportPortletSetup) {
            configurationOptionsSB.append("setup");
            configurationOptionsSB.append(",");
        }
        if (exportPortletArchivedSetups) {
            configurationOptionsSB.append("archived-setups");
            configurationOptionsSB.append(",");
        }
        if (exportPortletUserPreferences) {
            configurationOptionsSB.append("user-preferences");
            configurationOptionsSB.append(",");
        }
        if (configurationOptionsSB.index() > 0) {
            configurationOptionsSB.setIndex(configurationOptionsSB.index() - 1);
        }
        element.addAttribute("portlet-configuration", configurationOptionsSB.toString());
        if (portletDataContext.isPathNotProcessed(path)) {
            block25: {
                try {
                    portletDataContext.addZipEntry(path, document.formattedString());
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block25;
                    _log.warn((Object)ioe.getMessage());
                }
            }
            portletDataContext.addPrimaryKey(String.class, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportPortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, com.liferay.portal.model.PortletPreferences portletPreferences, String portletId, long plid, Element parentElement) throws Exception {
        String preferencesXML = portletPreferences.getPreferences();
        if (Validator.isNull((String)preferencesXML)) {
            preferencesXML = "<portlet-preferences />";
        }
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        Element portletPreferencesElement = parentElement.addElement("portlet-preferences");
        if (portlet != null && portlet.getPortletDataHandlerInstance() != null) {
            Element exportDataRootElement = portletDataContext.getExportDataRootElement();
            try {
                portletDataContext.clearScopedPrimaryKeys();
                Element preferenceDataElement = portletPreferencesElement.addElement("preference-data");
                portletDataContext.setExportDataRootElement(preferenceDataElement);
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                jxPortletPreferences = portletDataHandler.processExportPortletPreferences(portletDataContext, portletId, jxPortletPreferences);
            }
            finally {
                portletDataContext.setExportDataRootElement(exportDataRootElement);
            }
        }
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(defaultUser));
        rootElement.addAttribute("plid", String.valueOf(plid));
        rootElement.addAttribute("portlet-id", portletId);
        if (ownerType == 5) {
            PortletItem portletItem = PortletItemLocalServiceUtil.getPortletItem((long)ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = UserLocalServiceUtil.fetchUserById((long)ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            document.remove(node);
        }
        String path = ExportImportPathUtil.getPortletPreferencesPath((PortletDataContext)portletDataContext, (String)portletId, (long)ownerId, (int)ownerType, (long)plid);
        portletPreferencesElement.addAttribute("path", path);
        if (portletDataContext.isPathNotProcessed(path)) {
            portletDataContext.addZipEntry(path, document.formattedString("\t", false, false));
        }
    }

    protected void exportPortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, Layout layout, long plid, String portletId, Element parentElement) throws Exception {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = this.getPortletPreferences(ownerId, ownerType, plid, portletId);
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = null;
        if (layout != null) {
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        }
        if (layoutTypePortlet == null || layoutTypePortlet.hasPortletId(portletId)) {
            this.exportPortletPreference(portletDataContext, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentElement);
        }
    }

    protected void exportService(PortletDataContext portletDataContext, String portletId, Element rootElement, boolean exportServiceSetup) throws Exception {
        if (!exportServiceSetup) {
            return;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        String serviceName = portletDataHandler.getServiceName();
        if (Validator.isNotNull((String)serviceName)) {
            this.exportServicePortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, serviceName, rootElement);
            this.exportServicePortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, serviceName, rootElement);
        }
    }

    protected void exportServicePortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, com.liferay.portal.model.PortletPreferences portletPreferences, String serviceName, Element parentElement) throws Exception {
        String path = ExportImportPathUtil.getServicePortletPreferencesPath((PortletDataContext)portletDataContext, (String)serviceName, (long)ownerId, (int)ownerType);
        if (portletDataContext.isPathProcessed(path)) {
            return;
        }
        String preferencesXML = portletPreferences.getPreferences();
        if (Validator.isNull((String)preferencesXML)) {
            preferencesXML = "<portlet-preferences />";
        }
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML);
        Element serviceElement = parentElement.addElement("service");
        serviceElement.addAttribute("service-name", serviceName);
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(false));
        rootElement.addAttribute("service-name", serviceName);
        if (ownerType == 5) {
            PortletItem portletItem = PortletItemLocalServiceUtil.getPortletItem((long)ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = UserLocalServiceUtil.fetchUserById((long)ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            document.remove(node);
        }
        serviceElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, document.formattedString());
    }

    protected void exportServicePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, String serviceName, Element parentElement) throws Exception {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = this.getPortletPreferences(ownerId, ownerType, 0L, serviceName);
        }
        catch (NoSuchPortletPreferencesException nsppe) {
            return;
        }
        this.exportServicePortletPreference(portletDataContext, ownerId, ownerType, portletPreferences, serviceName, parentElement);
    }

    protected String getAssetLinkPath(PortletDataContext portletDataContext, long assetLinkId) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/links/");
        sb.append(assetLinkId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getAssetTagPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/tags/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getLockPath(PortletDataContext portletDataContext, String className, String key, Lock lock) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/locks/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(key);
        sb.append('/');
        sb.append(lock.getLockId());
        sb.append(".xml");
        return sb.toString();
    }

    protected com.liferay.portal.model.PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        portletPreferences = ownerType == 5 || ownerType == 1 || ownerType == 2 ? PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)0L, (String)portletId) : PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        return portletPreferences;
    }

    private PortletExporter() {
    }
}

