/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchTeamException;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PermissionImporter {
    private static PermissionImporter _instance = new PermissionImporter();

    public static PermissionImporter getInstance() {
        return _instance;
    }

    protected Role checkRole(LayoutCache layoutCache, long companyId, long groupId, long userId, Element roleElement) throws Exception {
        String name = roleElement.attributeValue("name");
        Role role = null;
        if (name.startsWith("ROLE_TEAM_,*")) {
            name = name.substring("ROLE_TEAM_,*".length());
            String description = roleElement.attributeValue("description");
            Team team = null;
            try {
                team = TeamLocalServiceUtil.getTeam((long)groupId, (String)name);
            }
            catch (NoSuchTeamException nste) {
                team = TeamLocalServiceUtil.addTeam((long)userId, (long)groupId, (String)name, (String)description);
            }
            role = RoleLocalServiceUtil.getTeamRole((long)companyId, (long)team.getTeamId());
        } else {
            role = layoutCache.getRole(companyId, name);
        }
        if (role == null) {
            String title = roleElement.attributeValue("title");
            Map titleMap = LocalizationUtil.getLocalizationMap((String)title);
            String description = roleElement.attributeValue("description");
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String)description);
            int type = GetterUtil.getInteger((String)roleElement.attributeValue("type"));
            String subtype = roleElement.attributeValue("subtype");
            role = RoleLocalServiceUtil.addRole((long)userId, null, (long)0L, (String)name, (Map)titleMap, (Map)descriptionMap, (int)type, (String)subtype, null);
        }
        return role;
    }

    protected void checkRoles(LayoutCache layoutCache, long companyId, long groupId, long userId, Element portletElement) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (permissionsElement == null) {
            return;
        }
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            this.checkRole(layoutCache, companyId, groupId, userId, roleElement);
        }
    }

    protected List<String> getActions(Element element) {
        ArrayList<String> actions = new ArrayList<String>();
        List actionKeyElements = element.elements("action-key");
        for (Element actionKeyElement : actionKeyElements) {
            actions.add(actionKeyElement.getText());
        }
        return actions;
    }

    protected void importPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, String resourceName, String resourcePrimKey, Element permissionsElement, boolean portletActions) throws Exception {
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            String roleName;
            Role role = this.checkRole(layoutCache, companyId, groupId, userId, roleElement);
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.isLayoutPrototype() && !group.isLayoutSetPrototype() && layout.isPrivateLayout() && (roleName = role.getName()).equals("Guest")) continue;
            List<String> actions = this.getActions(roleElement);
            roleIdsToActionIds.put(role.getRoleId(), actions.toArray(new String[actions.size()]));
        }
        if (roleIdsToActionIds.isEmpty()) {
            return;
        }
        ResourcePermissionLocalServiceUtil.setResourcePermissions((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, roleIdsToActionIds);
    }

    protected void importPortletPermissions(LayoutCache layoutCache, long companyId, long groupId, long userId, Layout layout, Element portletElement, String portletId) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (layout != null && permissionsElement != null) {
            String resourceName = PortletConstants.getRootPortletId((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            this.importPermissions(layoutCache, companyId, groupId, userId, layout, resourceName, resourcePrimKey, permissionsElement, true);
        }
    }

    protected void readPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/portlet-data-permissions.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List portletDataElements = rootElement.elements("portlet-data");
        for (Element portletDataElement : portletDataElements) {
            String resourceName = portletDataElement.attributeValue("resource-name");
            long resourcePK = GetterUtil.getLong((String)portletDataElement.attributeValue("resource-pk"));
            ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
            List permissionsElements = portletDataElement.elements("permissions");
            for (Element permissionsElement : permissionsElements) {
                String roleName = permissionsElement.attributeValue("role-name");
                String actions = permissionsElement.attributeValue("actions");
                KeyValuePair permission = new KeyValuePair(roleName, actions);
                permissions.add(permission);
            }
            portletDataContext.addPermissions(resourceName, resourcePK, permissions);
        }
    }

    private PermissionImporter() {
    }
}

