/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionExporter {
    public static final String ROLE_TEAM_PREFIX = "ROLE_TEAM_,*";
    private static PermissionExporter _instance = new PermissionExporter();

    public static PermissionExporter getInstance() {
        return _instance;
    }

    protected void exportPermissions(PortletDataContext portletDataContext, String resourceName, String resourcePrimKey, Element permissionsElement) throws Exception {
        List actionIds = ResourceActionsUtil.getPortletResourceActions((String)resourceName);
        Map roleToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)portletDataContext.getCompanyId(), (String)resourceName, (int)4, (String)resourcePrimKey, (Collection)actionIds);
        for (Map.Entry entry : roleToActionIds.entrySet()) {
            long roleId = (Long)entry.getKey();
            Role role = RoleLocalServiceUtil.fetchRole((long)roleId);
            Element roleElement = permissionsElement.addElement("role");
            roleElement.addAttribute("name", role.getName());
            roleElement.addAttribute("title", role.getTitle());
            roleElement.addAttribute("description", role.getDescription());
            roleElement.addAttribute("type", String.valueOf(role.getType()));
            roleElement.addAttribute("subtype", role.getSubtype());
            Set availableActionIds = (Set)entry.getValue();
            for (String actionId : availableActionIds) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(actionId);
            }
        }
    }

    protected void exportPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("portlet-data-permissions");
        Map permissionsMap = portletDataContext.getPermissions();
        for (Map.Entry entry : permissionsMap.entrySet()) {
            String[] permissionParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String resourceName = permissionParts[0];
            long resourcePK = GetterUtil.getLong((String)permissionParts[1]);
            Element portletDataElement = rootElement.addElement("portlet-data");
            portletDataElement.addAttribute("resource-name", resourceName);
            portletDataElement.addAttribute("resource-pk", String.valueOf(resourcePK));
            List permissions = (List)entry.getValue();
            for (KeyValuePair permission : permissions) {
                String roleName = permission.getKey();
                String actions = permission.getValue();
                Element permissionsElement = portletDataElement.addElement("permissions");
                permissionsElement.addAttribute("role-name", roleName);
                permissionsElement.addAttribute("actions", actions);
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/portlet-data-permissions.xml", document.formattedString());
    }

    protected void exportPortletPermissions(PortletDataContext portletDataContext, String portletId, Layout layout, Element portletElement) throws Exception {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
        Element permissionsElement = portletElement.addElement("permissions");
        this.exportPermissions(portletDataContext, resourceName, resourcePrimKey, permissionsElement);
    }

    private PermissionExporter() {
    }
}

