/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.MissingReferenceException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchLayoutPrototypeException;
import com.liferay.portal.NoSuchLayoutSetPrototypeException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.lar.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventImporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.lar.ThemeImporter;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

public class LayoutImporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutImporter.class);
    private static LayoutImporter _instance = new LayoutImporter();
    private DeletionSystemEventImporter _deletionSystemEventImporter = DeletionSystemEventImporter.getInstance();
    private PermissionImporter _permissionImporter = PermissionImporter.getInstance();
    private PortletImporter _portletImporter = PortletImporter.getInstance();
    private ThemeImporter _themeImporter = ThemeImporter.getInstance();

    public static LayoutImporter getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            this.doImportLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        finally {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MissingReferences validateFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)true);
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
            this.validateFile(layoutSet.getCompanyId(), groupId, parameterMap, zipReader);
            String userIdStrategyString = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
            UserIdStrategy userIdStrategy = ExportImportHelperUtil.getUserIdStrategy((long)userId, (String)userIdStrategyString);
            PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)layoutSet.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
            portletDataContext.setPrivateLayout(privateLayout);
            MissingReferences missingReferences = ExportImportHelperUtil.validateMissingReferences((PortletDataContext)portletDataContext);
            Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
            if (!dependencyMissingReferences.isEmpty()) {
                throw new MissingReferenceException(missingReferences);
            }
            MissingReferences missingReferences2 = missingReferences;
            return missingReferences2;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
        }
    }

    protected void deleteMissingLayouts(PortletDataContext portletDataContext, List<String> sourceLayoutUuids, List<Layout> previousLayouts, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled() && !sourceLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        for (Layout layout : previousLayouts) {
            if (sourceLayoutUuids.contains(layout.getUuid()) || layoutPlids.containsValue(layout.getPlid())) continue;
            try {
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
            catch (NoSuchLayoutException nsle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        boolean deleteMissingLayouts = MapUtil.getBoolean(parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean importLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayoutSetPrototype()) {
            layoutSetPrototypeLinkEnabled = false;
        }
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        String userIdStrategyString = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete portlet data " + deletePortletData));
            _log.debug((Object)("Import permissions " + importPermissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(userId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        this.validateFile(companyId, groupId, parameterMap, zipReader);
        UserIdStrategy userIdStrategy = ExportImportHelperUtil.getUserIdStrategy((long)userId, (String)userIdStrategyString);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)companyId, (long)groupId, parameterMap, (UserIdStrategy)userIdStrategy, (ZipReader)zipReader);
        portletDataContext.setPrivateLayout(privateLayout);
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceGroupId(), groupId);
        ManifestSummary manifestSummary = ExportImportHelperUtil.getManifestSummary((PortletDataContext)portletDataContext);
        portletDataContext.setManifestSummary(manifestSummary);
        Element layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        String layoutSetPrototypeUuid = layoutsElement.attributeValue("layout-set-prototype-uuid");
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element headerElement = rootElement.element("header");
        String larType = headerElement.attributeValue("type");
        if (group.isLayoutPrototype() && larType.equals("layout-prototype")) {
            deleteMissingLayouts = false;
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            String layoutPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
            LayoutPrototype existingLayoutPrototype = null;
            if (Validator.isNotNull((String)layoutPrototypeUuid)) {
                try {
                    existingLayoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)companyId);
                }
                catch (NoSuchLayoutPrototypeException nslpe) {
                    // empty catch block
                }
            }
            if (existingLayoutPrototype == null) {
                List layouts = LayoutLocalServiceUtil.getLayoutsByLayoutPrototypeUuid((String)layoutPrototype.getUuid());
                layoutPrototype.setUuid(layoutPrototypeUuid);
                LayoutPrototypeLocalServiceUtil.updateLayoutPrototype((LayoutPrototype)layoutPrototype);
                for (Layout layout : layouts) {
                    layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
                    LayoutLocalServiceUtil.updateLayout((Layout)layout);
                }
            }
        } else if (group.isLayoutSetPrototype() && larType.equals("layout-set-prototype")) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            String importedLayoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
            LayoutSetPrototype existingLayoutSetPrototype = null;
            if (Validator.isNotNull((String)importedLayoutSetPrototypeUuid)) {
                try {
                    existingLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)importedLayoutSetPrototypeUuid, (long)companyId);
                }
                catch (NoSuchLayoutSetPrototypeException nslspe) {
                    // empty catch block
                }
            }
            if (existingLayoutSetPrototype == null) {
                List layoutSets = LayoutSetLocalServiceUtil.getLayoutSetsByLayoutSetPrototypeUuid((String)layoutSetPrototype.getUuid());
                layoutSetPrototype.setUuid(importedLayoutSetPrototypeUuid);
                LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
                for (LayoutSet curLayoutSet : layoutSets) {
                    curLayoutSet.setLayoutSetPrototypeUuid(importedLayoutSetPrototypeUuid);
                    LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)curLayoutSet);
                }
            }
        } else if (larType.equals("layout-set-prototype")) {
            layoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
        }
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        if (importLogo) {
            String logoPath = headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)true, (byte[])iconBytes);
            } else {
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)false, (File)null);
            }
        }
        this._themeImporter.importTheme(portletDataContext, layoutSet);
        if (importLayoutSetSettings) {
            String settings = GetterUtil.getString((String)headerElement.elementText("settings"));
            LayoutSetLocalServiceUtil.updateSettings((long)groupId, (boolean)privateLayout, (String)settings);
        }
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ArrayList<String> portletIds = new ArrayList<String>();
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
                if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
                portletIds.add(portletId);
            }
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"layout", (String[])ArrayUtil.toStringArray(portletIds), (ManifestSummary)manifestSummary);
        }
        if (importPermissions) {
            for (Element portletElement : portletElements) {
                String portletPath = portletElement.attributeValue("path");
                Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
                this._permissionImporter.checkRoles(layoutCache, companyId, groupId, userId, portletDocument.getRootElement());
            }
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        this._portletImporter.readAssetTags(portletDataContext);
        this._portletImporter.readExpandoTables(portletDataContext);
        this._portletImporter.readLocks(portletDataContext);
        HashSet<Layout> modifiedLayouts = new HashSet<Layout>();
        List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            for (Layout layout : previousLayouts) {
                String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) continue;
                if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
                    modifiedLayouts.add(layout);
                    continue;
                }
                Layout sourcePrototypeLayout = LayoutUtil.fetchByUUID_G_P((String)sourcePrototypeLayoutUuid, (long)layoutSetPrototype.getGroupId(), (boolean)true);
                if (sourcePrototypeLayout != null) continue;
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
        }
        List layoutElements = layoutsElement.elements();
        if (_log.isDebugEnabled() && !layoutElements.isEmpty()) {
            _log.debug((Object)"Importing layouts");
        }
        ArrayList<String> sourceLayoutsUuids = new ArrayList<String>();
        for (Element layoutElement : layoutElements) {
            this.importLayout(portletDataContext, sourceLayoutsUuids, layoutElement);
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        if (deletePortletData) {
            if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
                _log.debug((Object)"Deleting portlet data");
            }
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
                long plid = 0L;
                Layout layout = (Layout)layouts.get(layoutId);
                if (layout != null) {
                    plid = layout.getPlid();
                }
                portletDataContext.setPlid(plid);
                this._portletImporter.deletePortletData(portletDataContext, portletId, plid);
            }
        }
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Importing portlets");
        }
        for (Element portletElement : portletElements) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            Layout layout = (Layout)layouts.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                plid = layout.getPlid();
                if (modifiedLayouts.contains(layout)) continue;
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(oldPlid);
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
            }
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = groupId;
            Element portletDataElement = portletElement.element("portlet-data");
            Map importPortletControlsMap = ExportImportHelperUtil.getImportPortletControlsMap((long)companyId, (String)portletId, parameterMap, (Element)portletDataElement, (ManifestSummary)manifestSummary);
            try {
                if (layout != null) {
                    portletPreferencesGroupId = layout.getGroupId();
                }
                this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), portletPreferencesGroupId, layout, null, portletElement, false, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
                if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                    this._portletImporter.importPortletData(portletDataContext, portletId, plid, portletDataElement);
                }
            }
            finally {
                this._portletImporter.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (importPermissions) {
                this._permissionImporter.importPortletPermissions(layoutCache, companyId, groupId, userId, layout, portletElement, portletId);
            }
            this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), groupId, null, null, portletElement, false, (Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)importPortletControlsMap.get("PORTLET_DATA"), (Boolean)importPortletControlsMap.get("PORTLET_SETUP"), (Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        }
        if (importPermissions && userId > 0L) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)userId);
        }
        if (_log.isDebugEnabled() && !portletElements.isEmpty()) {
            _log.debug((Object)"Importing services");
        }
        Element servicesElement = rootElement.element("services");
        List serviceElements = servicesElement.elements("service");
        for (Element serviceElement : serviceElements) {
            String path = serviceElement.attributeValue("path");
            Document serviceDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(path));
            serviceElement = serviceDocument.getRootElement();
            this._portletImporter.importServicePortletPreferences(portletDataContext, serviceElement);
        }
        this._portletImporter.readAssetLinks(portletDataContext);
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(portletDataContext, sourceLayoutsUuids, previousLayouts, serviceContext);
        }
        layoutSet = LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        GroupLocalServiceUtil.updateSite((long)groupId, (boolean)true);
        this.updateLayoutPriorities(portletDataContext, layoutElements, privateLayout);
        if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            long lastMergeTime = System.currentTimeMillis();
            for (Layout layout : layouts.values()) {
                if (modifiedLayouts.contains(layout = LayoutLocalServiceUtil.getLayout((long)layout.getPlid()))) continue;
                UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
                typeSettingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
                LayoutUtil.update((Layout)layout);
            }
            UnicodeProperties settingsProperties = (layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSet.getLayoutSetId())).getSettingsProperties();
            String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
            if (Validator.isNull((String)mergeFailFriendlyURLLayouts) && modifiedLayouts.isEmpty()) {
                settingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
                LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
            }
        }
        this._deletionSystemEventImporter.importDeletionSystemEvents(portletDataContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        zipReader.close();
    }

    protected void importLayout(PortletDataContext portletDataContext, List<String> sourceLayoutsUuids, Element layoutElement) throws Exception {
        String action = layoutElement.attributeValue("action");
        if (!action.equals("skip")) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)layoutElement);
        }
        if (!action.equals("delete")) {
            sourceLayoutsUuids.add(layoutElement.attributeValue("uuid"));
        }
    }

    protected void setPortletScope(PortletDataContext portletDataContext, Element portletElement) {
        String scopeLayoutUuid = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-uuid"));
        String scopeLayoutType = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-type"));
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        portletDataContext.setScopeType(scopeLayoutType);
        try {
            Group scopeGroup;
            block14: {
                scopeGroup = null;
                if (scopeLayoutType.equals("company")) {
                    scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                    boolean privateLayout = GetterUtil.getBoolean((String)portletElement.attributeValue("private-layout"));
                    Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId(), (boolean)privateLayout);
                    if (scopeLayout.hasScopeGroup()) {
                        scopeGroup = scopeLayout.getScopeGroup();
                    } else {
                        String name = String.valueOf(scopeLayout.getPlid());
                        scopeGroup = GroupLocalServiceUtil.addGroup((long)portletDataContext.getUserId(null), (long)0L, (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (long)0L, (String)name, null, (int)0, (boolean)true, (int)0, null, (boolean)false, (boolean)true, null);
                    }
                    Group group = scopeLayout.getGroup();
                    if (group.isStaged() && !group.isStagedRemotely()) {
                        try {
                            Layout oldLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getSourceGroupId(), (boolean)privateLayout);
                            Group oldScopeGroup = oldLayout.getScopeGroup();
                            if (group.isStagingGroup()) {
                                scopeGroup.setLiveGroupId(oldScopeGroup.getGroupId());
                                GroupLocalServiceUtil.updateGroup((Group)scopeGroup);
                            } else {
                                oldScopeGroup.setLiveGroupId(scopeGroup.getGroupId());
                                GroupLocalServiceUtil.updateGroup((Group)oldScopeGroup);
                            }
                        }
                        catch (NoSuchLayoutException nsle) {
                            if (!_log.isWarnEnabled()) break block14;
                            _log.warn((Throwable)nsle);
                        }
                    }
                }
            }
            if (scopeGroup != null) {
                portletDataContext.setScopeGroupId(scopeGroup.getGroupId());
                Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
                long oldScopeGroupId = GetterUtil.getLong((String)portletElement.attributeValue("scope-group-id"));
                groupIds.put(oldScopeGroupId, scopeGroup.getGroupId());
            }
        }
        catch (PortalException pe) {
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void updateLayoutPriorities(PortletDataContext portletDataContext, List<Element> layoutElements, boolean privateLayout) {
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        HashMap<Long, Integer> layoutPriorities = new HashMap<Long, Integer>();
        int maxPriority = Integer.MIN_VALUE;
        for (Element layoutElement : layoutElements) {
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip")) {
                return;
            }
            if (!action.equals("add")) continue;
            long layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id"));
            Layout layout = (Layout)layouts.get(layoutId);
            int layoutPriority = GetterUtil.getInteger((String)layoutElement.attributeValue("layout-priority"));
            layoutPriorities.put(layout.getPlid(), layoutPriority);
            if (maxPriority >= layoutPriority) continue;
            maxPriority = layoutPriority;
        }
        List layoutSetLayouts = LayoutLocalServiceUtil.getLayouts((long)portletDataContext.getGroupId(), (boolean)privateLayout);
        for (Layout layout : layoutSetLayouts) {
            if (layoutPriorities.containsKey(layout.getPlid())) {
                layout.setPriority(((Integer)layoutPriorities.get(layout.getPlid())).intValue());
            } else {
                layout.setPriority(++maxPriority);
            }
            LayoutLocalServiceUtil.updateLayout((Layout)layout);
        }
    }

    protected void validateFile(long companyId, long groupId, Map<String, String[]> parameterMap, ZipReader zipReader) throws Exception {
        String xml = zipReader.getEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException((Throwable)e);
        }
        int buildNumber = ReleaseInfo.getBuildNumber();
        Element headerElement = rootElement.element("header");
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = headerElement.attributeValue("type");
        if (!(larType.equals("layout-prototype") || larType.equals("layout-set") || larType.equals("layout-set-prototype"))) {
            throw new LARTypeException(larType);
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE");
        if (larType.equals("layout-prototype") && !group.isLayoutPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException("A page template can only be imported to a page template");
        }
        if (larType.equals("layout-set")) {
            if (group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
                throw new LARTypeException("A site can only be imported to a site");
            }
            long sourceCompanyGroupId = GetterUtil.getLong((String)headerElement.attributeValue("company-group-id"));
            long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
            if (group.isCompany() ^ sourceCompanyGroupId == sourceGroupId) {
                throw new LARTypeException("A company site can only be imported to a company site");
            }
        }
        if (larType.equals("layout-set-prototype") && !group.isLayoutSetPrototype() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            throw new LARTypeException("A site template can only be imported to a site template");
        }
        Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)headerElement.attributeValue("available-locales")));
        Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales((long)groupId);
        for (Locale sourceAvailableLocale : sourceAvailableLocales) {
            if (ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) continue;
            LocaleException le = new LocaleException(2);
            le.setSourceAvailableLocales(sourceAvailableLocales);
            le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
            throw le;
        }
        Element layoutsElement = rootElement.element(Layout.class.getSimpleName());
        this.validateLayoutPrototypes(companyId, layoutsElement);
    }

    protected void validateLayoutPrototypes(long companyId, Element layoutsElement) throws Exception {
        ArrayList<Tuple> missingLayoutPrototypes = new ArrayList<Tuple>();
        String layoutSetPrototypeUuid = layoutsElement.attributeValue("layout-set-prototype-uuid");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            try {
                LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            }
            catch (NoSuchLayoutSetPrototypeException nlspe) {
                String layoutSetPrototypeName = layoutsElement.attributeValue("layout-set-prototype-name");
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutSetPrototype.class.getName(), layoutSetPrototypeUuid, layoutSetPrototypeName}));
            }
        }
        List layoutElements = layoutsElement.elements();
        for (Element layoutElement : layoutElements) {
            String layoutPrototypeUuid;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip") || !Validator.isNotNull((String)(layoutPrototypeUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-uuid"))))) continue;
            try {
                LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuidAndCompanyId((String)layoutPrototypeUuid, (long)companyId);
            }
            catch (NoSuchLayoutPrototypeException nslpe) {
                String layoutPrototypeName = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-name"));
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
            }
        }
        if (!missingLayoutPrototypes.isEmpty()) {
            throw new LayoutPrototypeException(missingLayoutPrototypes);
        }
    }

    private LayoutImporter() {
        XStreamAliasRegistryUtil.register(LayoutImpl.class, (String)"Layout");
    }
}

