/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventExporter;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.lar.ThemeExporter;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

public class LayoutExporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutExporter.class);
    private static LayoutExporter _instance = new LayoutExporter();
    private DeletionSystemEventExporter _deletionSystemEventExporter = DeletionSystemEventExporter.getInstance();
    private PermissionExporter _permissionExporter = PermissionExporter.getInstance();
    private PortletExporter _portletExporter = PortletExporter.getInstance();
    private ThemeExporter _themeExporter = ThemeExporter.getInstance();

    public static List<Portlet> getDataSiteLevelPortlets(long companyId) throws Exception {
        return LayoutExporter.getDataSiteLevelPortlets(companyId, false);
    }

    public static List<Portlet> getDataSiteLevelPortlets(long companyId, boolean excludeDataAlwaysStaged) throws Exception {
        List portlets = PortletLocalServiceUtil.getPortlets((long)companyId);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (!portlet.isActive()) {
                itr.remove();
                continue;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler != null && portletDataHandler.isDataSiteLevel() && (!excludeDataAlwaysStaged || !portletDataHandler.isDataAlwaysStaged())) continue;
            itr.remove();
        }
        return portlets;
    }

    public static LayoutExporter getInstance() {
        return _instance;
    }

    @Deprecated
    public static List<Portlet> getPortletDataHandlerPortlets(long groupId, List<Layout> layouts) throws Exception {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)true);
            File file = this.doExportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
        }
    }

    protected File doExportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        boolean exportIgnoreLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean exportLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        serviceContext.setAttribute("exporting", (Serializable)Boolean.TRUE);
        long layoutSetBranchId = MapUtil.getLong(parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        if (exportIgnoreLastPublishDate) {
            endDate = null;
            startDate = null;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)companyId, (long)groupId, parameterMap, (Date)startDate, (Date)endDate, (ZipWriter)zipWriter);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales((long)portletDataContext.getScopeGroupId())));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(groupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(privateLayout));
        Group group = layoutSet.getGroup();
        String type = "layout-set";
        if (group.isLayoutPrototype()) {
            type = "layout-prototype";
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutPrototype.getUuid());
        } else if (group.isLayoutSetPrototype()) {
            type = "layout-set-prototype";
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutSetPrototype.getUuid());
        }
        headerElement.addAttribute("type", type);
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.fetchLayoutSetBranch((long)layoutSetBranchId);
        if (exportLogo) {
            Image image = null;
            image = layoutSetBranch != null ? ImageLocalServiceUtil.getImage((long)layoutSetBranch.getLogoId()) : ImageLocalServiceUtil.getImage((long)layoutSet.getLogoId());
            if (image != null && image.getTextObj() != null) {
                String logoPath = ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext);
                logoPath = logoPath + "/logo";
                headerElement.addAttribute("logo-path", logoPath);
                portletDataContext.addZipEntry(logoPath, image.getTextObj());
            }
        }
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        if (layoutSetBranch != null) {
            this._themeExporter.exportTheme(portletDataContext, layoutSetBranch);
        } else {
            this._themeExporter.exportTheme(portletDataContext, layoutSet);
        }
        if (exportLayoutSetSettings) {
            Element settingsElement = headerElement.addElement("settings");
            if (layoutSetBranch != null) {
                settingsElement.addCDATA(layoutSetBranch.getSettings());
            } else {
                settingsElement.addCDATA(layoutSet.getSettings());
            }
        }
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        for (Portlet portlet : LayoutExporter.getDataSiteLevelPortlets(companyId)) {
            String portletId = portlet.getRootPortletId();
            if (!group.isStagedPortlet(portletId)) continue;
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                portletDataHandler.prepareManifestSummary(portletDataContext);
            }
            portletIds.put(PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId), new Object[]{portletId, 0L, groupId, "", ""});
            if (!portlet.isScopeable()) continue;
            for (Layout layout : layouts) {
                if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId()) && ArrayUtil.isNotEmpty((long[])layoutIds) || !layout.isTypePortlet() || !layout.hasScopeGroup()) continue;
                Group scopeGroup = layout.getScopeGroup();
                portletIds.put(PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId()), new Object[]{portlet.getPortletId(), layout.getPlid(), scopeGroup.getGroupId(), "", layout.getUuid()});
            }
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        Element layoutsElement = portletDataContext.getExportDataGroupElement(Layout.class);
        String layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            layoutsElement.addAttribute("layout-set-prototype-uuid", layoutSetPrototypeUuid);
            layoutsElement.addAttribute("layout-set-prototype-name", layoutSetPrototype.getName(LocaleUtil.getDefault()));
        }
        for (Layout layout : layouts) {
            this.exportLayout(portletDataContext, layoutIds, portletIds, layout);
        }
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"layout", (String[])ArrayUtil.toStringArray(portletIds.keySet()), (ManifestSummary)manifestSummary);
            manifestSummary.resetCounters();
        }
        Element portletsElement = rootElement.addElement("portlets");
        Element servicesElement = rootElement.addElement("services");
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            Object[] portletObjects = (Object[])portletIdsEntry.getValue();
            String portletId = null;
            long plid = 0L;
            long scopeGroupId = 0L;
            String scopeType = "";
            String scopeLayoutUuid = null;
            if (portletObjects.length == 4) {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[3];
            } else {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeType = (String)((Object[])portletIdsEntry.getValue())[3];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[4];
            }
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
            if (layout == null) {
                layout = new LayoutImpl();
                layout.setCompanyId(companyId);
                layout.setGroupId(groupId);
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(plid);
            portletDataContext.setScopeGroupId(scopeGroupId);
            portletDataContext.setScopeType(scopeType);
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            Map exportPortletControlsMap = ExportImportHelperUtil.getExportPortletControlsMap((long)companyId, (String)portletId, parameterMap, (String)type);
            this._portletExporter.exportPortlet(portletDataContext, portletId, layout, portletsElement, exportPermissions, (Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), (Boolean)exportPortletControlsMap.get("PORTLET_DATA"), (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"), (Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
            this._portletExporter.exportService(portletDataContext, portletId, servicesElement, (Boolean)exportPortletControlsMap.get("PORTLET_SETUP"));
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        this._portletExporter.exportAssetLinks(portletDataContext);
        this._portletExporter.exportAssetTags(portletDataContext);
        this._portletExporter.exportExpandoTables(portletDataContext);
        this._portletExporter.exportLocks(portletDataContext);
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        ExportImportHelperUtil.writeManifestSummary((Document)document, (ManifestSummary)portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
        }
        portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        return zipWriter.getFile();
    }

    protected void exportLayout(PortletDataContext portletDataContext, long[] layoutIds, Map<String, Object[]> portletIds, Layout layout) throws Exception {
        if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId()) && ArrayUtil.isNotEmpty((long[])layoutIds)) {
            Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
            layoutElement.addAttribute("action", "skip");
            return;
        }
        boolean exportLAR = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"exportLAR");
        if (!exportLAR && LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            if (layoutSetBranchId <= 0L) {
                return;
            }
            LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.fetchLayoutRevision((long)layoutSetBranchId, (boolean)true, (long)layout.getPlid());
            if (layoutRevision == null) {
                return;
            }
            LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
            layoutStagingHandler.setLayoutRevision(layoutRevision);
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout);
        if (!layout.isSupportsEmbeddedPortlets()) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets(false)) {
            String portletId = portlet.getPortletId();
            Settings portletInstanceSettings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
            String scopeType = portletInstanceSettings.getValue("lfrScopeType", null);
            String scopeLayoutUuid = portletInstanceSettings.getValue("lfrScopeLayoutUuid", null);
            long scopeGroupId = portletDataContext.getScopeGroupId();
            if (Validator.isNotNull((String)scopeType)) {
                Group scopeGroup = null;
                if (scopeType.equals("company")) {
                    scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
                } else if (scopeType.equals("layout")) {
                    Layout scopeLayout = null;
                    scopeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout());
                    if (scopeLayout == null) continue;
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
                }
                if (scopeGroup != null) {
                    scopeGroupId = scopeGroup.getGroupId();
                }
            }
            String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeType, scopeLayoutUuid});
        }
    }

    private LayoutExporter() {
        XStreamAliasRegistryUtil.register(LayoutImpl.class, (String)"Layout");
    }
}

