/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutCache {
    protected Map<Long, List<Role>> groupRolesMap = new HashMap<Long, List<Role>>();
    protected Map<Long, List<User>> groupUsersMap = new HashMap<Long, List<User>>();
    protected Map<String, Role> rolesMap = new HashMap<String, Role>();
    protected Map<Long, List<Role>> userRolesMap = new HashMap<Long, List<Role>>();

    protected List<Role> getGroupRoles(long groupId, String resourceName) throws PortalException {
        List roles = this.groupRolesMap.get(groupId);
        if (roles != null) {
            return roles;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        roles = ListUtil.copy((List)ResourceActionsUtil.getRoles((long)group.getCompanyId(), (Group)group, (String)resourceName, null));
        Map teamRoleMap = RoleLocalServiceUtil.getTeamRoleMap((long)groupId);
        for (Map.Entry entry : teamRoleMap.entrySet()) {
            Team team = (Team)entry.getKey();
            Role teamRole = (Role)entry.getValue();
            teamRole.setName("ROLE_TEAM_,*" + team.getName());
            teamRole.setDescription(team.getDescription());
            roles.add(teamRole);
        }
        this.groupRolesMap.put(groupId, roles);
        return roles;
    }

    protected List<User> getGroupUsers(long groupId) {
        List users = this.groupUsersMap.get(groupId);
        if (users == null) {
            users = UserLocalServiceUtil.getGroupUsers((long)groupId);
            this.groupUsersMap.put(groupId, users);
        }
        return users;
    }

    protected Role getRole(long companyId, String roleName) throws PortalException {
        Role role = this.rolesMap.get(roleName);
        if (role == null) {
            try {
                role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
                this.rolesMap.put(roleName, role);
            }
            catch (NoSuchRoleException nsre) {
                // empty catch block
            }
        }
        return role;
    }

    protected List<Role> getUserRoles(long userId) {
        List userRoles = this.userRolesMap.get(userId);
        if (userRoles == null) {
            userRoles = RoleLocalServiceUtil.getUserRoles((long)userId);
            this.userRolesMap.put(userId, userRoles);
        }
        return userRoles;
    }
}

