/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class DeletionSystemEventImporter {
    private static Log _log = LogFactoryUtil.getLog(DeletionSystemEventImporter.class);
    private static DeletionSystemEventImporter _instance = new DeletionSystemEventImporter();

    public static DeletionSystemEventImporter getInstance() {
        return _instance;
    }

    public void importDeletionSystemEvents(final PortletDataContext portletDataContext) throws Exception {
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETIONS")) {
            return;
        }
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/deletion-system-events.xml");
        if (xml == null) {
            return;
        }
        SAXParser saxParser = new SAXParser();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                DeletionSystemEventImporter.this.doImportDeletionSystemEvents(portletDataContext, element);
            }
        }, new String[]{"deletion-system-event"});
        saxParser.setContentHandler((ContentHandler)elementHandler);
        saxParser.parse(new InputSource(new StringReader(xml)));
    }

    protected void doImportDeletionSystemEvents(PortletDataContext portletDataContext, Element element) {
        block3: {
            StagedModelType stagedModelType;
            Set stagedModelTypes = portletDataContext.getDeletionSystemEventStagedModelTypes();
            if (!stagedModelTypes.contains(stagedModelType = new StagedModelType(element.attributeValue("class-name"), element.attributeValue("referrer-class-name")))) {
                return;
            }
            try {
                StagedModelDataHandlerUtil.deleteStagedModel((PortletDataContext)portletDataContext, (Element)element);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to process deletion for ");
                sb.append((Object)stagedModelType);
                sb.append(" with UUID ");
                sb.append(element.attributeValue("uuid"));
                _log.warn((Object)sb.toString());
            }
        }
    }

    private DeletionSystemEventImporter() {
    }
}

