/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheMapSynchronizeUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DoPrivileged
public class LanguageImpl
implements Language,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(LanguageImpl.class);
    private static Map<Long, LanguageImpl> _instances = new ConcurrentHashMap<Long, LanguageImpl>();
    private static Pattern _pattern = Pattern.compile("Liferay\\.Language\\.get\\([\"']([^)]+)[\"']\\)");
    private static PortalCache<Long, Serializable> _portalCache = MultiVMPoolUtil.getCache((String)LanguageImpl.class.getName());
    private Map<String, String> _charEncodings;
    private Set<String> _duplicateLanguageCodes;
    private Map<Long, Locale[]> _groupLocalesMap = new HashMap<Long, Locale[]>();
    private Map<Long, Set<Locale>> _groupLocalesSet = new HashMap<Long, Set<Locale>>();
    private Locale[] _locales;
    private Set<Locale> _localesBetaSet;
    private Map<String, Locale> _localesMap;
    private Set<Locale> _localesSet;

    public String format(HttpServletRequest request, String pattern, LanguageWrapper argument) {
        return this.format(request, pattern, new LanguageWrapper[]{argument}, true);
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return this.format(request, pattern, new LanguageWrapper[]{argument}, translateArguments);
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper[] arguments) {
        return this.format(request, pattern, arguments, true);
    }

    public String format(HttpServletRequest request, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(request, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? arguments[i].getBefore() + this.get(request, arguments[i].getText()) + arguments[i].getAfter() : arguments[i].getBefore() + arguments[i].getText() + arguments[i].getAfter();
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(HttpServletRequest request, String pattern, Object argument) {
        return this.format(request, pattern, new Object[]{argument}, true);
    }

    public String format(HttpServletRequest request, String pattern, Object argument, boolean translateArguments) {
        return this.format(request, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(HttpServletRequest request, String pattern, Object[] arguments) {
        return this.format(request, pattern, arguments, true);
    }

    public String format(HttpServletRequest request, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(request, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? this.get(request, arguments[i].toString()) : arguments[i];
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(Locale locale, String pattern, List<Object> arguments) {
        return this.format(locale, pattern, arguments.toArray(), true);
    }

    public String format(Locale locale, String pattern, Object argument) {
        return this.format(locale, pattern, new Object[]{argument}, true);
    }

    public String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return this.format(locale, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(Locale locale, String pattern, Object[] arguments) {
        return this.format(locale, pattern, arguments, true);
    }

    public String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(locale, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? this.get(locale, arguments[i].toString()) : arguments[i];
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object argument) {
        return this.format(resourceBundle, pattern, new Object[]{argument}, true);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object argument, boolean translateArguments) {
        return this.format(resourceBundle, pattern, new Object[]{argument}, translateArguments);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object[] arguments) {
        return this.format(resourceBundle, pattern, arguments, true);
    }

    public String format(ResourceBundle resourceBundle, String pattern, Object[] arguments, boolean translateArguments) {
        String value;
        block6: {
            if (PropsValues.TRANSLATIONS_DISABLED) {
                return pattern;
            }
            value = null;
            try {
                pattern = this.get(resourceBundle, pattern);
                if (ArrayUtil.isNotEmpty((Object[])arguments)) {
                    pattern = this._escapePattern(pattern);
                    Object[] formattedArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        formattedArguments[i] = translateArguments ? this.get(resourceBundle, arguments[i].toString()) : arguments[i];
                    }
                    value = MessageFormat.format(pattern, formattedArguments);
                } else {
                    value = pattern;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String get(HttpServletRequest request, String key) {
        return this.get(request, key, key);
    }

    public String get(HttpServletRequest request, String key, String defaultValue) {
        if (request == null || key == null) {
            return defaultValue;
        }
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        Locale locale = this._getLocale(request);
        if (portletConfig == null) {
            return this.get(locale, key, defaultValue);
        }
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        if (resourceBundle.containsKey(key)) {
            return this._get(resourceBundle, key);
        }
        return this.get(locale, key, defaultValue);
    }

    public String get(Locale locale, String key) {
        return this.get(locale, key, key);
    }

    public String get(Locale locale, String key, String defaultValue) {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (locale == null || key == null) {
            return defaultValue;
        }
        String value = LanguageResources.getMessage(locale, key);
        if (value != null) {
            return LanguageResources.fixValue(value);
        }
        if (value == null && key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this.get(locale, key, defaultValue);
        }
        return defaultValue;
    }

    public String get(ResourceBundle resourceBundle, String key) {
        return this.get(resourceBundle, key, key);
    }

    public String get(ResourceBundle resourceBundle, String key, String defaultValue) {
        String value = this._get(resourceBundle, key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Locale[] getAvailableLocales() {
        return LanguageImpl._getInstance()._locales;
    }

    public Locale[] getAvailableLocales(long groupId) {
        if (groupId <= 0L) {
            return this.getAvailableLocales();
        }
        try {
            if (this.isInheritLocales(groupId)) {
                return this.getAvailableLocales();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Locale[] locales = this._groupLocalesMap.get(groupId);
        if (locales != null) {
            return locales;
        }
        this._initGroupLocales(groupId);
        return this._groupLocalesMap.get(groupId);
    }

    public String getBCP47LanguageId(HttpServletRequest request) {
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        return this.getBCP47LanguageId(locale);
    }

    public String getBCP47LanguageId(Locale locale) {
        return LocaleUtil.toBCP47LanguageId((Locale)locale);
    }

    public String getBCP47LanguageId(PortletRequest portletRequest) {
        Locale locale = PortalUtil.getLocale((PortletRequest)portletRequest);
        return this.getBCP47LanguageId(locale);
    }

    public String getCharset(Locale locale) {
        return LanguageImpl._getInstance()._getCharset(locale);
    }

    public String getLanguageId(HttpServletRequest request) {
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        if (Validator.isNotNull((String)languageId) && (this._localesMap.containsKey(languageId) || this._charEncodings.containsKey(languageId))) {
            return languageId;
        }
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        return this.getLanguageId(locale);
    }

    public String getLanguageId(Locale locale) {
        return LocaleUtil.toLanguageId((Locale)locale);
    }

    public String getLanguageId(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getLanguageId(request);
    }

    public Locale getLocale(String languageCode) {
        return LanguageImpl._getInstance()._getLocale(languageCode);
    }

    public Locale[] getSupportedLocales() {
        Locale[] locales;
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        for (Locale locale : locales = this.getAvailableLocales()) {
            if (this.isBetaLocale(locale)) continue;
            supportedLocales.add(locale);
        }
        return supportedLocales.toArray(new Locale[supportedLocales.size()]);
    }

    public String getTimeDescription(HttpServletRequest request, long milliseconds) {
        return this.getTimeDescription(request, milliseconds, false);
    }

    public String getTimeDescription(HttpServletRequest request, long milliseconds, boolean approximate) {
        String value;
        block2: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                int pos = description.indexOf(32);
                String x = description.substring(0, pos);
                value = x.concat(" ").concat(this.get(request, StringUtil.toLowerCase((String)description.substring(pos + 1, description.length()))));
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String getTimeDescription(HttpServletRequest request, Long milliseconds) {
        return this.getTimeDescription(request, (long)milliseconds);
    }

    public String getTimeDescription(Locale locale, long milliseconds) {
        return this.getTimeDescription(locale, milliseconds, false);
    }

    public String getTimeDescription(Locale locale, long milliseconds, boolean approximate) {
        String value;
        block2: {
            String description = Time.getDescription((long)milliseconds, (boolean)approximate);
            value = null;
            try {
                int pos = description.indexOf(32);
                String x = description.substring(0, pos);
                value = x.concat(" ").concat(this.get(locale, StringUtil.toLowerCase((String)description.substring(pos + 1, description.length()))));
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return value;
    }

    public String getTimeDescription(Locale locale, Long milliseconds) {
        return this.getTimeDescription(locale, (long)milliseconds);
    }

    public void init() {
        _instances.clear();
    }

    public boolean isAvailableLanguageCode(String languageCode) {
        return LanguageImpl._getInstance()._localesMap.containsKey(languageCode);
    }

    public boolean isAvailableLocale(Locale locale) {
        return LanguageImpl._getInstance()._localesSet.contains(locale);
    }

    public boolean isAvailableLocale(long groupId, Locale locale) {
        if (groupId <= 0L) {
            return this.isAvailableLocale(locale);
        }
        try {
            if (this.isInheritLocales(groupId)) {
                return this.isAvailableLocale(locale);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Set<Locale> localesSet = this._groupLocalesSet.get(groupId);
        if (localesSet != null) {
            return localesSet.contains(locale);
        }
        this._initGroupLocales(groupId);
        localesSet = this._groupLocalesSet.get(groupId);
        return localesSet.contains(locale);
    }

    public boolean isAvailableLocale(long groupId, String languageId) {
        Locale[] locales;
        for (Locale locale : locales = this.getAvailableLocales(groupId)) {
            if (!languageId.equals(locale.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailableLocale(String languageId) {
        Locale[] locales;
        for (Locale locale : locales = this.getAvailableLocales()) {
            if (!languageId.equals(locale.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isBetaLocale(Locale locale) {
        return LanguageImpl._getInstance()._localesBetaSet.contains(locale);
    }

    public boolean isDuplicateLanguageCode(String languageCode) {
        return LanguageImpl._getInstance()._duplicateLanguageCodes.contains(languageCode);
    }

    public boolean isInheritLocales(long groupId) throws PortalException {
        Group group;
        Group liveGroup = group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            liveGroup = group.getLiveGroup();
        }
        UnicodeProperties groupTypeSettings = liveGroup.getTypeSettingsProperties();
        return GetterUtil.getBoolean((String)groupTypeSettings.getProperty("inheritLocales"), (boolean)true);
    }

    public String process(ResourceBundle resourceBundle, Locale locale, String content) {
        StringBundler sb = new StringBundler();
        Matcher matcher = _pattern.matcher(content);
        int x = 0;
        while (matcher.find()) {
            int y = matcher.start(0);
            String key = matcher.group(1);
            sb.append(content.substring(x, y));
            sb.append("'");
            String value = this.get(resourceBundle, key);
            sb.append(HtmlUtil.escapeJS((String)value));
            sb.append("'");
            x = matcher.end(0);
        }
        sb.append(content.substring(x));
        return sb.toString();
    }

    public void resetAvailableGroupLocales(long groupId) {
        this._resetAvailableGroupLocales(groupId);
    }

    public void resetAvailableLocales(long companyId) {
        this._resetAvailableLocales(companyId);
    }

    public void updateCookie(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        Cookie languageIdCookie = new Cookie("GUEST_LANGUAGE_ID", languageId);
        languageIdCookie.setPath("/");
        languageIdCookie.setMaxAge(1471228928);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)languageIdCookie);
    }

    private static LanguageImpl _getInstance() {
        Long companyId = CompanyThreadLocal.getCompanyId();
        LanguageImpl instance = _instances.get(companyId);
        if (instance == null) {
            instance = new LanguageImpl(companyId);
            _instances.put(companyId, instance);
        }
        return instance;
    }

    private LanguageImpl() {
        this(0L);
    }

    private LanguageImpl(long companyId) {
        String[] languageIds = PropsValues.LOCALES;
        if (companyId != 0L) {
            try {
                languageIds = PrefsPropsUtil.getStringArray(companyId, "locales", ",", PropsValues.LOCALES_ENABLED);
            }
            catch (SystemException se) {
                languageIds = PropsValues.LOCALES_ENABLED;
            }
        }
        this._charEncodings = new HashMap<String, String>();
        this._duplicateLanguageCodes = new HashSet<String>();
        this._locales = new Locale[languageIds.length];
        this._localesMap = new HashMap<String, Locale>(languageIds.length);
        this._localesSet = new HashSet<Locale>(languageIds.length);
        for (int i = 0; i < languageIds.length; ++i) {
            String languageId = languageIds[i];
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            this._charEncodings.put(locale.toString(), "UTF-8");
            String language = languageId;
            int pos = languageId.indexOf(95);
            if (pos > 0) {
                language = languageId.substring(0, pos);
            }
            if (this._localesMap.containsKey(language)) {
                this._duplicateLanguageCodes.add(language);
            }
            this._locales[i] = locale;
            if (!this._localesMap.containsKey(language)) {
                this._localesMap.put(language, locale);
            }
            this._localesSet.add(locale);
        }
        String[] localesBetaArray = PropsValues.LOCALES_BETA;
        this._localesBetaSet = new HashSet<Locale>(localesBetaArray.length);
        for (String languageId : localesBetaArray) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            this._localesBetaSet.add(locale);
        }
    }

    private String _escapePattern(String pattern) {
        return StringUtil.replace((String)pattern, (String)"'", (String)"''");
    }

    private String _get(ResourceBundle resourceBundle, String key) {
        int pos;
        if (PropsValues.TRANSLATIONS_DISABLED) {
            return key;
        }
        if (resourceBundle == null || key == null) {
            return null;
        }
        String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        if (value != null) {
            return LanguageResources.fixValue(value);
        }
        if (key.length() > 0 && key.charAt(key.length() - 1) == ']' && (pos = key.lastIndexOf(91)) != -1) {
            key = key.substring(0, pos);
            return this._get(resourceBundle, key);
        }
        return null;
    }

    private String _getCharset(Locale locale) {
        return "UTF-8";
    }

    private Locale _getLocale(HttpServletRequest request) {
        Locale locale = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            locale = themeDisplay.getLocale();
        } else {
            locale = request.getLocale();
            if (!this.isAvailableLocale(locale)) {
                locale = LocaleUtil.getDefault();
            }
        }
        return locale;
    }

    private Locale _getLocale(String languageCode) {
        return this._localesMap.get(languageCode);
    }

    private void _initGroupLocales(long groupId) {
        String[] languageIds = null;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            languageIds = StringUtil.split((String)typeSettingsProperties.getProperty("locales"));
        }
        catch (Exception e) {
            languageIds = PropsValues.LOCALES_ENABLED;
        }
        Locale[] locales = new Locale[languageIds.length];
        HashMap<String, Locale> localesMap = new HashMap<String, Locale>(languageIds.length);
        HashSet<Locale> localesSet = new HashSet<Locale>(languageIds.length);
        for (int i = 0; i < languageIds.length; ++i) {
            String languageId = languageIds[i];
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            String language = languageId;
            int pos = languageId.indexOf(95);
            if (pos > 0) {
                language = languageId.substring(0, pos);
            }
            locales[i] = locale;
            if (!localesMap.containsKey(language)) {
                localesMap.put(language, locale);
            }
            localesSet.add(locale);
        }
        this._groupLocalesMap.put(groupId, locales);
        this._groupLocalesSet.put(groupId, localesSet);
    }

    private void _resetAvailableGroupLocales(long groupId) {
        this._groupLocalesMap.remove(groupId);
        this._groupLocalesSet.remove(groupId);
    }

    private void _resetAvailableLocales(long companyId) {
        _portalCache.remove((Serializable)Long.valueOf(companyId));
    }

    static {
        PortalCacheMapSynchronizeUtil.synchronize(_portalCache, _instances, (PortalCacheMapSynchronizeUtil.Synchronizer)new PortalCacheMapSynchronizeUtil.Synchronizer<Long, Serializable>(){

            public void onSynchronize(Map<? extends Long, ? extends Serializable> map, Long key, Serializable value, int timeToLive) {
                _instances.remove(key);
            }
        });
    }
}

