/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.annotation.AnnotationLocator;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMappingResolver;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;

public class JSONWebServiceRegistrator {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceRegistrator.class);
    private final JSONWebServiceMappingResolver _jsonWebServiceMappingResolver;
    private final JSONWebServiceNaming _jsonWebServiceNaming;
    private Map<Class<?>, Class<?>> _utilClasses;
    private boolean _wireViaUtil;

    public JSONWebServiceRegistrator() {
        this._jsonWebServiceNaming = JSONWebServiceActionsManagerUtil.getJSONWebServiceNaming();
        this._jsonWebServiceMappingResolver = new JSONWebServiceMappingResolver(this._jsonWebServiceNaming);
    }

    public JSONWebServiceRegistrator(JSONWebServiceNaming jsonWebServiceNaming) {
        this._jsonWebServiceNaming = jsonWebServiceNaming;
        this._jsonWebServiceMappingResolver = new JSONWebServiceMappingResolver(this._jsonWebServiceNaming);
    }

    public void processAllBeans(String contextName, String contextPath, BeanLocator beanLocator) {
        String[] beanNames;
        if (beanLocator == null) {
            return;
        }
        for (String beanName : beanNames = beanLocator.getNames()) {
            this.processBean(contextName, contextPath, beanLocator, beanName);
        }
    }

    public void processBean(String contextName, String contextPath, BeanLocator beanLocator, String beanName) {
        if (!PropsValues.JSON_WEB_SERVICE_ENABLED) {
            return;
        }
        Object bean = null;
        try {
            bean = beanLocator.locate(beanName);
        }
        catch (BeanLocatorException e) {
            return;
        }
        JSONWebService jsonWebService = (JSONWebService)AnnotationLocator.locate(bean.getClass(), JSONWebService.class);
        if (jsonWebService != null) {
            try {
                this.onJSONWebServiceBean(contextName, contextPath, bean, jsonWebService);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void processBean(String contextName, String contextPath, Object bean) {
        if (!PropsValues.JSON_WEB_SERVICE_ENABLED) {
            return;
        }
        JSONWebService jsonWebService = (JSONWebService)AnnotationLocator.locate(bean.getClass(), JSONWebService.class);
        if (jsonWebService == null) {
            return;
        }
        try {
            this.onJSONWebServiceBean(contextName, contextPath, bean, jsonWebService);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setWireViaUtil(boolean wireViaUtil) {
        this._wireViaUtil = wireViaUtil;
    }

    protected Class<?> getTargetClass(Object service) throws Exception {
        if (ProxyUtil.isProxyClass(service.getClass())) {
            AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(service);
            TargetSource targetSource = advisedSupport.getTargetSource();
            service = targetSource.getTarget();
        }
        return service.getClass();
    }

    protected Class<?> loadUtilClass(Class<?> implementationClass) throws ClassNotFoundException {
        Class<?> utilClass;
        if (this._utilClasses == null) {
            this._utilClasses = new HashMap();
        }
        if ((utilClass = this._utilClasses.get(implementationClass)) != null) {
            return utilClass;
        }
        String utilClassName = this._jsonWebServiceNaming.convertServiceImplClassToUtilClassName(implementationClass);
        ClassLoader classLoader = implementationClass.getClassLoader();
        utilClass = classLoader.loadClass(utilClassName);
        this._utilClasses.put(implementationClass, utilClass);
        return utilClass;
    }

    protected void onJSONWebServiceBean(String contextName, String contextPath, Object serviceBean, JSONWebService jsonWebService) throws Exception {
        Method[] methods;
        JSONWebServiceMode jsonWebServiceMode = JSONWebServiceMode.MANUAL;
        if (jsonWebService != null) {
            jsonWebServiceMode = jsonWebService.mode();
        }
        Class<?> serviceBeanClass = this.getTargetClass(serviceBean);
        for (Method method : methods = serviceBeanClass.getMethods()) {
            JSONWebServiceMode methodJSONWebServiceMode;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != serviceBeanClass || !this._jsonWebServiceNaming.isIncludedMethod(method)) continue;
            JSONWebService methodJSONWebService = method.getAnnotation(JSONWebService.class);
            if (jsonWebServiceMode.equals((Object)JSONWebServiceMode.AUTO)) {
                if (methodJSONWebService == null) {
                    this.registerJSONWebServiceAction(contextName, contextPath, serviceBean, serviceBeanClass, method);
                    continue;
                }
                methodJSONWebServiceMode = methodJSONWebService.mode();
                if (methodJSONWebServiceMode.equals((Object)JSONWebServiceMode.IGNORE)) continue;
                this.registerJSONWebServiceAction(contextName, contextPath, serviceBean, serviceBeanClass, method);
                continue;
            }
            if (methodJSONWebService == null || (methodJSONWebServiceMode = methodJSONWebService.mode()).equals((Object)JSONWebServiceMode.IGNORE)) continue;
            this.registerJSONWebServiceAction(contextName, contextPath, serviceBean, serviceBeanClass, method);
        }
    }

    protected void registerJSONWebServiceAction(String contextName, String contextPath, Object serviceBean, Class<?> serviceBeanClass, Method method) throws Exception {
        String path;
        String httpMethod = this._jsonWebServiceMappingResolver.resolveHttpMethod(method);
        if (!this._jsonWebServiceNaming.isValidHttpMethod(httpMethod)) {
            return;
        }
        if (this._wireViaUtil) {
            Class<?> utilClass = this.loadUtilClass(serviceBeanClass);
            try {
                method = utilClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                return;
            }
        }
        if (!this._jsonWebServiceNaming.isIncludedPath(contextPath, path = this._jsonWebServiceMappingResolver.resolvePath(serviceBeanClass, method))) {
            return;
        }
        if (this._wireViaUtil) {
            JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)contextName, (String)contextPath, method.getDeclaringClass(), (Method)method, (String)path, (String)httpMethod);
        } else {
            JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)contextName, (String)contextPath, (Object)serviceBean, serviceBeanClass, (Method)method, (String)path, (String)httpMethod);
        }
    }
}

