/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionImpl;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.jsonwebservice.JSONWebServiceRegistrator;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManager;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.jsonwebservice.NoSuchJSONWebServiceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.BinarySearch;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class JSONWebServiceActionsManagerImpl
implements JSONWebServiceActionsManager {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceActionsManagerImpl.class);
    private SortedArrayList<JSONWebServiceActionConfig> _jsonWebServiceActionConfigs = new SortedArrayList();
    private JSONWebServiceNaming _jsonWebServiceNaming = new JSONWebServiceNaming();
    private BinarySearch<String> _pathBinarySearch = new PathBinarySearch();

    public Set<String> getContextNames() {
        TreeSet<String> contextNames = new TreeSet<String>();
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            String contextName = jsonWebServiceActionConfig.getContextName();
            contextNames.add(contextName);
        }
        return contextNames;
    }

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request) throws NoSuchJSONWebServiceException {
        int jsonWebServiceActionConfigIndex;
        String path = GetterUtil.getString((String)request.getPathInfo());
        String method = GetterUtil.getString((String)request.getMethod());
        String parameterPath = null;
        JSONRPCRequest jsonRPCRequest = null;
        int parameterPathIndex = this._getParameterPathIndex(path);
        if (parameterPathIndex != -1) {
            parameterPath = path.substring(parameterPathIndex);
            path = path.substring(0, parameterPathIndex);
        } else if (method.equals("POST") && !PortalUtil.isMultipartRequest((HttpServletRequest)request) && (jsonRPCRequest = JSONRPCRequest.detectJSONRPCRequest(request)) != null) {
            path = path + "/" + jsonRPCRequest.getMethod();
            method = null;
        }
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, parameterPath, jsonRPCRequest, null);
        if (jsonWebServiceActionParameters.getServiceContext() != null) {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)jsonWebServiceActionParameters.getServiceContext());
        }
        String[] paths = this._resolvePaths(request, path);
        String contextName = paths[0];
        path = paths[1];
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Request JSON web service action with path " + path + " and method " + method + " for " + contextName));
        }
        if ((jsonWebServiceActionConfigIndex = this._getJSONWebServiceActionConfigIndex(contextName, path, method, jsonWebServiceActionParameters.getParameterNames())) == -1) {
            throw new NoSuchJSONWebServiceException("No JSON web service action with path " + path + " and method " + method + " for " + contextName);
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(jsonWebServiceActionConfigIndex);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters, this._jsonWebServiceNaming);
    }

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request, String path, String method, Map<String, Object> parameterMap) throws NoSuchJSONWebServiceException {
        int jsonWebServiceActionConfigIndex;
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, null, null, parameterMap);
        String[] parameterNames = jsonWebServiceActionParameters.getParameterNames();
        String[] paths = this._resolvePaths(request, path);
        String contextName = paths[0];
        path = paths[1];
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Request JSON web service action with path " + path + " and method " + method + " for " + contextName));
        }
        if ((jsonWebServiceActionConfigIndex = this._getJSONWebServiceActionConfigIndex(contextName, path, method, parameterNames)) == -1) {
            throw new NoSuchJSONWebServiceException("No JSON web service action with path " + path + " and method " + method + " for " + contextName);
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(jsonWebServiceActionConfigIndex);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters, this._jsonWebServiceNaming);
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping(String signature) {
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            if (!signature.equals(jsonWebServiceActionConfig.getSignature())) continue;
            return jsonWebServiceActionConfig;
        }
        return null;
    }

    public List<JSONWebServiceActionMapping> getJSONWebServiceActionMappings(String contextName) {
        ArrayList<JSONWebServiceActionMapping> jsonWebServiceActionMappings = new ArrayList<JSONWebServiceActionMapping>(this._jsonWebServiceActionConfigs.size());
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            if (!contextName.equals(jsonWebServiceActionConfig.getContextName())) continue;
            jsonWebServiceActionMappings.add(jsonWebServiceActionConfig);
        }
        return jsonWebServiceActionMappings;
    }

    public int getJSONWebServiceActionsCount(String contextName) {
        int count = 0;
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._jsonWebServiceActionConfigs) {
            if (!contextName.equals(jsonWebServiceActionConfig.getContextName())) continue;
            ++count;
        }
        return count;
    }

    public JSONWebServiceNaming getJSONWebServiceNaming() {
        return this._jsonWebServiceNaming;
    }

    public void registerJSONWebServiceAction(String contextName, String contextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        block4: {
            try {
                JSONWebServiceActionConfig jsonWebServiceActionConfig = new JSONWebServiceActionConfig(contextName, contextPath, actionClass, actionMethod, path, method);
                if (this._jsonWebServiceActionConfigs.contains((Object)jsonWebServiceActionConfig)) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("A JSON web service action is already registered at " + path));
                    }
                    return;
                }
                this._jsonWebServiceActionConfigs.add((Object)jsonWebServiceActionConfig);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                StringBundler sb = new StringBundler(14);
                sb.append("Unable to register service method {actionClass=");
                sb.append(actionClass);
                sb.append(", actionMethod=");
                sb.append((Object)actionMethod);
                sb.append(", contextName=");
                sb.append(contextName);
                sb.append(", contextPath=");
                sb.append(contextPath);
                sb.append(", method=");
                sb.append(method);
                sb.append(", path=");
                sb.append(path);
                sb.append("} due to ");
                sb.append(e.getMessage());
                _log.warn((Object)sb.toString());
            }
        }
    }

    public void registerJSONWebServiceAction(String contextName, String contextPath, Object actionObject, Class<?> actionClass, Method actionMethod, String path, String method) {
        try {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = new JSONWebServiceActionConfig(contextName, contextPath, actionObject, actionClass, actionMethod, path, method);
            if (this._jsonWebServiceActionConfigs.contains((Object)jsonWebServiceActionConfig)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("A JSON web service action is already registered at " + path));
                }
                return;
            }
            this._jsonWebServiceActionConfigs.add((Object)jsonWebServiceActionConfig);
        }
        catch (Exception e) {
            StringBundler sb = new StringBundler(17);
            sb.append("Something went wrong attempting to register service ");
            sb.append("method {contextName=");
            sb.append(contextName);
            sb.append(",contextPath=");
            sb.append(contextPath);
            sb.append(",actionObject=");
            sb.append(actionObject);
            sb.append(",actionClass=");
            sb.append(actionClass);
            sb.append(",actionMethod=");
            sb.append((Object)actionMethod);
            sb.append(",path=");
            sb.append(path);
            sb.append(",method=");
            sb.append(method);
            sb.append("} due to ");
            sb.append(e.getMessage());
            _log.warn((Object)sb.toString());
        }
    }

    public int registerService(String contextPath, Object service) {
        return this.registerService("", contextPath, service);
    }

    public int registerService(String contextName, String contextPath, Object service) {
        JSONWebServiceRegistrator jsonWebServiceRegistrator = new JSONWebServiceRegistrator();
        jsonWebServiceRegistrator.processBean(contextName, contextPath, service);
        int count = this.getJSONWebServiceActionsCount(contextPath);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Configured " + count + " actions for " + contextPath));
        }
        return count;
    }

    public int registerServletContext(ServletContext servletContext) {
        BeanLocator beanLocator = null;
        String contextName = servletContext.getServletContextName();
        String contextPath = servletContext.getContextPath();
        beanLocator = contextPath.equals(PortalContextLoaderListener.getPortalServletContextPath()) || contextPath.isEmpty() ? PortalBeanLocatorUtil.getBeanLocator() : PortletBeanLocatorUtil.getBeanLocator((String)contextName);
        if (beanLocator == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Bean locator not available for " + contextPath));
            }
            return -1;
        }
        JSONWebServiceRegistrator jsonWebServiceRegistrator = new JSONWebServiceRegistrator();
        jsonWebServiceRegistrator.processAllBeans(contextName, contextPath, beanLocator);
        int count = this.getJSONWebServiceActionsCount(contextPath);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Configured " + count + " actions for " + contextPath));
        }
        return count;
    }

    public int unregisterJSONWebServiceActions(Object actionObject) {
        int count = 0;
        Iterator iterator = this._jsonWebServiceActionConfigs.iterator();
        while (iterator.hasNext()) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)iterator.next();
            if (!actionObject.equals(jsonWebServiceActionConfig.getActionObject())) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }

    public int unregisterJSONWebServiceActions(String contextPath) {
        int count = 0;
        Iterator iterator = this._jsonWebServiceActionConfigs.iterator();
        while (iterator.hasNext()) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)iterator.next();
            if (!contextPath.equals(jsonWebServiceActionConfig.getContextPath())) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }

    public int unregisterServletContext(ServletContext servletContext) {
        String contextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        return this.unregisterJSONWebServiceActions(contextPath);
    }

    private int _countMatchedParameters(String[] parameterNames, MethodParameter[] methodParameters) {
        int matched = 0;
        for (MethodParameter methodParameter : methodParameters) {
            String methodParameterName = methodParameter.getName();
            methodParameterName = StringUtil.toLowerCase((String)methodParameterName);
            for (String parameterName : parameterNames) {
                if (!StringUtil.equalsIgnoreCase((String)parameterName, (String)methodParameterName)) continue;
                ++matched;
            }
        }
        return matched;
    }

    private int _getJSONWebServiceActionConfigIndex(String contextName, String path, String method, String[] parameterNames) {
        int firstIndex;
        int dotIndex;
        String pathPrefix;
        int hint = -1;
        int offset = 0;
        if (Validator.isNotNull((String)contextName) && path.startsWith(pathPrefix = "/".concat(contextName).concat("."))) {
            offset = pathPrefix.length();
        }
        if ((dotIndex = path.indexOf(46, offset)) != -1 && (hint = GetterUtil.getInteger((String)path.substring(dotIndex + 1), (int)-1)) != -1) {
            path = path.substring(0, dotIndex);
        }
        if ((firstIndex = this._pathBinarySearch.findFirst((Object)path)) < 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find JSON web service actions with path " + path + " for " + contextName));
            }
            return -1;
        }
        int lastIndex = this._pathBinarySearch.findLast((Object)path, firstIndex);
        if (lastIndex < 0) {
            lastIndex = firstIndex;
        }
        int index = -1;
        int max = -1;
        if (_log.isDebugEnabled()) {
            int total = lastIndex - firstIndex + 1;
            _log.debug((Object)("Found " + total + " JSON web service actions with path " + path + " in for " + contextName));
        }
        for (int i = firstIndex; i <= lastIndex; ++i) {
            int count;
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)this._jsonWebServiceActionConfigs.get(i);
            String jsonWebServiceActionConfigMethod = jsonWebServiceActionConfig.getMethod();
            if (PropsValues.JSONWS_WEB_SERVICE_STRICT_HTTP_METHOD && method != null && jsonWebServiceActionConfigMethod != null && !jsonWebServiceActionConfigMethod.equals(method)) continue;
            MethodParameter[] jsonWebServiceActionConfigMethodParameters = jsonWebServiceActionConfig.getMethodParameters();
            int methodParametersCount = jsonWebServiceActionConfigMethodParameters.length;
            if (hint != -1 && methodParametersCount != hint || (count = this._countMatchedParameters(parameterNames, jsonWebServiceActionConfigMethodParameters)) <= max || hint == -1 && count < methodParametersCount) continue;
            max = count;
            index = i;
        }
        if (_log.isDebugEnabled()) {
            if (index == -1) {
                _log.debug((Object)("Unable to match parameters to a JSON web service action with path " + path + " for " + contextName));
            } else {
                _log.debug((Object)("Matched parameters to a JSON web service action with path " + path + " for " + contextName));
            }
        }
        return index;
    }

    private int _getParameterPathIndex(String path) {
        int index = path.indexOf(47, 1);
        if (index != -1) {
            index = path.indexOf(47, index + 1);
        }
        return index;
    }

    private String[] _resolvePaths(HttpServletRequest request, String path) {
        ServletContext servletContext;
        String contextName = null;
        int index = path.indexOf(47, 1);
        if (index != -1 && (index = path.lastIndexOf(46, index)) != -1) {
            contextName = path.substring(1, index);
        }
        if (contextName == null && Validator.isNotNull((String)(contextName = (servletContext = request.getServletContext()).getServletContextName()))) {
            path = "/".concat(contextName).concat(".").concat(path.substring(1));
        }
        return new String[]{contextName, path};
    }

    private class PathBinarySearch
    extends BinarySearch<String> {
        private PathBinarySearch() {
        }

        protected int compare(int index, String element) {
            JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)JSONWebServiceActionsManagerImpl.this._jsonWebServiceActionConfigs.get(index);
            String path = jsonWebServiceActionConfig.getPath();
            return path.compareTo(element);
        }

        protected int getLastIndex() {
            return JSONWebServiceActionsManagerImpl.this._jsonWebServiceActionConfigs.size() - 1;
        }
    }
}

