/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.increment.BufferedIncreasableEntry;
import com.liferay.portal.increment.BufferedIncrementConfiguration;
import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.concurrent.BatchablePipe;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferedIncrementRunnable
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(BufferedIncrementRunnable.class);
    private final BatchablePipe<Serializable, Increment<?>> _batchablePipe;
    private final BufferedIncrementConfiguration _bufferedIncrementConfiguration;
    private final long _companyId;
    private final AtomicInteger _queueLengthTracker;

    public BufferedIncrementRunnable(BufferedIncrementConfiguration bufferedIncrementConfiguration, BatchablePipe<Serializable, Increment<?>> batchablePipe, AtomicInteger queueLengthTracker) {
        this._bufferedIncrementConfiguration = bufferedIncrementConfiguration;
        this._batchablePipe = batchablePipe;
        this._queueLengthTracker = queueLengthTracker;
        if (this._bufferedIncrementConfiguration.isStandbyEnabled()) {
            this._queueLengthTracker.incrementAndGet();
        }
        this._companyId = CompanyThreadLocal.getCompanyId();
    }

    @Override
    public void run() {
        BufferedIncreasableEntry bufferedIncreasableEntry;
        CompanyThreadLocal.setCompanyId((Long)this._companyId);
        while ((bufferedIncreasableEntry = (BufferedIncreasableEntry)this._batchablePipe.take()) != null) {
            try {
                bufferedIncreasableEntry.proceed();
            }
            catch (Throwable t) {
                _log.error((Object)"Unable to write buffered increment value to the database", t);
            }
            if (!this._bufferedIncrementConfiguration.isStandbyEnabled()) continue;
            int queueLength = this._queueLengthTracker.decrementAndGet();
            long standbyTime = this._bufferedIncrementConfiguration.calculateStandbyTime(queueLength);
            try {
                Thread.sleep(standbyTime);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
        CentralizedThreadLocal.clearShortLivedThreadLocals();
    }
}

