/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.increment.BufferedIncreasableEntry;
import com.liferay.portal.increment.BufferedIncrementConfiguration;
import com.liferay.portal.increment.BufferedIncrementProcessor;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.increment.IncrementFactory;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aopalliance.intercept.MethodInvocation;

public class BufferedIncrementAdvice
extends AnnotationChainableMethodAdvice<BufferedIncrement> {
    private static BufferedIncrement _nullBufferedIncrement = new BufferedIncrement(){

        public Class<? extends Annotation> annotationType() {
            return BufferedIncrement.class;
        }

        public String configuration() {
            return "default";
        }

        public Class<? extends Increment<?>> incrementClass() {
            return null;
        }
    };
    private Map<String, BufferedIncrementConfiguration> _bufferedIncrementConfigurations = new ConcurrentHashMap<String, BufferedIncrementConfiguration>();
    private ConcurrentMap<Method, BufferedIncrementProcessor> _bufferedIncrementProcessors = new ConcurrentHashMap<Method, BufferedIncrementProcessor>();

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        BufferedIncrementProcessor previousBufferedIncrementProcessor;
        BufferedIncrement bufferedIncrement = (BufferedIncrement)this.findAnnotation(methodInvocation);
        if (bufferedIncrement == _nullBufferedIncrement) {
            return null;
        }
        String configuration = bufferedIncrement.configuration();
        BufferedIncrementConfiguration bufferedIncrementConfiguration = this._bufferedIncrementConfigurations.get(configuration);
        if (bufferedIncrementConfiguration == null) {
            bufferedIncrementConfiguration = new BufferedIncrementConfiguration(configuration);
            this._bufferedIncrementConfigurations.put(configuration, bufferedIncrementConfiguration);
        }
        if (!bufferedIncrementConfiguration.isEnabled()) {
            return this.nullResult;
        }
        Method method = methodInvocation.getMethod();
        BufferedIncrementProcessor bufferedIncrementProcessor = (BufferedIncrementProcessor)this._bufferedIncrementProcessors.get(method);
        if (bufferedIncrementProcessor == null && (previousBufferedIncrementProcessor = this._bufferedIncrementProcessors.putIfAbsent(method, bufferedIncrementProcessor = new BufferedIncrementProcessor(bufferedIncrementConfiguration, method))) != null) {
            bufferedIncrementProcessor = previousBufferedIncrementProcessor;
        }
        Object[] arguments = methodInvocation.getArguments();
        Object value = arguments[arguments.length - 1];
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)BufferedIncrementAdvice.class.getName());
        for (int i = 0; i < arguments.length - 1; ++i) {
            cacheKeyGenerator.append(StringUtil.toHexString((Object)arguments[i]));
        }
        Serializable batchKey = cacheKeyGenerator.finish();
        Increment increment = IncrementFactory.createIncrement((Class)bufferedIncrement.incrementClass(), (Object)value);
        final BufferedIncrementProcessor callbackBufferedIncrementProcessor = bufferedIncrementProcessor;
        final BufferedIncreasableEntry bufferedIncreasableEntry = new BufferedIncreasableEntry(methodInvocation, batchKey, increment);
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                callbackBufferedIncrementProcessor.process(bufferedIncreasableEntry);
                return null;
            }
        });
        return this.nullResult;
    }

    public void destroy() {
        for (BufferedIncrementProcessor bufferedIncrementProcessor : this._bufferedIncrementProcessors.values()) {
            bufferedIncrementProcessor.destroy();
        }
    }

    @Override
    public BufferedIncrement getNullAnnotation() {
        return _nullBufferedIncrement;
    }
}

