/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.image.ImageMagickImpl;
import com.liferay.portal.kernel.concurrent.FutureConverter;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageMagick;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.jmge.gif.Gif89Encoder;
import org.im4java.core.IMOperation;

@DoPrivileged
public class ImageToolImpl
implements ImageTool {
    private static Log _log = LogFactoryUtil.getLog(ImageToolImpl.class);
    private static ImageTool _instance = new ImageToolImpl();
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static ImageMagick _imageMagick;
    private Image _defaultCompanyLogo;
    private Image _defaultOrganizationLogo;
    private Image _defaultSpacer;
    private Image _defaultUserFemalePortrait;
    private Image _defaultUserMalePortrait;

    public static ImageTool getInstance() {
        return _instance;
    }

    public void afterPropertiesSet() {
        InputStream is;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.spacer"));
            if (is == null) {
                _log.error((Object)"Default spacer is not available");
            }
            this._defaultSpacer = this.getImage(is);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to configure the default spacer: " + e.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.company.logo"));
            if (is == null) {
                _log.error((Object)"Default company logo is not available");
            }
            this._defaultCompanyLogo = this.getImage(is);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to configure the default company logo: " + e.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.organization.logo"));
            if (is == null) {
                _log.error((Object)"Default organization logo is not available");
            }
            this._defaultOrganizationLogo = this.getImage(is);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to configure the default organization logo: " + e.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.female.portrait"));
            if (is == null) {
                _log.error((Object)"Default user female portrait is not available");
            }
            this._defaultUserFemalePortrait = this.getImage(is);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to configure the default user female portrait: " + e.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.male.portrait"));
            if (is == null) {
                _log.error((Object)"Default user male portrait is not available");
            }
            this._defaultUserMalePortrait = this.getImage(is);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to configure the default user male portrait: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RenderedImage> convertCMYKtoRGB(byte[] bytes, final String type) {
        ImageMagick imageMagick = this.getImageMagick();
        if (!imageMagick.isEnabled()) {
            return null;
        }
        File inputFile = _fileUtil.createTempFile(type);
        final File outputFile = _fileUtil.createTempFile(type);
        try {
            _fileUtil.write(inputFile, bytes);
            IMOperation imOperation = new IMOperation();
            imOperation.addRawArgs(new String[]{"-format", "%[colorspace]"});
            imOperation.addImage(new String[]{inputFile.getPath()});
            String[] output = imageMagick.identify((List)imOperation.getCmdArgs());
            if (output.length == 1 && StringUtil.equalsIgnoreCase((String)output[0], (String)"CMYK")) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"The image is in the CMYK colorspace");
                }
                imOperation = new IMOperation();
                imOperation.addRawArgs(new String[]{"-colorspace", "RGB"});
                imOperation.addImage(new String[]{inputFile.getPath()});
                imOperation.addImage(new String[]{outputFile.getPath()});
                Future future = imageMagick.convert((List)imOperation.getCmdArgs());
                FutureConverter<RenderedImage, Object> futureConverter = new FutureConverter<RenderedImage, Object>(future){

                    protected RenderedImage convert(Object obj) {
                        RenderedImage renderedImage;
                        block2: {
                            renderedImage = null;
                            try {
                                ImageBag imageBag = ImageToolImpl.this.read(_fileUtil.getBytes(outputFile));
                                renderedImage = imageBag.getRenderedImage();
                            }
                            catch (IOException ioe) {
                                if (!_log.isDebugEnabled()) break block2;
                                _log.debug((Object)("Unable to convert " + type), (Throwable)ioe);
                            }
                        }
                        return renderedImage;
                    }
                };
                return futureConverter;
            }
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        finally {
            _fileUtil.delete(inputFile);
            _fileUtil.delete(outputFile);
        }
        return null;
    }

    public BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), type);
        Graphics2D graphics = targetImage.createGraphics();
        graphics.drawRenderedImage(sourceImage, null);
        graphics.dispose();
        return targetImage;
    }

    public RenderedImage crop(RenderedImage renderedImage, int height, int width, int x, int y) {
        Rectangle rectangle = new Rectangle(x, y, width, height);
        Rectangle croppedRectangle = rectangle.intersection(new Rectangle(renderedImage.getWidth(), renderedImage.getHeight()));
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        return bufferedImage.getSubimage(croppedRectangle.x, croppedRectangle.y, croppedRectangle.width, croppedRectangle.height);
    }

    public void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        if (JavaDetector.isJDK6()) {
            ImageIO.write(renderedImage, "gif", os);
        } else {
            BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
            if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
                bufferedImage = this.convertImageType(bufferedImage, 13);
            }
            Gif89Encoder encoder = new Gif89Encoder((java.awt.Image)bufferedImage);
            encoder.encode(os);
        }
    }

    public void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int type = sampleModel.getDataType();
        if (bufferedImage.getType() != 12 || type < 0 || type > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            BufferedImage binaryImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            Graphics graphics = binaryImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            renderedImage = binaryImage;
        }
        if (!ImageIO.write(renderedImage, "wbmp", os)) {
            os.write(0);
            os.write(0);
            os.write(this.toMultiByte(bufferedImage.getWidth()));
            os.write(this.toMultiByte(bufferedImage.getHeight()));
            DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
            int size = dataBuffer.getSize();
            for (int i = 0; i < size; ++i) {
                os.write((byte)dataBuffer.getElem(i));
            }
        }
    }

    public BufferedImage getBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>();
        Object[] keys = renderedImage.getPropertyNames();
        if (!ArrayUtil.isEmpty((Object[])keys)) {
            for (Object key : keys) {
                properties.put(key, renderedImage.getProperty((String)key));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), properties);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }

    public byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        this.write(renderedImage, contentType, (OutputStream)baos);
        return baos.toByteArray();
    }

    public Image getDefaultCompanyLogo() {
        return this._defaultCompanyLogo;
    }

    public Image getDefaultOrganizationLogo() {
        return this._defaultOrganizationLogo;
    }

    public Image getDefaultSpacer() {
        return this._defaultSpacer;
    }

    public Image getDefaultUserFemalePortrait() {
        return this._defaultUserFemalePortrait;
    }

    public Image getDefaultUserMalePortrait() {
        return this._defaultUserMalePortrait;
    }

    public Image getImage(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        ImageBag imageBag = this.read(bytes);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        if (renderedImage == null) {
            throw new IOException("Unable to decode image");
        }
        String type = imageBag.getType();
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        int size = bytes.length;
        ImageImpl image = new ImageImpl();
        image.setTextObj(bytes);
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        return image;
    }

    public Image getImage(File file) throws IOException {
        byte[] bytes = _fileUtil.getBytes(file);
        return this.getImage(bytes);
    }

    public Image getImage(InputStream is) throws IOException {
        byte[] bytes = _fileUtil.getBytes(is, -1, true);
        return this.getImage(bytes);
    }

    public Image getImage(InputStream is, boolean cleanUpStream) throws IOException {
        byte[] bytes = _fileUtil.getBytes(is, -1, cleanUpStream);
        return this.getImage(bytes);
    }

    public boolean isNullOrDefaultSpacer(byte[] bytes) {
        return ArrayUtil.isEmpty((byte[])bytes) || Arrays.equals(bytes, this.getDefaultSpacer().getTextObj());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageBag read(byte[] bytes) throws IOException {
        String formatName = null;
        ImageInputStream imageInputStream = null;
        LinkedList<ImageReader> imageReaders = new LinkedList<ImageReader>();
        BufferedImage renderedImage = null;
        try {
            boolean firstImageReader = true;
            imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                imageReaders.offer(imageReader);
                if (!firstImageReader) continue;
                imageReader.setInput(imageInputStream);
                renderedImage = imageReader.read(0);
                formatName = imageReader.getFormatName();
                firstImageReader = false;
            }
        }
        finally {
            while (!imageReaders.isEmpty()) {
                ImageReader imageReader = (ImageReader)imageReaders.poll();
                imageReader.dispose();
            }
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        formatName = StringUtil.toLowerCase(formatName);
        String type = "jpg";
        if (formatName.contains("bmp")) {
            type = "bmp";
        } else if (formatName.contains("gif")) {
            type = "gif";
        } else if (formatName.contains("jpeg") || type.equals("jpeg")) {
            type = "jpg";
        } else if (formatName.contains("png")) {
            type = "png";
        } else if (formatName.contains("tiff")) {
            type = "tiff";
        } else {
            throw new IllegalArgumentException(type + " is not supported");
        }
        return new ImageBag((RenderedImage)renderedImage, type);
    }

    public ImageBag read(File file) throws IOException {
        return this.read(_fileUtil.getBytes(file));
    }

    public ImageBag read(InputStream inputStream) throws IOException {
        return this.read(_fileUtil.getBytes(inputStream));
    }

    public RenderedImage scale(RenderedImage renderedImage, int width) {
        if (width <= 0) {
            return renderedImage;
        }
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        double factor = (double)width / (double)imageWidth;
        int scaledHeight = (int)(factor * (double)imageHeight);
        int scaledWidth = width;
        return this.doScale(renderedImage, scaledHeight, scaledWidth);
    }

    public RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        if (maxHeight == 0) {
            maxHeight = imageHeight;
        }
        if (maxWidth == 0) {
            maxWidth = imageWidth;
        }
        if (imageHeight <= maxHeight && imageWidth <= maxWidth) {
            return renderedImage;
        }
        double factor = Math.min((double)maxHeight / (double)imageHeight, (double)maxWidth / (double)imageWidth);
        int scaledHeight = Math.max(1, (int)(factor * (double)imageHeight));
        int scaledWidth = Math.max(1, (int)(factor * (double)imageWidth));
        return this.doScale(renderedImage, scaledHeight, scaledWidth);
    }

    public void write(RenderedImage renderedImage, String contentType, OutputStream os) throws IOException {
        if (contentType.contains("bmp")) {
            ImageIO.write(renderedImage, "bmp", os);
        } else if (contentType.contains("gif")) {
            this.encodeGIF(renderedImage, os);
        } else if (contentType.contains("jpg") || contentType.contains("jpeg")) {
            ImageIO.write(renderedImage, "jpeg", os);
        } else if (contentType.contains("png")) {
            ImageIO.write(renderedImage, "png", os);
        } else if (contentType.contains("tiff") || contentType.contains("tif")) {
            ImageIO.write(renderedImage, "tiff", os);
        }
    }

    protected RenderedImage doScale(RenderedImage renderedImage, int scaledHeight, int scaledWidth) {
        BufferedImage originalBufferedImage = this.getBufferedImage(renderedImage);
        ColorModel originalColorModel = originalBufferedImage.getColorModel();
        Graphics2D originalGraphics2D = originalBufferedImage.createGraphics();
        if (originalColorModel.hasAlpha()) {
            originalGraphics2D.setComposite(AlphaComposite.Src);
        }
        GraphicsConfiguration originalGraphicsConfiguration = originalGraphics2D.getDeviceConfiguration();
        BufferedImage scaledBufferedImage = originalGraphicsConfiguration.createCompatibleImage(scaledWidth, scaledHeight, originalBufferedImage.getTransparency());
        Graphics scaledGraphics = scaledBufferedImage.getGraphics();
        scaledGraphics.drawImage(originalBufferedImage.getScaledInstance(scaledWidth, scaledHeight, 4), 0, 0, null);
        originalGraphics2D.dispose();
        return scaledBufferedImage;
    }

    protected ImageMagick getImageMagick() {
        if (_imageMagick == null) {
            _imageMagick = ImageMagickImpl.getInstance();
            _imageMagick.reset();
        }
        return _imageMagick;
    }

    protected byte[] toMultiByte(int intValue) {
        int numBits = 32;
        for (int mask = Integer.MIN_VALUE; mask != 0 && (intValue & mask) == 0; mask >>>= 1) {
            --numBits;
        }
        int numBitsLeft = numBits;
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        for (int b = 0; b <= maxIndex; ++b) {
            multiBytes[b] = (byte)(intValue >>> (maxIndex - b) * 7 & 0x7F);
            if (b == maxIndex) continue;
            int n = b;
            multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
        }
        return multiBytes;
    }

    private ImageToolImpl() {
        ImageIO.setUseCache(PropsValues.IMAGE_IO_USE_DISK_CACHE);
    }
}

