/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.Image;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.io.IOException;
import java.io.InputStream;

public class DLHook
extends BaseHook {
    private static final long _COMPANY_ID = 0L;
    private static final long _REPOSITORY_ID = 0L;

    public void deleteImage(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        try {
            DLStoreUtil.deleteFile((long)0L, (long)0L, (String)fileName);
        }
        catch (NoSuchFileException nsfe) {
            throw new NoSuchImageException((Throwable)nsfe);
        }
    }

    public byte[] getImageAsBytes(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        InputStream is = DLStoreUtil.getFileAsStream((long)0L, (long)0L, (String)fileName);
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((InputStream)is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return bytes;
    }

    public InputStream getImageAsStream(Image image) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        return DLStoreUtil.getFileAsStream((long)0L, (long)0L, (String)fileName);
    }

    public void updateImage(Image image, String type, byte[] bytes) throws PortalException {
        String fileName = this.getFileName(image.getImageId(), image.getType());
        if (DLStoreUtil.hasFile((long)0L, (long)0L, (String)fileName)) {
            DLStoreUtil.deleteFile((long)0L, (long)0L, (String)fileName);
        }
        DLStoreUtil.addFile((long)0L, (long)0L, (String)fileName, (boolean)true, (byte[])bytes);
    }

    protected String getFileName(long imageId, String type) {
        return imageId + "." + type;
    }
}

