/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.LiferayObjectConstructor;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Theme;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplatePortletPreferences;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import freemarker.ext.beans.BeansWrapper;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FreeMarkerTemplateContextHelper
extends TemplateContextHelper {
    @Override
    public Set<String> getRestrictedVariables() {
        return SetUtil.fromArray((Object[])PropsValues.FREEMARKER_ENGINE_RESTRICTED_VARIABLES);
    }

    @Override
    public void prepare(Template template, HttpServletRequest request) {
        Map ftlVariables;
        super.prepare(template, request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            Theme theme = themeDisplay.getTheme();
            String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
            template.put("fullCssPath", (Object)("/" + servletContextName + theme.getFreeMarkerTemplateLoader() + theme.getCssPath()));
            template.put("fullTemplatesPath", (Object)("/" + servletContextName + theme.getFreeMarkerTemplateLoader() + theme.getTemplatesPath()));
            template.put("init", (Object)("/" + themeDisplay.getPathContext() + "_SERVLET_CONTEXT_" + "/html/themes/_unstyled/templates/init.ftl"));
        }
        if ((ftlVariables = (Map)request.getAttribute("FTL_VARIABLES")) != null) {
            for (Map.Entry entry : ftlVariables.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!Validator.isNotNull((String)key)) continue;
                template.put(key, value);
            }
        }
    }

    @Override
    protected void populateExtraHelperUtilities(Map<String, Object> helperUtilities) {
        helperUtilities.put("enumUtil", BeansWrapper.getDefaultInstance().getEnumModels());
        helperUtilities.put("objectUtil", new LiferayObjectConstructor());
        helperUtilities.put("freeMarkerPortletPreferences", new TemplatePortletPreferences());
        helperUtilities.put("staticUtil", BeansWrapper.getDefaultInstance().getStaticModels());
    }
}

