/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.AbstractTemplate;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.util.PropsValues;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;

public class FreeMarkerTemplate
extends AbstractTemplate {
    private Configuration _configuration;
    private boolean _privileged;

    public FreeMarkerTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, Map<String, Object> context, Configuration configuration, TemplateContextHelper templateContextHelper, boolean privileged) {
        super(templateResource, errorTemplateResource, context, templateContextHelper, "ftl", PropsValues.FREEMARKER_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL);
        this._configuration = configuration;
        this._privileged = privileged;
    }

    @Override
    protected void handleException(Exception exception, Writer writer) throws com.liferay.portal.kernel.template.TemplateException {
        if (exception instanceof ParseException || exception instanceof TemplateException) {
            this.put("exception", exception.getMessage());
            if (this.templateResource instanceof StringTemplateResource) {
                StringTemplateResource stringTemplateResource = (StringTemplateResource)this.templateResource;
                this.put("script", stringTemplateResource.getContent());
            }
            if (exception instanceof ParseException) {
                ParseException pe = (ParseException)exception;
                this.put("column", pe.getColumnNumber());
                this.put("line", pe.getLineNumber());
            }
            try {
                this.processTemplate(this.errorTemplateResource, writer);
            }
            catch (Exception e) {
                throw new com.liferay.portal.kernel.template.TemplateException("Unable to process FreeMarker template " + this.errorTemplateResource.getTemplateId(), (Throwable)e);
            }
        } else {
            throw new com.liferay.portal.kernel.template.TemplateException("Unable to process FreeMarker template " + this.templateResource.getTemplateId(), (Throwable)exception);
        }
    }

    @Override
    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        TemplateResourceThreadLocal.setTemplateResource("ftl", templateResource);
        try {
            Template template = null;
            template = this._privileged ? AccessController.doPrivileged(new TemplatePrivilegedExceptionAction(templateResource)) : this._configuration.getTemplate(this.getTemplateResourceUUID(templateResource), "UTF-8");
            template.process((Object)this.context, writer);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        finally {
            TemplateResourceThreadLocal.setTemplateResource("ftl", null);
        }
    }

    private class TemplatePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Template> {
        private TemplateResource _templateResource;

        public TemplatePrivilegedExceptionAction(TemplateResource templateResource) {
            this._templateResource = templateResource;
        }

        @Override
        public Template run() throws Exception {
            return FreeMarkerTemplate.this._configuration.getTemplate(FreeMarkerTemplate.this.getTemplateResourceUUID(this._templateResource), "UTF-8");
        }
    }
}

