/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.rpc;

import com.liferay.portal.fabric.netty.handlers.NettyChannelAttributes;
import com.liferay.portal.fabric.netty.rpc.RPCCallable;
import com.liferay.portal.fabric.netty.rpc.RPCRequest;
import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;

public class RPCUtil {
    private static Log _log = LogFactoryUtil.getLog(RPCUtil.class);

    public static <T extends Serializable> NoticeableFuture<T> execute(Channel channel, RPCCallable<T> rpcCallable) {
        final AsyncBroker asyncBroker = NettyChannelAttributes.getAsyncBroker(channel);
        final long id = NettyChannelAttributes.nextId(channel);
        final NoticeableFuture noticeableFuture = asyncBroker.post((Object)id);
        ChannelFuture channelFuture = channel.writeAndFlush(new RPCRequest<T>(id, rpcCallable));
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    return;
                }
                if (channelFuture.isCancelled()) {
                    noticeableFuture.cancel(true);
                    return;
                }
                if (!asyncBroker.takeWithException((Object)id, channelFuture.cause())) {
                    _log.error((Object)("Unable to place exception because no future exists with ID " + id), channelFuture.cause());
                }
            }
        });
        return noticeableFuture;
    }
}

