/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.rpc;

import com.liferay.portal.fabric.netty.handlers.NettyChannelAttributes;
import com.liferay.portal.fabric.netty.rpc.RPCSerializable;
import com.liferay.portal.kernel.concurrent.AsyncBroker;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import io.netty.channel.Channel;
import java.io.Serializable;

public class RPCResponse<T extends Serializable>
extends RPCSerializable {
    private static Log _log = LogFactoryUtil.getLog(RPCResponse.class);
    private static final long serialVersionUID = 1L;
    private final boolean _cancelled;
    private final T _result;
    private final Throwable _throwable;

    public RPCResponse(long id, boolean cancelled, T result, Throwable throwable) {
        super(id);
        this._cancelled = cancelled;
        this._result = result;
        this._throwable = throwable;
    }

    @Override
    public void execute(Channel channel) {
        AsyncBroker asyncBroker = NettyChannelAttributes.getAsyncBroker(channel);
        if (this._cancelled) {
            NoticeableFuture noticeableFuture = asyncBroker.take((Object)this.id);
            if (noticeableFuture == null) {
                _log.error((Object)("Unable to place cancellation because no future exists with ID " + this.id));
            } else if (noticeableFuture.cancel(true)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Cancelled future with ID " + this.id));
                }
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to cancel future with ID " + this.id + " because it is already completed"));
            }
        } else if (this._throwable != null) {
            if (!asyncBroker.takeWithException((Object)this.id, this._throwable)) {
                _log.error((Object)("Unable to place exception because no future exists with ID " + this.id), this._throwable);
            }
        } else if (!asyncBroker.takeWithResult((Object)this.id, this._result)) {
            _log.error((Object)("Unable to place result " + this._result + " because no future exists with ID " + this.id));
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{cancelled=");
        sb.append(this._cancelled);
        sb.append(", id=");
        sb.append(this.id);
        sb.append(", result=");
        sb.append(this._result);
        sb.append(", throwable=");
        sb.append((Object)this._throwable);
        sb.append("}");
        return sb.toString();
    }
}

