/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.rpc;

import com.liferay.portal.fabric.netty.rpc.ChannelThreadLocal;
import com.liferay.portal.fabric.netty.rpc.RPCCallable;
import com.liferay.portal.fabric.netty.rpc.RPCResponse;
import com.liferay.portal.fabric.netty.rpc.RPCSerializable;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class RPCRequest<T extends Serializable>
extends RPCSerializable {
    private static Log _log = LogFactoryUtil.getLog(RPCRequest.class);
    private static final long serialVersionUID = 1L;
    private final RPCCallable<T> _rpcCallable;

    public RPCRequest(long id, RPCCallable<T> rpcCallable) {
        super(id);
        this._rpcCallable = rpcCallable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Channel channel) {
        ChannelThreadLocal.setChannel(channel);
        try {
            NoticeableFuture<T> noticeableFuture = this._rpcCallable.call();
            noticeableFuture.addFutureListener(new FutureListener<T>(){

                public void complete(Future<T> future) {
                    if (future.isCancelled()) {
                        RPCRequest.this.sendRPCResponse(channel, new RPCResponse<Object>(RPCRequest.this.id, true, null, null));
                        return;
                    }
                    try {
                        RPCRequest.this.sendRPCResponse(channel, new RPCResponse<Serializable>(RPCRequest.this.id, false, (Serializable)future.get(), null));
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ExecutionException) {
                            throwable = throwable.getCause();
                        }
                        RPCRequest.this.sendRPCResponse(channel, new RPCResponse<Object>(RPCRequest.this.id, false, null, throwable));
                    }
                }
            });
        }
        catch (Throwable t) {
            this.sendRPCResponse(channel, new RPCResponse<Object>(this.id, false, null, t));
        }
        finally {
            ChannelThreadLocal.removeChannel();
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{id=");
        sb.append(this.id);
        sb.append(", rpcCallable=");
        sb.append(this._rpcCallable);
        sb.append("}");
        return sb.toString();
    }

    protected void sendRPCResponse(Channel channel, RPCResponse<T> rpcResponse) {
        ChannelFuture channelFuture = channel.writeAndFlush(rpcResponse);
        channelFuture.addListener((GenericFutureListener)new LogErrorFutureListener(rpcResponse));
    }

    protected static class LogErrorFutureListener
    implements ChannelFutureListener {
        private final RPCResponse<?> _rpcResponse;

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                return;
            }
            if (channelFuture.isCancelled()) {
                _log.error((Object)("Cancelled on sending RPC response: " + this._rpcResponse));
                return;
            }
            _log.error((Object)("Unable to send RPC response: " + this._rpcResponse), channelFuture.cause());
        }

        protected LogErrorFutureListener(RPCResponse<?> rpcResponse) {
            this._rpcResponse = rpcResponse;
        }
    }
}

