/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.handlers;

import com.liferay.portal.fabric.netty.rpc.RPCUtil;
import com.liferay.portal.kernel.concurrent.AsyncBroker;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class NettyChannelAttributes {
    private static final AttributeKey<AsyncBroker<Long, Serializable>> _asyncBrokerKey = AttributeKey.valueOf((String)(RPCUtil.class.getName() + "-AsyncBroker"));
    private static final AttributeKey<AtomicLong> _idGeneratorKey = AttributeKey.valueOf((String)(RPCUtil.class.getName() + "-IdGenerator"));

    public static <T extends Serializable> AsyncBroker<Long, T> getAsyncBroker(Channel channel) {
        AsyncBroker previousAsyncBroker;
        Attribute attribute = channel.attr(_asyncBrokerKey);
        AsyncBroker asyncBroker = (AsyncBroker)attribute.get();
        if (asyncBroker == null && (previousAsyncBroker = (AsyncBroker)attribute.setIfAbsent((Object)(asyncBroker = new AsyncBroker()))) != null) {
            asyncBroker = previousAsyncBroker;
        }
        return asyncBroker;
    }

    public static long nextId(Channel channel) {
        AtomicLong previousAttachmentIdGenerator;
        Attribute attribute = channel.attr(_idGeneratorKey);
        AtomicLong attachmentIdGenerator = (AtomicLong)attribute.get();
        if (attachmentIdGenerator == null && (previousAttachmentIdGenerator = (AtomicLong)attribute.setIfAbsent((Object)(attachmentIdGenerator = new AtomicLong()))) != null) {
            attachmentIdGenerator = previousAttachmentIdGenerator;
        }
        return attachmentIdGenerator.getAndIncrement();
    }
}

