/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver;

import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean _deleteAfterFetch;
    private final long _lastModifiedTime;
    private final String _path;

    public FileRequest(Path path, long lastModifiedTime, boolean deleteAfterFetch) {
        this._path = String.valueOf(path.toAbsolutePath());
        this._lastModifiedTime = lastModifiedTime;
        this._deleteAfterFetch = deleteAfterFetch;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileRequest)) {
            return false;
        }
        FileRequest fileRequest = (FileRequest)obj;
        return this._deleteAfterFetch == fileRequest._deleteAfterFetch && this._lastModifiedTime == fileRequest._lastModifiedTime && this._path.equals(fileRequest._path);
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public Path getPath() {
        return Paths.get(this._path, new String[0]);
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (boolean)this._deleteAfterFetch);
        hash = HashUtil.hash((int)hash, (long)this._lastModifiedTime);
        hash = HashUtil.hash((int)hash, (Object)this._path);
        return hash;
    }

    public boolean isDeleteAfterFetch() {
        return this._deleteAfterFetch;
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{deleteAfterFetch=");
        sb.append(this._deleteAfterFetch);
        sb.append(", lastModifiedTime=");
        sb.append(this._lastModifiedTime);
        sb.append(", path=");
        sb.append(this._path);
        sb.append("}");
        return sb.toString();
    }
}

