/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.fileserver;

import com.liferay.portal.fabric.netty.fileserver.CompressionLevel;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileHelperUtil {
    public static final Path TEMP_DIR_PATH = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static Log _log = LogFactoryUtil.getLog(FileHelperUtil.class);

    public static void delete(final boolean quiet, Path ... paths) {
        block3: {
            try {
                for (Path path : paths) {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException ioe) throws IOException {
                            if (ioe != null && !quiet) {
                                throw ioe;
                            }
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException ioe) throws IOException {
                            if (quiet || ioe instanceof NoSuchFileException) {
                                return FileVisitResult.CONTINUE;
                            }
                            throw ioe;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
            catch (IOException ioe) {
                if (quiet) break block3;
                ReflectionUtil.throwException((Throwable)ioe);
            }
        }
    }

    public static void delete(Path ... paths) {
        FileHelperUtil.delete(false, paths);
    }

    public static void move(Path fromPath, Path toPath) throws IOException {
        FileHelperUtil.move(fromPath, toPath, true);
    }

    public static void move(final Path fromPath, final Path toPath, boolean tryAtomicMove) throws IOException {
        final AtomicBoolean atomicMove = new AtomicBoolean(tryAtomicMove);
        final AtomicBoolean touched = new AtomicBoolean();
        final HashMap fileTimes = new HashMap();
        try {
            Files.walkFileTree(fromPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException ioe) throws IOException {
                    Files.setLastModifiedTime(toPath.resolve(fromPath.relativize(dir)), (FileTime)fileTimes.remove(dir));
                    if (atomicMove.get()) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path toFile = toPath.resolve(fromPath.relativize(file));
                    if (atomicMove.get()) {
                        try {
                            Files.move(file, toFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                            touched.set(true);
                            return FileVisitResult.CONTINUE;
                        }
                        catch (AtomicMoveNotSupportedException amnse) {
                            atomicMove.set(false);
                        }
                    }
                    Files.copy(file, toFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.copy(dir, toPath.resolve(fromPath.relativize(dir)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    fileTimes.put(dir, Files.getLastModifiedTime(dir, new LinkOption[0]));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioe) {
            FileHelperUtil.delete(true, toPath);
            if (touched.get()) {
                throw new IOException("Source path " + fromPath + " was left in an " + "inconsistent state", ioe);
            }
            throw ioe;
        }
        if (!atomicMove.get()) {
            FileHelperUtil.delete(false, fromPath);
        }
    }

    public static Path unzip(Path sourcePath, Path destDirPath) throws IOException {
        Path destPath = Files.createTempDirectory(destDirPath, null, new FileAttribute[0]);
        try (InputStream inputStream = Files.newInputStream(sourcePath, new OpenOption[0]);){
            long startTime = System.currentTimeMillis();
            long rawSize = FileHelperUtil.unzip(new ZipInputStream(inputStream), destPath);
            if (_log.isDebugEnabled()) {
                long zippedSize = Files.size(sourcePath);
                long time = (System.currentTimeMillis() - startTime) / 1000L;
                double compressionRatio = rawSize / zippedSize;
                StringBundler sb = new StringBundler(13);
                sb.append("Unzipped ");
                sb.append((Object)sourcePath);
                sb.append(" (");
                sb.append(zippedSize);
                sb.append(" bytes) to ");
                sb.append((Object)destPath);
                sb.append(" (");
                sb.append(rawSize);
                sb.append(" bytes)\" in ");
                sb.append(time);
                sb.append("s with a ");
                sb.append(compressionRatio);
                sb.append("compression ratio");
                _log.debug((Object)sb.toString());
            }
        }
        catch (IOException ioe) {
            FileHelperUtil.delete(destPath);
            throw ioe;
        }
        return destPath;
    }

    public static long unzip(ZipInputStream zipInputStream, Path destPath) throws IOException {
        AtomicLong rawSize = new AtomicLong();
        try (ZipInputStream autoCloseZipInputStream = zipInputStream;){
            ZipEntry zipEntry = null;
            while ((zipEntry = autoCloseZipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                Path entryPath = destPath.resolve(zipEntry.getName());
                Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                long size = Files.copy(autoCloseZipInputStream, entryPath, new CopyOption[0]);
                rawSize.addAndGet(size);
                Files.setLastModifiedTime(entryPath, FileTime.fromMillis(BigEndianCodec.getLong((byte[])zipEntry.getExtra(), (int)0)));
                long length = BigEndianCodec.getLong((byte[])zipEntry.getExtra(), (int)8);
                if (size == length) continue;
                throw new IOException("Zip stream for entry " + zipEntry.getName() + " is " + size + " bytes but should " + length + " bytes");
            }
        }
        return rawSize.get();
    }

    public static Path zip(Path sourcePath, Path destDirPath, CompressionLevel compressionLevel) throws IOException {
        Path zipPath = Files.createTempFile(destDirPath, null, null, new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(zipPath, new OpenOption[0]);){
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.setLevel(compressionLevel.getLevel());
            long startTime = System.currentTimeMillis();
            long rawSize = FileHelperUtil.zip(sourcePath, zipOutputStream);
            if (_log.isDebugEnabled()) {
                long zippedSize = Files.size(zipPath);
                long time = (System.currentTimeMillis() - startTime) / 1000L;
                double compressionRatio = rawSize / zippedSize;
                StringBundler sb = new StringBundler(13);
                sb.append("Zipped ");
                sb.append((Object)sourcePath);
                sb.append(" (");
                sb.append(rawSize);
                sb.append(" bytes) to ");
                sb.append((Object)zipPath);
                sb.append(" (");
                sb.append(zippedSize);
                sb.append(" bytes)\" in ");
                sb.append(time);
                sb.append("s with a ");
                sb.append(compressionRatio);
                sb.append("compression ratio");
                _log.debug((Object)sb.toString());
            }
        }
        catch (IOException ioe) {
            Files.delete(zipPath);
            throw ioe;
        }
        return zipPath;
    }

    public static long zip(final Path sourcePath, ZipOutputStream zipOutputStream) throws IOException {
        final AtomicLong rawSize = new AtomicLong();
        final byte[] buffer = new byte[16];
        try (final ZipOutputStream autoClosezipOutputStream = zipOutputStream;){
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path relativePath = sourcePath.relativize(file);
                    ZipEntry zipEntry = new ZipEntry(relativePath.toString());
                    FileTime fileTime = basicFileAttributes.lastModifiedTime();
                    rawSize.addAndGet(basicFileAttributes.size());
                    BigEndianCodec.putLong((byte[])buffer, (int)0, (long)fileTime.toMillis());
                    BigEndianCodec.putLong((byte[])buffer, (int)8, (long)basicFileAttributes.size());
                    zipEntry.setExtra(buffer);
                    autoClosezipOutputStream.putNextEntry(zipEntry);
                    Files.copy(file, autoClosezipOutputStream);
                    autoClosezipOutputStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return rawSize.get();
    }
}

