/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.expression;

import com.liferay.portal.expression.Variable;
import com.liferay.portal.expression.VariableNamesExtractor;
import com.liferay.portal.kernel.expression.Expression;
import com.liferay.portal.kernel.expression.ExpressionEvaluationException;
import com.liferay.portal.kernel.expression.VariableDependencies;
import com.liferay.portal.kernel.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.janino.ExpressionEvaluator;

public class ExpressionImpl<T>
implements Expression<T> {
    private Class<?> _expressionClass;
    private String _expressionString;
    private VariableNamesExtractor _variableNamesExtractor = new VariableNamesExtractor();
    private Map<String, Variable> _variables = new TreeMap<String, Variable>();
    private Map<String, Object> _variableValues = new HashMap<String, Object>();

    public ExpressionImpl(String expressionString, Class<T> expressionClass) {
        this._expressionString = expressionString;
        this._expressionClass = expressionClass;
        List<String> variableNames = this._variableNamesExtractor.extract(expressionString);
        for (String variableName : variableNames) {
            Variable variable = new Variable(variableName);
            this._variables.put(variableName, variable);
        }
    }

    public T evaluate() throws ExpressionEvaluationException {
        try {
            ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
            expressionEvaluator.setExpressionType(this._expressionClass);
            expressionEvaluator.setExtendedClass(MathUtil.class);
            expressionEvaluator.setParameters(this.getVariableNames(), (Class[])this.getVariableClasses());
            expressionEvaluator.cook(this._expressionString);
            return (T)expressionEvaluator.evaluate(this.getVariableValues());
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Throwable)e);
        }
    }

    public Map<String, VariableDependencies> getVariableDependenciesMap() {
        HashMap<String, VariableDependencies> variableDependenciesMap = new HashMap<String, VariableDependencies>();
        for (Variable variable : this._variables.values()) {
            this.populateVariableDependenciesMap(variable, variableDependenciesMap);
        }
        return variableDependenciesMap;
    }

    public void setBooleanVariableValue(String variableName, Boolean variableValue) {
        this.setVariableValue(variableName, variableValue, Boolean.class);
    }

    public void setDoubleVariableValue(String variableName, Double variableValue) {
        this.setVariableValue(variableName, variableValue, Double.class);
    }

    public void setExpressionStringVariableValue(String variableName, String variableValue, Class<?> variableClass) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setExpressionString(variableValue);
        variable.setVariableClass(variableClass);
    }

    public void setFloatVariableValue(String variableName, Float variableValue) {
        this.setVariableValue(variableName, variableValue, Float.class);
    }

    public void setIntegerVariableValue(String variableName, Integer variableValue) {
        this.setVariableValue(variableName, variableValue, Integer.class);
    }

    public void setLongVariableValue(String variableName, Long variableValue) {
        this.setVariableValue(variableName, variableValue, Long.class);
    }

    public void setStringVariableValue(String variableName, String variableValue) {
        this.setVariableValue(variableName, variableValue, String.class);
    }

    public void setVariableValue(String variableName, Object variableValue, Class<?> variableClass) {
        Variable variable = this._variables.get(variableName);
        if (variable == null) {
            return;
        }
        variable.setValue(variableValue);
        variable.setVariableClass(variableClass);
    }

    protected <V> Expression<V> getExpression(String expressionString, Class<V> expressionType) throws ExpressionEvaluationException {
        ExpressionImpl<V> expression = new ExpressionImpl<V>(expressionString, expressionType);
        List<String> variableNames = this._variableNamesExtractor.extract(expressionString);
        for (String variableName : variableNames) {
            Variable variable = this._variables.get(variableName);
            expression.setVariableValue(variableName, this.getVariableValue(variable), variable.getVariableClass());
        }
        return expression;
    }

    protected Expression<?> getExpression(Variable variable) throws ExpressionEvaluationException {
        if (variable.getExpressionString() == null) {
            return null;
        }
        Expression<?> expression = this.getExpression(variable.getExpressionString(), variable.getVariableClass());
        return expression;
    }

    protected Class<?>[] getVariableClasses() {
        ArrayList variableClasses = new ArrayList();
        for (Variable variable : this._variables.values()) {
            variableClasses.add(variable.getVariableClass());
        }
        return variableClasses.toArray(new Class[variableClasses.size()]);
    }

    protected String[] getVariableNames() {
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Variable variable : this._variables.values()) {
            variableNames.add(variable.getName());
        }
        return variableNames.toArray(new String[variableNames.size()]);
    }

    protected Object getVariableValue(Variable variable) throws ExpressionEvaluationException {
        Object variableValue = this._variableValues.get(variable.getName());
        if (variableValue != null) {
            return variableValue;
        }
        Expression<?> expression = this.getExpression(variable);
        if (expression == null) {
            return variable.getValue();
        }
        variableValue = expression.evaluate();
        this._variableValues.put(variable.getName(), variableValue);
        return variableValue;
    }

    protected Object[] getVariableValues() throws ExpressionEvaluationException {
        ArrayList<Object> variableValues = new ArrayList<Object>();
        for (Variable variable : this._variables.values()) {
            Object variableValue = this.getVariableValue(variable);
            variableValues.add(variableValue);
        }
        return variableValues.toArray(new Object[variableValues.size()]);
    }

    protected VariableDependencies populateVariableDependenciesMap(Variable variable, Map<String, VariableDependencies> variableDependenciesMap) {
        VariableDependencies variableDependencies = variableDependenciesMap.get(variable.getName());
        if (variableDependencies != null) {
            return variableDependencies;
        }
        variableDependencies = new VariableDependencies(variable.getName());
        if (variable.getExpressionString() != null) {
            List<String> variableNames = this._variableNamesExtractor.extract(variable.getExpressionString());
            for (String variableName : variableNames) {
                VariableDependencies variableVariableDependencies = this.populateVariableDependenciesMap(this._variables.get(variableName), variableDependenciesMap);
                variableVariableDependencies.addAffectedVariable(variableDependencies.getVariableName());
                variableDependencies.addRequiredVariable(variableVariableDependencies.getVariableName());
            }
        }
        variableDependenciesMap.put(variable.getName(), variableDependencies);
        return variableDependencies;
    }
}

