/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor;

import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorFactory;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@DoPrivileged
public class PortalExecutorManagerImpl
implements PortalExecutorManager {
    private static Log _log = LogFactoryUtil.getLog(PortalExecutorManagerImpl.class);
    private PortalExecutorFactory _portalExecutorFactory;
    private Map<String, ThreadPoolExecutor> _threadPoolExecutors = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public void afterPropertiesSet() {
        if (this._portalExecutorFactory == null) {
            throw new IllegalArgumentException("Portal executor factory is null");
        }
    }

    public <T> NoticeableFuture<T> execute(String name, Callable<T> callable) {
        ThreadPoolExecutor threadPoolExecutor = this.getPortalExecutor(name);
        return threadPoolExecutor.submit(callable);
    }

    public <T> T execute(String name, Callable<T> callable, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        ThreadPoolExecutor threadPoolExecutor = this.getPortalExecutor(name);
        NoticeableFuture future = threadPoolExecutor.submit(callable);
        return (T)future.get(timeout, timeUnit);
    }

    public ThreadPoolExecutor getPortalExecutor(String name) {
        return this.getPortalExecutor(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getPortalExecutor(String name, boolean createIfAbsent) {
        ThreadPoolExecutor threadPoolExecutor = this._threadPoolExecutors.get(name);
        if (threadPoolExecutor == null && createIfAbsent) {
            Map<String, ThreadPoolExecutor> map = this._threadPoolExecutors;
            synchronized (map) {
                threadPoolExecutor = this._threadPoolExecutors.get(name);
                if (threadPoolExecutor == null) {
                    threadPoolExecutor = this._portalExecutorFactory.createPortalExecutor(name);
                    this._threadPoolExecutors.put(name, threadPoolExecutor);
                }
            }
        }
        return threadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor registerPortalExecutor(String name, ThreadPoolExecutor threadPoolExecutor) {
        ThreadPoolExecutor oldThreadPoolExecutor = this._threadPoolExecutors.get(name);
        if (oldThreadPoolExecutor == null) {
            Map<String, ThreadPoolExecutor> map = this._threadPoolExecutors;
            synchronized (map) {
                oldThreadPoolExecutor = this._threadPoolExecutors.get(name);
                if (oldThreadPoolExecutor == null) {
                    oldThreadPoolExecutor = this._threadPoolExecutors.put(name, threadPoolExecutor);
                }
            }
        }
        return oldThreadPoolExecutor;
    }

    public void setPortalExecutorFactory(PortalExecutorFactory portalExecutorFactory) {
        this._portalExecutorFactory = portalExecutorFactory;
    }

    public void setPortalExecutors(Map<String, ThreadPoolExecutor> threadPoolExecutors) {
        if (threadPoolExecutors != null) {
            this._threadPoolExecutors = new ConcurrentHashMap<String, ThreadPoolExecutor>(threadPoolExecutors);
        }
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean interrupt) {
        for (Map.Entry<String, ThreadPoolExecutor> entry : this._threadPoolExecutors.entrySet()) {
            ThreadPoolExecutor threadPoolExecutor = entry.getValue();
            if (interrupt) {
                threadPoolExecutor.shutdownNow();
                continue;
            }
            threadPoolExecutor.shutdown();
        }
        this._threadPoolExecutors.clear();
    }

    public void shutdown(String name) {
        this.shutdown(name, false);
    }

    public void shutdown(String name, boolean interrupt) {
        ThreadPoolExecutor threadPoolExecutor = this._threadPoolExecutors.remove(name);
        if (threadPoolExecutor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No portal executor found for name " + name));
            }
            return;
        }
        if (interrupt) {
            threadPoolExecutor.shutdownNow();
        } else {
            threadPoolExecutor.shutdown();
        }
    }
}

