/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteMinderLogoutAction
extends Action {
    private static final String _SMIDENTITY = "SMIDENTITY";
    private static final String _SMSESSION = "SMSESSION";
    private static Log _log = LogFactoryUtil.getLog(SiteMinderLogoutAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) {
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PrefsPropsUtil.getBoolean(companyId, "siteminder.auth.enabled", PropsValues.SITEMINDER_AUTH_ENABLED)) {
                return;
            }
            String domain = CookieKeys.getDomain((HttpServletRequest)request);
            Cookie smSessionCookie = new Cookie(_SMSESSION, "");
            if (Validator.isNotNull((String)domain)) {
                smSessionCookie.setDomain(domain);
            }
            smSessionCookie.setMaxAge(0);
            smSessionCookie.setPath("/");
            Cookie smIdentityCookie = new Cookie(_SMIDENTITY, "");
            if (Validator.isNotNull((String)domain)) {
                smIdentityCookie.setDomain(domain);
            }
            smIdentityCookie.setMaxAge(0);
            smIdentityCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)smSessionCookie);
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)smIdentityCookie);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

