/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.LayoutPermissionException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

public class ServicePreAction
extends Action {
    protected File privateLARFile;
    protected File publicLARFile;
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final String _PATH_PORTAL_LOGIN = "/portal/login";
    private static final String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static Log _log = LogFactoryUtil.getLog(ServicePreAction.class);

    public ServicePreAction() {
        this.initImportLARFiles();
    }

    public ThemeDisplay initThemeDisplay(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Group refererLayoutGroup;
        Layout refererLayout;
        boolean themeJsBarebone;
        long sourceGroupId;
        boolean signedIn;
        HttpSession session = request.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        long companyId = company.getCompanyId();
        String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request);
        String dynamicResourcesCDNHost = "";
        boolean cdnDynamicResourceEnabled = PortalUtil.isCDNDynamicResourcesEnabled((HttpServletRequest)request);
        if (cdnDynamicResourceEnabled) {
            dynamicResourcesCDNHost = cdnHost;
        }
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        String contextPath = PortalUtil.getPathContext();
        String friendlyURLPrivateGroupPath = PortalUtil.getPathFriendlyURLPrivateGroup();
        String friendlyURLPrivateUserPath = PortalUtil.getPathFriendlyURLPrivateUser();
        String friendlyURLPublicPath = PortalUtil.getPathFriendlyURLPublic();
        String imagePath = dynamicResourcesCDNHost.concat(PortalUtil.getPathImage());
        String mainPath = PortalUtil.getPathMain();
        String i18nPath = (String)request.getAttribute("I18N_PATH");
        if (Validator.isNotNull((String)i18nPath)) {
            if (Validator.isNotNull((String)contextPath)) {
                String i18nContextPath = contextPath.concat(i18nPath);
                friendlyURLPrivateGroupPath = StringUtil.replaceFirst((String)friendlyURLPrivateGroupPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPrivateUserPath = StringUtil.replaceFirst((String)friendlyURLPrivateUserPath, (String)contextPath, (String)i18nContextPath);
                friendlyURLPublicPath = StringUtil.replaceFirst((String)friendlyURLPublicPath, (String)contextPath, (String)i18nContextPath);
                mainPath = StringUtil.replaceFirst((String)mainPath, (String)contextPath, (String)i18nContextPath);
            } else {
                friendlyURLPrivateGroupPath = i18nPath.concat(friendlyURLPrivateGroupPath);
                friendlyURLPrivateUserPath = i18nPath.concat(friendlyURLPrivateUserPath);
                friendlyURLPublicPath = i18nPath.concat(friendlyURLPublicPath);
                mainPath = i18nPath.concat(mainPath);
            }
        }
        StringBundler sb = new StringBundler(5);
        sb.append(imagePath);
        sb.append("/company_logo?img_id=");
        sb.append(company.getLogoId());
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken((long)company.getLogoId()));
        String companyLogo = sb.toString();
        int companyLogoHeight = 0;
        int companyLogoWidth = 0;
        Image companyLogoImage = null;
        companyLogoImage = company.getLogoId() > 0L ? ImageLocalServiceUtil.getCompanyLogo((long)company.getLogoId()) : ImageToolUtil.getDefaultCompanyLogo();
        if (companyLogoImage != null) {
            companyLogoHeight = companyLogoImage.getHeight();
            companyLogoWidth = companyLogoImage.getWidth();
        }
        String realCompanyLogo = companyLogo;
        int realCompanyLogoHeight = companyLogoHeight;
        int realCompanyLogoWidth = companyLogoWidth;
        User user = null;
        try {
            user = PortalUtil.initUser((HttpServletRequest)request);
        }
        catch (NoSuchUserException nsue) {
            return null;
        }
        boolean bl = signedIn = !user.isDefaultUser();
        if (PropsValues.BROWSER_CACHE_DISABLED || PropsValues.BROWSER_CACHE_SIGNED_IN_DISABLED && signedIn) {
            response.setDateHeader("Expires", 0L);
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
        }
        User realUser = user;
        Long realUserId = (Long)session.getAttribute("USER_ID");
        if (realUserId != null && user.getUserId() != realUserId.longValue()) {
            realUser = UserLocalServiceUtil.getUserById((long)realUserId);
        }
        String doAsUserId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId");
        long doAsGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"doAsGroupId");
        long refererGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"refererGroupId");
        long refererPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"refererPlid");
        if (LayoutLocalServiceUtil.fetchLayout((long)refererPlid) == null) {
            refererPlid = 0L;
        }
        String controlPanelCategory = ParamUtil.getString((HttpServletRequest)request, (String)"controlPanelCategory");
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        try {
            CookieKeys.validateSupportCookie((HttpServletRequest)request);
        }
        catch (Exception e) {
            CookieKeys.addSupportCookie((HttpServletRequest)request, (HttpServletResponse)response);
        }
        TimeZone timeZone = user.getTimeZone();
        if (timeZone == null) {
            timeZone = company.getTimeZone();
        }
        if (signedIn) {
            this.updateUserLayouts(user);
        }
        Object layout = null;
        List layouts = null;
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        boolean viewableSourceGroup = true;
        if (plid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        } else {
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
            long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
            if (groupId > 0L && layoutId > 0L) {
                layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            }
        }
        if (layout != null && (sourceGroupId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_v_l_s_g_id")) > 0L && sourceGroupId != layout.getGroupId()) {
            Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
            if (layout.isPublicLayout() || SitesUtil.isUserGroupLayoutSetViewable((PermissionChecker)permissionChecker, (Group)layout.getGroup())) {
                layout = new VirtualLayout((Layout)layout, sourceGroup);
            } else {
                viewableSourceGroup = false;
            }
        }
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        Boolean redirectToDefaultLayout = (Boolean)request.getAttribute("REDIRECT_TO_DEFAULT_LAYOUT");
        if (redirectToDefaultLayout == null) {
            redirectToDefaultLayout = Boolean.FALSE;
        }
        if (layout != null) {
            boolean viewableStaging;
            Group group = layout.getGroup();
            if (!signedIn && PropsValues.AUTH_FORWARD_BY_REDIRECT) {
                request.setAttribute("REQUESTED_LAYOUT", layout);
            }
            if ((Validator.isNull((String)controlPanelCategory) || controlPanelCategory.equals("my") || controlPanelCategory.equals("portlet")) && Validator.isNotNull((String)ppid) && (LiferayWindowState.isPopUp((HttpServletRequest)request) || LiferayWindowState.isExclusive((HttpServletRequest)request))) {
                controlPanelCategory = "portlet";
            } else if (Validator.isNotNull((String)ppid)) {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)ppid);
                String portletControlPanelEntryCategory = portlet.getControlPanelEntryCategory();
                if (!controlPanelCategory.startsWith("current_site") && portletControlPanelEntryCategory.startsWith("site_administration.")) {
                    portletControlPanelEntryCategory = "sites";
                }
                if (!controlPanelCategory.startsWith("current_site") && Validator.isNotNull((String)portletControlPanelEntryCategory)) {
                    controlPanelCategory = portletControlPanelEntryCategory;
                }
            }
            boolean viewableGroup = this.hasAccessPermission(permissionChecker, (Layout)layout, doAsGroupId, controlPanelCategory, true);
            boolean bl2 = viewableStaging = !group.isControlPanel() && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_STAGING");
            if (viewableStaging) {
                layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
            } else if (!(viewableGroup && viewableSourceGroup || !group.isStagingGroup())) {
                layout = null;
            } else {
                if (!(this.isLoginRequest(request) || viewableGroup && viewableSourceGroup && (redirectToDefaultLayout.booleanValue() || this.hasAccessPermission(permissionChecker, (Layout)layout, doAsGroupId, controlPanelCategory, false)))) {
                    if (user.isDefaultUser() && PropsValues.AUTH_LOGIN_PROMPT_ENABLED) {
                        throw new PrincipalException("User is not authenticated");
                    }
                    sb = new StringBundler(6);
                    sb.append("User ");
                    sb.append(user.getUserId());
                    sb.append(" is not allowed to access the ");
                    sb.append(layout.isPrivateLayout() ? "private" : "public");
                    sb.append(" pages of group ");
                    sb.append(layout.getGroupId());
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)sb.toString());
                    }
                    throw new NoSuchLayoutException(sb.toString());
                }
                if (this.isLoginRequest(request) && !viewableGroup) {
                    layout = null;
                } else if (group.isLayoutPrototype()) {
                    layouts = new ArrayList<Layout>();
                } else {
                    layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
                    if (!group.isControlPanel()) {
                        doAsGroupId = 0L;
                    }
                }
            }
        }
        List unfilteredLayouts = layouts;
        if (layout == null) {
            Object[] defaultLayout = this.getDefaultLayout(request, user, signedIn);
            layout = (Layout)defaultLayout[0];
            layouts = (List)defaultLayout[1];
            request.setAttribute("LAYOUT_DEFAULT", (Object)Boolean.TRUE);
        }
        Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, (Layout)layout, layouts, doAsGroupId, controlPanelCategory);
        String layoutSetLogo = null;
        layout = (Layout)viewableLayouts[0];
        layouts = (List)viewableLayouts[1];
        Group group = null;
        if (layout != null && !(group = layout.getGroup()).isControlPanel()) {
            this.rememberVisitedGroupIds(request, group.getGroupId());
        }
        LayoutTypePortlet layoutTypePortlet = null;
        layouts = this.mergeAdditionalLayouts(request, user, permissionChecker, (Layout)layout, layouts, doAsGroupId, controlPanelCategory);
        LayoutSet layoutSet = null;
        boolean hasCustomizeLayoutPermission = false;
        boolean hasDeleteLayoutPermission = false;
        boolean hasUpdateLayoutPermission = false;
        boolean customizedView = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"customized_view", (boolean)true);
        if (layout != null) {
            String typeSettings;
            LayoutClone layoutClone;
            if (!layout.isTypeControlPanel()) {
                hasCustomizeLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE");
                hasDeleteLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"DELETE");
                hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            }
            layoutSet = layout.getLayoutSet();
            if (company.isSiteLogo()) {
                long logoId = 0L;
                if (layoutSet.isLogo()) {
                    logoId = layoutSet.getLogoId();
                    if (logoId == 0L) {
                        logoId = layoutSet.getLiveLogoId();
                    }
                } else {
                    LayoutSet siblingLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)layout.getGroupId(), (!layout.isPrivateLayout() ? 1 : 0) != 0);
                    if (siblingLayoutSet.isLogo()) {
                        logoId = siblingLayoutSet.getLogoId();
                    }
                }
                if (logoId > 0L) {
                    sb = new StringBundler(5);
                    sb.append(imagePath);
                    sb.append("/layout_set_logo?img_id=");
                    sb.append(logoId);
                    sb.append("&t=");
                    sb.append(WebServerServletTokenUtil.getToken((long)logoId));
                    layoutSetLogo = sb.toString();
                    Image layoutSetLogoImage = ImageLocalServiceUtil.getCompanyLogo((long)logoId);
                    companyLogo = layoutSetLogo;
                    companyLogoHeight = layoutSetLogoImage.getHeight();
                    companyLogoWidth = layoutSetLogoImage.getWidth();
                }
            }
            plid = layout.getPlid();
            layoutTypePortlet = (LayoutTypePortlet)(layout = (Layout)layout.clone()).getLayoutType();
            boolean customizable = layoutTypePortlet.isCustomizable();
            if (!customizable || group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isStagingGroup()) {
                customizedView = false;
            }
            layoutTypePortlet.setCustomizedView(customizedView);
            layoutTypePortlet.setUpdatePermission(hasUpdateLayoutPermission);
            if (signedIn && customizable && customizedView && hasCustomizeLayoutPermission) {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((long)user.getUserId(), (boolean)true);
                layoutTypePortlet.setPortalPreferences(portalPreferences);
            }
            if ((layoutClone = LayoutCloneFactory.getInstance()) != null && (typeSettings = layoutClone.get(request, plid)) != null) {
                UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
                typeSettingsProperties.load(typeSettings);
                String stateMax = typeSettingsProperties.getProperty("state-max");
                String stateMin = typeSettingsProperties.getProperty("state-min");
                String modeAbout = typeSettingsProperties.getProperty("mode-about");
                String modeConfig = typeSettingsProperties.getProperty("mode-config");
                String modeEdit = typeSettingsProperties.getProperty("mode-edit");
                String modeEditDefaults = typeSettingsProperties.getProperty("mode-edit-defaults");
                String modeEditGuest = typeSettingsProperties.getProperty("mode-edit-guest");
                String modeHelp = typeSettingsProperties.getProperty("mode-help");
                String modePreview = typeSettingsProperties.getProperty("mode-preview");
                String modePrint = typeSettingsProperties.getProperty("mode-print");
                layoutTypePortlet.setStateMax(stateMax);
                layoutTypePortlet.setStateMin(stateMin);
                layoutTypePortlet.setModeAbout(modeAbout);
                layoutTypePortlet.setModeConfig(modeConfig);
                layoutTypePortlet.setModeEdit(modeEdit);
                layoutTypePortlet.setModeEditDefaults(modeEditDefaults);
                layoutTypePortlet.setModeEditGuest(modeEditGuest);
                layoutTypePortlet.setModeHelp(modeHelp);
                layoutTypePortlet.setModePreview(modePreview);
                layoutTypePortlet.setModePrint(modePrint);
            }
            request.setAttribute("LAYOUT", layout);
            request.setAttribute("LAYOUTS", (Object)layouts);
        }
        String i18nLanguageId = (String)request.getAttribute("I18N_LANGUAGE_ID");
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request);
        if (scopeGroupId <= 0L && doAsGroupId > 0L) {
            scopeGroupId = doAsGroupId;
        }
        long siteGroupId = 0L;
        if (layout != null) {
            siteGroupId = layout.isTypeControlPanel() ? PortalUtil.getSiteGroupId((long)scopeGroupId) : PortalUtil.getSiteGroupId((long)layout.getGroupId());
        }
        Theme theme = null;
        ColorScheme colorScheme = null;
        boolean wapTheme = BrowserSnifferUtil.isWap((HttpServletRequest)request);
        if (layout != null && group.isControlPanel()) {
            String themeId = PrefsPropsUtil.getString(companyId, "control.panel.layout.regular.theme.id");
            String colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
            theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)wapTheme);
            colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)wapTheme);
            if (!wapTheme && theme.isWapTheme()) {
                theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)PropsValues.CONTROL_PANEL_LAYOUT_REGULAR_THEME_ID, (boolean)false);
                colorScheme = ThemeLocalServiceUtil.getColorScheme((long)companyId, (String)theme.getThemeId(), (String)colorSchemeId, (boolean)false);
            }
            request.setAttribute("THEME", (Object)theme);
            request.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        }
        boolean themeCssFastLoad = PropsValues.THEME_CSS_FAST_LOAD;
        if (PropsValues.THEME_CSS_FAST_LOAD_CHECK_REQUEST_PARAMETER) {
            themeCssFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"css_fast_load", (boolean)PropsValues.THEME_CSS_FAST_LOAD);
        }
        boolean themeImagesFastLoad = PropsValues.THEME_IMAGES_FAST_LOAD;
        if (PropsValues.THEME_IMAGES_FAST_LOAD_CHECK_REQUEST_PARAMETER) {
            SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"images_fast_load", (boolean)PropsValues.THEME_IMAGES_FAST_LOAD);
        }
        if ((themeJsBarebone = PropsValues.JAVASCRIPT_BAREBONE_ENABLED) && signedIn) {
            themeJsBarebone = false;
        }
        boolean themeJsFastLoad = SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"js_fast_load", (boolean)PropsValues.JAVASCRIPT_FAST_LOAD);
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle", (String)"0");
        lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_t_lifecycle", (String)lifecycle);
        boolean isolated = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_isolated");
        String facebookCanvasPageURL = (String)request.getAttribute("FACEBOOK_CANVAS_PAGE_URL");
        boolean widget = false;
        Boolean widgetObj = (Boolean)request.getAttribute("WIDGET");
        if (widgetObj != null) {
            widget = widgetObj;
        }
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        themeDisplay.setRequest(request);
        themeDisplay.setCDNHost(cdnHost);
        themeDisplay.setCDNDynamicResourcesHost(dynamicResourcesCDNHost);
        themeDisplay.setFacebookCanvasPageURL(facebookCanvasPageURL);
        themeDisplay.setPortalURL(portalURL);
        themeDisplay.setRefererPlid(refererPlid);
        themeDisplay.setSecure(request.isSecure());
        themeDisplay.setServerName(request.getServerName());
        themeDisplay.setServerPort(request.getServerPort());
        themeDisplay.setWidget(widget);
        themeDisplay.setCompany(company);
        themeDisplay.setCompanyLogo(companyLogo);
        themeDisplay.setCompanyLogoHeight(companyLogoHeight);
        themeDisplay.setCompanyLogoWidth(companyLogoWidth);
        themeDisplay.setControlPanelCategory(controlPanelCategory);
        themeDisplay.setDoAsGroupId(doAsGroupId);
        themeDisplay.setDoAsUserId(doAsUserId);
        themeDisplay.setDoAsUserLanguageId(doAsUserLanguageId);
        themeDisplay.setI18nLanguageId(i18nLanguageId);
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setIsolated(isolated);
        themeDisplay.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        themeDisplay.setLayout(layout);
        themeDisplay.setLayouts(layouts);
        themeDisplay.setLayoutSet(layoutSet);
        themeDisplay.setLayoutSetLogo(layoutSetLogo);
        themeDisplay.setLayoutTypePortlet(layoutTypePortlet);
        themeDisplay.setLifecycle(lifecycle);
        themeDisplay.setLifecycleAction(lifecycle.equals("1"));
        themeDisplay.setLifecycleEvent(lifecycle.equals("3"));
        themeDisplay.setLifecycleRender(lifecycle.equals("0"));
        themeDisplay.setLifecycleResource(lifecycle.equals("2"));
        themeDisplay.setLocale(locale);
        themeDisplay.setLookAndFeel(theme, colorScheme);
        themeDisplay.setPathApplet(contextPath.concat("/applets"));
        themeDisplay.setPathCms(contextPath.concat("/cms"));
        themeDisplay.setPathContext(contextPath);
        themeDisplay.setPathFlash(contextPath.concat("/flash"));
        themeDisplay.setPathFriendlyURLPrivateGroup(friendlyURLPrivateGroupPath);
        themeDisplay.setPathFriendlyURLPrivateUser(friendlyURLPrivateUserPath);
        themeDisplay.setPathFriendlyURLPublic(friendlyURLPublicPath);
        themeDisplay.setPathImage(imagePath);
        themeDisplay.setPathJavaScript(contextPath.concat("/html/js"));
        themeDisplay.setPathMain(mainPath);
        themeDisplay.setPathSound(contextPath.concat("/html/sound"));
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setPlid(plid);
        themeDisplay.setPpid(ppid);
        themeDisplay.setRealCompanyLogo(realCompanyLogo);
        themeDisplay.setRealCompanyLogoHeight(realCompanyLogoHeight);
        themeDisplay.setRealCompanyLogoWidth(realCompanyLogoWidth);
        themeDisplay.setRealUser(realUser);
        themeDisplay.setRefererGroupId(refererGroupId);
        themeDisplay.setScopeGroupId(scopeGroupId);
        themeDisplay.setSignedIn(signedIn);
        themeDisplay.setSiteDefaultLocale(PortalUtil.getSiteDefaultLocale((long)siteGroupId));
        themeDisplay.setSiteGroupId(siteGroupId);
        themeDisplay.setStateExclusive(LiferayWindowState.isExclusive((HttpServletRequest)request));
        themeDisplay.setStateMaximized(LiferayWindowState.isMaximized((HttpServletRequest)request));
        themeDisplay.setStatePopUp(LiferayWindowState.isPopUp((HttpServletRequest)request));
        themeDisplay.setThemeCssFastLoad(themeCssFastLoad);
        themeDisplay.setThemeImagesFastLoad(themeImagesFastLoad);
        themeDisplay.setThemeJsBarebone(themeJsBarebone);
        themeDisplay.setThemeJsFastLoad(themeJsFastLoad);
        themeDisplay.setTimeZone(timeZone);
        themeDisplay.setUnfilteredLayouts(unfilteredLayouts);
        themeDisplay.setUser(user);
        themeDisplay.setShowAddContentIcon(false);
        boolean showControlPanelIcon = false;
        if (signedIn && PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW_CONTROL_PANEL")) {
            showControlPanelIcon = true;
        }
        themeDisplay.setShowControlPanelIcon(showControlPanelIcon);
        themeDisplay.setShowHomeIcon(true);
        themeDisplay.setShowMyAccountIcon(signedIn);
        themeDisplay.setShowPageSettingsIcon(hasDeleteLayoutPermission);
        themeDisplay.setShowPortalIcon(true);
        themeDisplay.setShowSignInIcon(!signedIn);
        boolean showSignOutIcon = signedIn;
        if (themeDisplay.isImpersonated()) {
            showSignOutIcon = false;
        }
        themeDisplay.setShowSignOutIcon(showSignOutIcon);
        themeDisplay.setShowStagingIcon(false);
        boolean showSiteAdministrationIcon = false;
        if (signedIn && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_SITE_ADMINISTRATION")) {
            showSiteAdministrationIcon = true;
        }
        themeDisplay.setShowSiteAdministrationIcon(showSiteAdministrationIcon);
        if (PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID && !CookieKeys.hasSessionId((HttpServletRequest)request)) {
            themeDisplay.setAddSessionIdToURL(true);
            themeDisplay.setSessionId(session.getId());
        }
        String urlControlPanel = friendlyURLPrivateGroupPath.concat("/control_panel");
        if (Validator.isNotNull((String)doAsUserId)) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"doAsUserId", (String)doAsUserId);
        }
        if (refererGroupId > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererGroupId", (long)refererGroupId);
        } else if (scopeGroupId > 0L && (refererLayout = LayoutLocalServiceUtil.fetchLayout((long)plid)) != null && (refererLayoutGroup = refererLayout.getGroup()).isUserGroup()) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererGroupId", (long)scopeGroupId);
        }
        if (refererPlid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)refererPlid);
        } else if (plid > 0L) {
            urlControlPanel = HttpUtil.addParameter((String)urlControlPanel, (String)"refererPlid", (long)plid);
        }
        if (themeDisplay.isAddSessionIdToURL()) {
            urlControlPanel = PortalUtil.getURLWithSessionId((String)urlControlPanel, (String)session.getId());
        }
        themeDisplay.setURLControlPanel(urlControlPanel);
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        themeDisplay.setURLCurrent(currentURL);
        String urlHome = PortalUtil.getHomeURL((HttpServletRequest)request);
        themeDisplay.setURLHome(urlHome);
        String siteAdministrationURL = urlControlPanel;
        siteAdministrationURL = HttpUtil.addParameter((String)siteAdministrationURL, (String)"controlPanelCategory", (String)"current_site");
        siteAdministrationURL = HttpUtil.addParameter((String)siteAdministrationURL, (String)"doAsGroupId", (long)siteGroupId);
        themeDisplay.setURLSiteAdministration(siteAdministrationURL);
        long controlPanelPlid = PortalUtil.getControlPanelPlid((long)companyId);
        if (layout != null) {
            Portlet myAccountPortlet;
            if (layout.isTypePortlet()) {
                boolean freeformLayout = layoutTypePortlet.getLayoutTemplateId().equals("freeform");
                themeDisplay.setFreeformLayout(freeformLayout);
                if (hasUpdateLayoutPermission) {
                    themeDisplay.setShowAddContentIconPermission(true);
                    if (!LiferayWindowState.isMaximized((HttpServletRequest)request)) {
                        themeDisplay.setShowAddContentIcon(true);
                    }
                    themeDisplay.setShowLayoutTemplatesIcon(true);
                    if (!group.isUser()) {
                        themeDisplay.setShowPageCustomizationIcon(true);
                    }
                    themeDisplay.setURLAddContent("Liferay.Dockbar.loadAddPanel();");
                }
                if (hasCustomizeLayoutPermission && customizedView) {
                    themeDisplay.setShowAddContentIconPermission(true);
                    if (!LiferayWindowState.isMaximized((HttpServletRequest)request)) {
                        themeDisplay.setShowAddContentIcon(true);
                    }
                    themeDisplay.setURLAddContent("Liferay.Dockbar.loadAddPanel();");
                }
            }
            if (hasUpdateLayoutPermission) {
                themeDisplay.setShowPageSettingsIcon(true);
                PortletURLImpl pageSettingsURL = new PortletURLImpl(request, "156", controlPanelPlid, "RENDER_PHASE");
                pageSettingsURL.setDoAsGroupId(scopeGroupId);
                pageSettingsURL.setParameter("struts_action", "/group_pages/edit_layouts");
                if (layout.isPrivateLayout()) {
                    pageSettingsURL.setParameter("tabs1", "private-pages");
                } else {
                    pageSettingsURL.setParameter("tabs1", "public-pages");
                }
                pageSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                pageSettingsURL.setParameter("selPlid", String.valueOf(plid));
                pageSettingsURL.setPortletMode(PortletMode.VIEW);
                if (PropsValues.DOCKBAR_ADMINISTRATIVE_LINKS_SHOW_IN_POP_UP) {
                    pageSettingsURL.setControlPanelCategory("portlet");
                    pageSettingsURL.setParameter("closeRedirect", currentURL);
                    pageSettingsURL.setWindowState(LiferayWindowState.POP_UP);
                } else {
                    pageSettingsURL.setParameter("redirect", themeDisplay.getURLHome());
                    pageSettingsURL.setPlid(plid);
                    pageSettingsURL.setWindowState(WindowState.MAXIMIZED);
                }
                themeDisplay.setURLPageSettings((PortletURL)pageSettingsURL);
                boolean site = group.isSite();
                if (!site && group.isStagingGroup()) {
                    Group liveGroup = group.getLiveGroup();
                    site = liveGroup.isSite();
                }
                if (site && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"ASSIGN_MEMBERS")) {
                    themeDisplay.setShowManageSiteMembershipsIcon(true);
                    PortletURLImpl manageSiteMembershipsURL = new PortletURLImpl(request, "174", controlPanelPlid, "RENDER_PHASE");
                    manageSiteMembershipsURL.setDoAsGroupId(scopeGroupId);
                    manageSiteMembershipsURL.setParameter("struts_action", "/sites_admin/edit_site_assignments");
                    manageSiteMembershipsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    manageSiteMembershipsURL.setParameter("selPlid", String.valueOf(plid));
                    manageSiteMembershipsURL.setPortletMode(PortletMode.VIEW);
                    if (PropsValues.DOCKBAR_ADMINISTRATIVE_LINKS_SHOW_IN_POP_UP) {
                        manageSiteMembershipsURL.setControlPanelCategory("portlet");
                        manageSiteMembershipsURL.setWindowState(LiferayWindowState.POP_UP);
                    } else {
                        manageSiteMembershipsURL.setParameter("redirect", themeDisplay.getURLHome());
                        manageSiteMembershipsURL.setParameter("showBackURL", Boolean.FALSE.toString());
                        manageSiteMembershipsURL.setPlid(plid);
                        manageSiteMembershipsURL.setWindowState(WindowState.MAXIMIZED);
                    }
                    themeDisplay.setURLManageSiteMemberships((PortletURL)manageSiteMembershipsURL);
                } else {
                    themeDisplay.setShowManageSiteMembershipsIcon(false);
                }
            }
            Group scopeGroup = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
            boolean hasAddLayoutGroupPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"ADD_LAYOUT");
            boolean hasAddLayoutLayoutPermission = !layout.isTypeControlPanel() && LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"ADD_LAYOUT");
            boolean hasManageLayoutsGroupPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"MANAGE_LAYOUTS");
            boolean hasManageStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"MANAGE_STAGING");
            boolean hasPublishStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"PUBLISH_STAGING");
            boolean hasUpdateGroupPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"UPDATE");
            boolean hasViewStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)scopeGroup, (String)"VIEW_STAGING");
            if (!group.isControlPanel() && !group.isUser() && !group.isUserGroup() && hasUpdateGroupPermission) {
                themeDisplay.setShowSiteSettingsIcon(true);
                PortletURLImpl siteSettingsURL = new PortletURLImpl(request, "165", controlPanelPlid, "RENDER_PHASE");
                siteSettingsURL.setDoAsGroupId(scopeGroupId);
                siteSettingsURL.setParameter("struts_action", "/sites_admin/edit_site");
                siteSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                siteSettingsURL.setParameter("showBackURL", Boolean.FALSE.toString());
                siteSettingsURL.setPortletMode(PortletMode.VIEW);
                if (PropsValues.DOCKBAR_ADMINISTRATIVE_LINKS_SHOW_IN_POP_UP) {
                    siteSettingsURL.setControlPanelCategory("portlet");
                    siteSettingsURL.setParameter("closeRedirect", currentURL);
                    siteSettingsURL.setWindowState(LiferayWindowState.POP_UP);
                } else {
                    siteSettingsURL.setParameter("redirect", themeDisplay.getURLHome());
                    siteSettingsURL.setPlid(plid);
                    siteSettingsURL.setWindowState(LiferayWindowState.MAXIMIZED);
                }
                themeDisplay.setURLSiteSettings((PortletURL)siteSettingsURL);
            }
            if (!group.isLayoutPrototype() && (hasAddLayoutGroupPermission || hasAddLayoutLayoutPermission || hasManageLayoutsGroupPermission || hasUpdateGroupPermission)) {
                themeDisplay.setShowSiteMapSettingsIcon(true);
                PortletURLImpl siteMapSettingsURL = new PortletURLImpl(request, "156", controlPanelPlid, "RENDER_PHASE");
                siteMapSettingsURL.setDoAsGroupId(scopeGroupId);
                siteMapSettingsURL.setParameter("struts_action", "/group_pages/edit_layouts");
                if (layout.isPrivateLayout()) {
                    siteMapSettingsURL.setParameter("tabs1", "private-pages");
                } else {
                    siteMapSettingsURL.setParameter("tabs1", "public-pages");
                }
                siteMapSettingsURL.setParameter("groupId", String.valueOf(scopeGroupId));
                siteMapSettingsURL.setPortletMode(PortletMode.VIEW);
                if (PropsValues.DOCKBAR_ADMINISTRATIVE_LINKS_SHOW_IN_POP_UP) {
                    siteMapSettingsURL.setControlPanelCategory("portlet");
                    siteMapSettingsURL.setParameter("closeRedirect", currentURL);
                    siteMapSettingsURL.setWindowState(LiferayWindowState.POP_UP);
                } else {
                    siteMapSettingsURL.setParameter("redirect", themeDisplay.getURLHome());
                    siteMapSettingsURL.setPlid(plid);
                    siteMapSettingsURL.setWindowState(LiferayWindowState.MAXIMIZED);
                }
                themeDisplay.setURLSiteMapSettings((PortletURL)siteMapSettingsURL);
            }
            if (group.hasStagingGroup() && !group.isStagingGroup()) {
                themeDisplay.setShowAddContentIcon(false);
                themeDisplay.setShowLayoutTemplatesIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isControlPanel()) {
                themeDisplay.setShowPageSettingsIcon(false);
                themeDisplay.setURLPublishToLive(null);
            }
            if (group.isStaged() || group.isStagingGroup()) {
                if (hasManageStagingPermission || hasPublishStagingPermission || hasUpdateLayoutPermission || hasViewStagingPermission) {
                    themeDisplay.setShowStagingIcon(true);
                }
                if (hasPublishStagingPermission) {
                    PortletURLImpl publishToLiveURL = new PortletURLImpl(request, "88", plid, "RENDER_PHASE");
                    publishToLiveURL.setParameter("struts_action", "/layouts_admin/publish_layouts");
                    if (layout.isPrivateLayout()) {
                        publishToLiveURL.setParameter("tabs1", "private-pages");
                    } else {
                        publishToLiveURL.setParameter("tabs1", "public-pages");
                    }
                    publishToLiveURL.setParameter("pagesRedirect", currentURL);
                    publishToLiveURL.setParameter("groupId", String.valueOf(scopeGroupId));
                    publishToLiveURL.setParameter("selPlid", String.valueOf(plid));
                    publishToLiveURL.setPortletMode(PortletMode.VIEW);
                    publishToLiveURL.setWindowState(LiferayWindowState.EXCLUSIVE);
                    themeDisplay.setURLPublishToLive((PortletURL)publishToLiveURL);
                }
            }
            if ((myAccountPortlet = PortalUtil.getFirstMyAccountPortlet((ThemeDisplay)themeDisplay)) != null) {
                PortletURLImpl myAccountURL = new PortletURLImpl(request, myAccountPortlet.getPortletId(), controlPanelPlid, "RENDER_PHASE");
                if (scopeGroupId > 0L) {
                    myAccountURL.setDoAsGroupId(scopeGroupId);
                }
                if (refererPlid > 0L) {
                    myAccountURL.setRefererPlid(refererPlid);
                } else {
                    myAccountURL.setRefererPlid(plid);
                }
                myAccountURL.setWindowState(WindowState.MAXIMIZED);
                themeDisplay.setURLMyAccount((PortletURL)myAccountURL);
            }
        }
        if (!user.isActive() || PrefsPropsUtil.getBoolean(companyId, "terms.of.use.required") && !user.isAgreedToTermsOfUse()) {
            themeDisplay.setShowAddContentIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageSettingsIcon(false);
        }
        if (layout != null && layout.isLayoutPrototypeLinkActive()) {
            themeDisplay.setShowPageCustomizationIcon(false);
        }
        if (group.isLayoutPrototype()) {
            themeDisplay.setShowHomeIcon(false);
            themeDisplay.setShowManageSiteMembershipsIcon(false);
            themeDisplay.setShowMyAccountIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowPageSettingsIcon(true);
            themeDisplay.setShowPortalIcon(false);
            themeDisplay.setShowSignInIcon(false);
            themeDisplay.setShowSignOutIcon(false);
            themeDisplay.setShowSiteAdministrationIcon(false);
            themeDisplay.setShowSiteSettingsIcon(false);
            themeDisplay.setShowStagingIcon(false);
        }
        if (group.isLayoutSetPrototype()) {
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowSiteSettingsIcon(false);
        }
        if (group.hasStagingGroup() && !group.isStagingGroup()) {
            themeDisplay.setShowLayoutTemplatesIcon(false);
            themeDisplay.setShowPageCustomizationIcon(false);
            themeDisplay.setShowSiteMapSettingsIcon(false);
            themeDisplay.setShowSiteSettingsIcon(false);
        }
        themeDisplay.setURLPortal(portalURL.concat(contextPath));
        boolean secure = false;
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || request.isSecure()) {
            secure = true;
        }
        String securePortalURL = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)secure);
        String urlSignIn = securePortalURL.concat(mainPath).concat(_PATH_PORTAL_LOGIN);
        if (layout != null) {
            urlSignIn = HttpUtil.addParameter((String)urlSignIn, (String)"p_l_id", (long)layout.getPlid());
        }
        themeDisplay.setURLSignIn(urlSignIn);
        themeDisplay.setURLSignOut(mainPath.concat(_PATH_PORTAL_LOGOUT));
        PortletURLImpl updateManagerURL = new PortletURLImpl(request, "1_WAR_marketplaceportlet", controlPanelPlid, "RENDER_PHASE");
        themeDisplay.setURLUpdateManager((PortletURL)updateManagerURL);
        return themeDisplay;
    }

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.servicePre(request, response);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Running takes " + stopWatch.getTime() + " ms"));
        }
    }

    protected void addDefaultLayoutsByLAR(long userId, long groupId, boolean privateLayout, File larFile) throws PortalException {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_ARCHIVED_SETUPS_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        LayoutLocalServiceUtil.importLayouts((long)userId, (long)groupId, (boolean)privateLayout, parameterMap, (File)larFile);
    }

    protected void addDefaultUserPrivateLayoutByProperties(long userId, long groupId) throws PortalException {
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)true, (long)0L, (String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.user.private.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_USER_PRIVATE_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    protected void addDefaultUserPrivateLayouts(User user) throws PortalException {
        Group userGroup = user.getGroup();
        if (this.privateLARFile != null) {
            this.addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), true, this.privateLARFile);
        } else {
            this.addDefaultUserPrivateLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    protected void addDefaultUserPublicLayoutByProperties(long userId, long groupId) throws PortalException {
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = LayoutLocalServiceUtil.addLayout((long)userId, (long)groupId, (boolean)false, (long)0L, (String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_NAME, (String)"", (String)"", (String)"portlet", (boolean)false, (String)friendlyURL, (ServiceContext)serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.user.public.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
        }
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_USER_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
    }

    protected void addDefaultUserPublicLayouts(User user) throws PortalException {
        Group userGroup = user.getGroup();
        if (this.publicLARFile != null) {
            this.addDefaultLayoutsByLAR(user.getUserId(), userGroup.getGroupId(), false, this.publicLARFile);
        } else {
            this.addDefaultUserPublicLayoutByProperties(user.getUserId(), userGroup.getGroupId());
        }
    }

    protected void deleteDefaultUserPrivateLayouts(User user) throws PortalException {
        Group userGroup = user.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)true, (ServiceContext)serviceContext);
    }

    protected void deleteDefaultUserPublicLayouts(User user) throws PortalException {
        Group userGroup = user.getGroup();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts((long)userGroup.getGroupId(), (boolean)false, (ServiceContext)serviceContext);
    }

    protected Object[] getDefaultLayout(HttpServletRequest request, User user, boolean signedIn) throws PortalException {
        Group guestGroup;
        Object layout = null;
        List layouts = null;
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null) {
            layouts = LayoutLocalServiceUtil.getLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)0L);
            Group group = null;
            if (!layouts.isEmpty()) {
                layout = (Layout)layouts.get(0);
                group = layout.getGroup();
            }
            if (layout != null && layout.isPrivateLayout()) {
                layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                if (!layouts.isEmpty()) {
                    layout = (Layout)layouts.get(0);
                } else {
                    group = null;
                    layout = null;
                }
            }
            if (group != null && group.isStagingGroup()) {
                Group liveGroup = group.getLiveGroup();
                layouts = LayoutLocalServiceUtil.getLayouts((long)liveGroup.getGroupId(), (boolean)false, (long)0L);
                layout = !layouts.isEmpty() ? (Layout)layouts.get(0) : null;
            }
        }
        if (layout == null && signedIn) {
            Group userGroup = user.getGroup();
            layouts = LayoutLocalServiceUtil.getLayouts((long)userGroup.getGroupId(), (boolean)true, (long)0L);
            if (layouts.isEmpty()) {
                layouts = LayoutLocalServiceUtil.getLayouts((long)userGroup.getGroupId(), (boolean)false, (long)0L);
            }
            if (!layouts.isEmpty()) {
                layout = (Layout)layouts.get(0);
            }
            if (layout == null) {
                LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
                groupParams.put("usersGroups", new Long(user.getUserId()));
                List groups = GroupLocalServiceUtil.search((long)user.getCompanyId(), null, null, groupParams, (int)-1, (int)-1);
                for (Group group : groups) {
                    layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)true, (long)0L);
                    if (layouts.isEmpty()) {
                        layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)false, (long)0L);
                    }
                    if (layouts.isEmpty()) continue;
                    layout = (Layout)layouts.get(0);
                    break;
                }
            }
        }
        if (layout == null && !(layouts = LayoutLocalServiceUtil.getLayouts((long)(guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId(), (boolean)false, (long)0L)).isEmpty()) {
            layout = (Layout)layouts.get(0);
        }
        return new Object[]{layout, layouts};
    }

    protected String getFriendlyURL(String friendlyURL) {
        friendlyURL = GetterUtil.getString((String)friendlyURL);
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    protected Object[] getViewableLayouts(HttpServletRequest request, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts, long doAsGroupId, String controlPanelCategory) throws PortalException {
        boolean hasViewStagingPermission;
        if (layouts == null || layouts.isEmpty()) {
            return new Object[]{layout, layouts};
        }
        Group group = layout.getGroup();
        boolean hasViewLayoutPermission = false;
        boolean bl = hasViewStagingPermission = (group.isStagingGroup() || group.isStagedRemotely()) && !group.isControlPanel() && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_STAGING");
        if (this.hasAccessPermission(permissionChecker, layout, doAsGroupId, controlPanelCategory, false) || hasViewStagingPermission) {
            hasViewLayoutPermission = true;
        }
        ArrayList<Layout> accessibleLayouts = new ArrayList<Layout>();
        for (int i = 0; i < layouts.size(); ++i) {
            Layout curLayout = layouts.get(i);
            if (curLayout.isHidden() || !this.hasAccessPermission(permissionChecker, curLayout, doAsGroupId, controlPanelCategory, false) && !hasViewStagingPermission) continue;
            if (accessibleLayouts.isEmpty() && !hasViewLayoutPermission) {
                layout = curLayout;
            }
            accessibleLayouts.add(curLayout);
        }
        if (accessibleLayouts.isEmpty()) {
            layouts = null;
            if (!this.isLoginRequest(request) && !hasViewLayoutPermission) {
                if (user.isDefaultUser() && PropsValues.AUTH_LOGIN_PROMPT_ENABLED) {
                    throw new PrincipalException("User is not authenticated");
                }
                SessionErrors.add((HttpServletRequest)request, (String)LayoutPermissionException.class.getName());
            }
        } else {
            layouts = accessibleLayouts;
        }
        return new Object[]{layout, layouts};
    }

    protected boolean hasAccessPermission(PermissionChecker permissionChecker, Layout layout, long doAsGroupId, String controlPanelCategory, boolean checkViewableGroup) throws PortalException {
        if (layout.isTypeControlPanel()) {
            if (!permissionChecker.isSignedIn()) {
                return false;
            }
            if (controlPanelCategory.startsWith("current_site")) {
                if (doAsGroupId <= 0L) {
                    return false;
                }
                Group group = GroupLocalServiceUtil.getGroup((long)doAsGroupId);
                if (group.isLayout()) {
                    group = group.getParentGroup();
                }
                if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_SITE_ADMINISTRATION")) {
                    return true;
                }
            } else if (controlPanelCategory.equals("my") || controlPanelCategory.equals("portlet")) {
                return true;
            }
            return PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW_CONTROL_PANEL");
        }
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (boolean)checkViewableGroup, (String)"VIEW");
    }

    protected Boolean hasPowerUserRole(User user) throws Exception {
        return RoleLocalServiceUtil.hasUserRole((long)user.getUserId(), (long)user.getCompanyId(), (String)"Power User", (boolean)true);
    }

    protected void initImportLARFiles() {
        String privateLARFileName = PropsValues.DEFAULT_USER_PRIVATE_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading private LAR file " + privateLARFileName));
        }
        if (Validator.isNotNull((String)privateLARFileName)) {
            this.privateLARFile = new File(privateLARFileName);
            if (!this.privateLARFile.exists()) {
                _log.error((Object)("Private LAR file " + this.privateLARFile + " does not exist"));
                this.privateLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using private LAR file " + privateLARFileName));
            }
        }
        String publicLARFileName = PropsValues.DEFAULT_USER_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected boolean isLoginRequest(HttpServletRequest request) {
        String mainPath;
        String requestURI = request.getRequestURI();
        return requestURI.startsWith((mainPath = PortalUtil.getPathMain()).concat(_PATH_PORTAL_LOGIN));
    }

    @Deprecated
    protected boolean isViewableCommunity(User user, long groupId, boolean privateLayout, PermissionChecker permissionChecker) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)0L, (String)"VIEW");
    }

    @Deprecated
    protected boolean isViewableGroup(User user, long groupId, boolean privateLayout, long layoutId, String controlPanelCategory, PermissionChecker permissionChecker) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"VIEW");
    }

    protected List<Layout> mergeAdditionalLayouts(HttpServletRequest request, User user, PermissionChecker permissionChecker, Layout layout, List<Layout> layouts, long doAsGroupId, String controlPanelCategory) throws PortalException {
        Group guestGroup;
        if (layout == null || layout.isPrivateLayout()) {
            return layouts;
        }
        long layoutGroupId = layout.getGroupId();
        if (layoutGroupId != (guestGroup = GroupLocalServiceUtil.getGroup((long)user.getCompanyId(), (String)"Guest")).getGroupId()) {
            Group layoutGroup = GroupLocalServiceUtil.getGroup((long)layoutGroupId);
            UnicodeProperties typeSettingsProperties = layoutGroup.getTypeSettingsProperties();
            boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("mergeGuestPublicPages"));
            if (!mergeGuestPublicPages) {
                return layouts;
            }
            List guestLayouts = LayoutLocalServiceUtil.getLayouts((long)guestGroup.getGroupId(), (boolean)false, (long)0L);
            Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, guestLayouts, doAsGroupId, controlPanelCategory);
            guestLayouts = (List)viewableLayouts[1];
            if (layouts == null) {
                return guestLayouts;
            }
            layouts.addAll(0, guestLayouts);
        } else {
            HttpSession session = request.getSession();
            Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
            if (previousGroupId != null && previousGroupId != layoutGroupId) {
                Group previousGroup = null;
                try {
                    previousGroup = GroupLocalServiceUtil.getGroup((long)previousGroupId);
                }
                catch (NoSuchGroupException nsge) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)nsge);
                    }
                    return layouts;
                }
                UnicodeProperties typeSettingsProperties = previousGroup.getTypeSettingsProperties();
                boolean mergeGuestPublicPages = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("mergeGuestPublicPages"));
                if (!mergeGuestPublicPages) {
                    return layouts;
                }
                List previousLayouts = LayoutLocalServiceUtil.getLayouts((long)previousGroupId, (boolean)false, (long)0L);
                Object[] viewableLayouts = this.getViewableLayouts(request, user, permissionChecker, layout, previousLayouts, doAsGroupId, controlPanelCategory);
                if ((previousLayouts = (List)viewableLayouts[1]) != null) {
                    layouts.addAll(previousLayouts);
                }
            }
        }
        return layouts;
    }

    protected void processControlPanelRedirects(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout == null || !layout.isTypeControlPanel()) {
            return;
        }
        String controlPanelCategory = themeDisplay.getControlPanelCategory();
        String currentURL = themeDisplay.getURLCurrent();
        String ppid = themeDisplay.getPpid();
        long scopeGroupId = themeDisplay.getScopeGroupId();
        if (Validator.isNotNull((String)ppid)) {
            boolean switchGroup = ParamUtil.getBoolean((HttpServletRequest)request, (String)"switchGroup");
            if (switchGroup && !PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)ppid)) {
                String redirect = HttpUtil.removeParameter((String)currentURL, (String)"p_p_id");
                response.sendRedirect(redirect);
            }
        } else {
            Map categoriesMap;
            if (Validator.isNull((String)controlPanelCategory) && (categoriesMap = PortalUtil.getControlPanelCategoriesMap((HttpServletRequest)request)).size() == 1) {
                for (String curCategory : categoriesMap.keySet()) {
                    List categoryPortlets = (List)categoriesMap.get(curCategory);
                    if (categoryPortlets.size() != 1) continue;
                    Portlet firstPortlet = (Portlet)categoryPortlets.get(0);
                    PortletURL redirectURL = PortalUtil.getSiteAdministrationURL((HttpServletRequest)request, (ThemeDisplay)themeDisplay, (String)firstPortlet.getPortletId());
                    response.sendRedirect(redirectURL.toString());
                }
            }
            if (controlPanelCategory.startsWith("current_site")) {
                controlPanelCategory = controlPanelCategory.indexOf(".") == -1 ? StringUtil.replace((String)controlPanelCategory, (String)"current_site", (String)"site_administration.") : StringUtil.replace((String)controlPanelCategory, (String)"current_site.", (String)"site_administration.");
            }
            if (controlPanelCategory.equals("site_administration.")) {
                Portlet firstPortlet = PortalUtil.getFirstSiteAdministrationPortlet((ThemeDisplay)themeDisplay);
                String redirect = HttpUtil.setParameter((String)currentURL, (String)"p_p_id", (String)firstPortlet.getPortletId());
                response.sendRedirect(PortalUtil.getAbsoluteURL((HttpServletRequest)request, (String)redirect));
            } else {
                List portlets = PortalUtil.getControlPanelPortlets((String)controlPanelCategory, (ThemeDisplay)themeDisplay);
                Portlet firstPortlet = null;
                for (Portlet portlet : portlets) {
                    if (!PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)scopeGroupId, (Portlet)portlet)) continue;
                    firstPortlet = portlet;
                    break;
                }
                if (firstPortlet == null && controlPanelCategory.startsWith("site_administration.")) {
                    firstPortlet = PortalUtil.getFirstSiteAdministrationPortlet((ThemeDisplay)themeDisplay);
                }
                if (firstPortlet != null) {
                    String redirect = HttpUtil.setParameter((String)currentURL, (String)"p_p_id", (String)firstPortlet.getPortletId());
                    response.sendRedirect(PortalUtil.getAbsoluteURL((HttpServletRequest)request, (String)redirect));
                }
            }
        }
    }

    protected void rememberVisitedGroupIds(HttpServletRequest request, long currentGroupId) {
        String requestURI = GetterUtil.getString((String)request.getRequestURI());
        if (!requestURI.endsWith(_PATH_PORTAL_LAYOUT)) {
            return;
        }
        HttpSession session = request.getSession();
        Long recentGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT");
        Long previousGroupId = (Long)session.getAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS");
        if (recentGroupId == null) {
            recentGroupId = new Long(currentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
        } else if (recentGroupId != currentGroupId) {
            previousGroupId = new Long(recentGroupId);
            recentGroupId = new Long(currentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_RECENT", (Object)recentGroupId);
            session.setAttribute("LIFERAY_SHARED_VISITED_GROUP_ID_PREVIOUS", (Object)previousGroupId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Current group id " + currentGroupId));
            _log.debug((Object)("Recent group id " + recentGroupId));
            _log.debug((Object)("Previous group id " + previousGroupId));
        }
    }

    protected void servicePre(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block6: {
            long mainJournalArticleId;
            String strutsAction;
            ThemeDisplay themeDisplay = this.initThemeDisplay(request, response);
            if (themeDisplay == null) {
                return;
            }
            request.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
            this.processControlPanelRedirects(request, response);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            if (PropsValues.LAYOUT_AJAX_RENDER_ENABLE) {
                boolean portletAjaxRender = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_ajax", (boolean)true);
                request.setAttribute("PORTLET_AJAX_RENDER", (Object)portletAjaxRender);
            }
            if (PropsValues.LAYOUT_PARALLEL_RENDER_ENABLE && ServerDetector.isTomcat() && !PropsValues.TCK_URL) {
                boolean portletParallelRender = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_parallel", (boolean)true);
                request.setAttribute("PORTLET_PARALLEL_RENDER", (Object)portletParallelRender);
            }
            if ((strutsAction = PortalUtil.getStrutsAction((HttpServletRequest)request)).equals(_PATH_PORTAL_LAYOUT) && (mainJournalArticleId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_j_a_id")) > 0L) {
                try {
                    JournalArticle mainJournalArticle = JournalArticleServiceUtil.getArticle((long)mainJournalArticleId);
                    AssetEntry layoutAssetEntry = AssetEntryLocalServiceUtil.getEntry((String)JournalArticle.class.getName(), (long)mainJournalArticle.getResourcePrimKey());
                    request.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)layoutAssetEntry);
                }
                catch (NoSuchArticleException nsae) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)nsae.getMessage());
                }
            }
        }
    }

    protected void updateUserLayouts(User user) throws Exception {
        Boolean hasPowerUserRole = null;
        boolean addDefaultUserPrivateLayouts = false;
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPrivateLayouts = true;
            if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this.hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPrivateLayouts = false;
                }
            }
        }
        Boolean hasPrivateLayouts = null;
        if (addDefaultUserPrivateLayouts && !(hasPrivateLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)true, (boolean)false))).booleanValue()) {
            this.addDefaultUserPrivateLayouts(user);
        }
        boolean deleteDefaultUserPrivateLayouts = false;
        if (!PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED) {
            deleteDefaultUserPrivateLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this.hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPrivateLayouts = true;
            }
        }
        if (deleteDefaultUserPrivateLayouts) {
            if (hasPrivateLayouts == null) {
                hasPrivateLayouts = LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)true, (boolean)false);
            }
            if (hasPrivateLayouts.booleanValue()) {
                this.deleteDefaultUserPrivateLayouts(user);
            }
        }
        boolean addDefaultUserPublicLayouts = false;
        if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED && PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_AUTO_CREATE) {
            addDefaultUserPublicLayouts = true;
            if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
                if (hasPowerUserRole == null) {
                    hasPowerUserRole = this.hasPowerUserRole(user);
                }
                if (!hasPowerUserRole.booleanValue()) {
                    addDefaultUserPublicLayouts = false;
                }
            }
        }
        Boolean hasPublicLayouts = null;
        if (addDefaultUserPublicLayouts && !(hasPublicLayouts = Boolean.valueOf(LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)false, (boolean)false))).booleanValue()) {
            this.addDefaultUserPublicLayouts(user);
        }
        boolean deleteDefaultUserPublicLayouts = false;
        if (!PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            deleteDefaultUserPublicLayouts = true;
        } else if (PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_POWER_USER_REQUIRED) {
            if (hasPowerUserRole == null) {
                hasPowerUserRole = this.hasPowerUserRole(user);
            }
            if (!hasPowerUserRole.booleanValue()) {
                deleteDefaultUserPublicLayouts = true;
            }
        }
        if (deleteDefaultUserPublicLayouts) {
            if (hasPublicLayouts == null) {
                hasPublicLayouts = LayoutLocalServiceUtil.hasLayouts((User)user, (boolean)false, (boolean)false);
            }
            if (hasPublicLayouts.booleanValue()) {
                this.deleteDefaultUserPublicLayouts(user);
            }
        }
    }
}

