/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginPostAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(LoginPostAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running " + request.getRemoteUser()));
            }
            HttpSession session = request.getSession();
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            long userId = 0L;
            session.removeAttribute("org.apache.struts.action.LOCALE");
            if (PropsValues.LIVE_USERS_ENABLED) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
                if (clusterNode != null) {
                    jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
                }
                jsonObject.put("command", "signIn");
                jsonObject.put("companyId", companyId);
                jsonObject.put("remoteAddr", request.getRemoteAddr());
                jsonObject.put("remoteHost", request.getRemoteHost());
                jsonObject.put("sessionId", session.getId());
                String userAgent = request.getHeader("User-Agent");
                jsonObject.put("userAgent", userAgent);
                userId = PortalUtil.getUserId((HttpServletRequest)request);
                jsonObject.put("userId", userId);
                MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
            }
            if (PrefsPropsUtil.getBoolean(companyId, "admin.sync.default.associations")) {
                if (userId == 0L) {
                    userId = PortalUtil.getUserId((HttpServletRequest)request);
                }
                UserLocalServiceUtil.addDefaultGroups((long)userId);
                UserLocalServiceUtil.addDefaultRoles((long)userId);
                UserLocalServiceUtil.addDefaultUserGroups((long)userId);
            }
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }
}

