/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.deploy.RequiredPluginsUtil;
import com.liferay.portal.im.AIMConnector;
import com.liferay.portal.im.ICQConnector;
import com.liferay.portal.im.MSNConnector;
import com.liferay.portal.im.YMConnector;
import com.liferay.portal.jcr.JCRFactoryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.deploy.sandbox.SandboxDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.log.Jdk14LogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.util.ThirdPartyThreadLocalRegistry;
import java.sql.Connection;
import java.sql.Statement;

public class GlobalShutdownAction
extends SimpleAction {
    private static Log _log = LogFactoryUtil.getLog(GlobalShutdownAction.class);

    public void run(String[] ids) {
        this.shutdownLevel1();
        this.shutdownLevel2();
        this.shutdownLevel3();
        this.shutdownLevel4();
        this.shutdownLevel5();
        this.shutdownLevel6();
        this.shutdownLevel7();
    }

    protected ThreadGroup getThreadGroup() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        for (int i = 0; i < 10 && threadGroup.getParent() != null; ++i) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    protected Thread[] getThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount() * 2];
        threadGroup.enumerate(threads);
        return threads;
    }

    protected void shutdownLevel1() {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down AIM");
            }
            AIMConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down ICQ");
            }
            ICQConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down MSN");
            }
            MSNConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down YM");
            }
            YMConnector.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        JavadocManagerUtil.unload((String)"");
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Shutting down JCR");
            }
            JCRFactoryUtil.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        LuceneHelperUtil.shutdown();
        DocumentConversionUtil.disconnect();
        RequiredPluginsUtil.stopCheckingRequiredPlugins();
        try {
            SchedulerEngineHelperUtil.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TemplateManagerUtil.destroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TemplateResourceLoaderUtil.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void shutdownLevel2() {
        AutoDeployUtil.unregisterDir((String)"defaultAutoDeployDir");
        HotDeployUtil.unregisterListeners();
        SandboxDeployUtil.unregisterDir((String)"defaultSandboxDeployDir");
    }

    protected void shutdownLevel3() {
        MessageBusUtil.shutdown((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownLevel4() {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (dbType.equals("hypersonic")) {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = DataAccess.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate("SHUTDOWN");
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            finally {
                DataAccess.cleanUp((Connection)connection, (Statement)statement);
            }
        }
        MPIHelperUtil.shutdown();
    }

    protected void shutdownLevel5() {
        PortalExecutorManagerUtil.shutdown((boolean)true);
    }

    protected void shutdownLevel6() {
        try {
            LogFactoryUtil.setLogFactory((LogFactory)new Jdk14LogFactoryImpl());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThirdPartyThreadLocalRegistry.resetThreadLocals();
        CentralizedThreadLocal.clearShortLivedThreadLocals();
    }

    protected void shutdownLevel7() {
        if (GetterUtil.getBoolean((String)PropsUtil.get("shutdown.programmatically.exit"))) {
            Thread[] threads;
            Thread currentThread = Thread.currentThread();
            ThreadGroup threadGroup = this.getThreadGroup();
            for (Thread thread : threads = this.getThreads(threadGroup)) {
                if (thread == null || thread == currentThread) continue;
                try {
                    thread.interrupt();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            threadGroup.destroy();
        }
    }
}

