/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.collections.ServiceTrackerCollections;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class EventsProcessorUtil {
    private static Log _log = LogFactoryUtil.getLog(EventsProcessorUtil.class);
    private static EventsProcessorUtil _instance = new EventsProcessorUtil();
    private ConcurrentMap<String, Collection<LifecycleAction>> _lifecycleActions = new ConcurrentHashMap<String, Collection<LifecycleAction>>();

    public static void process(String key, String[] classes) throws ActionException {
        _instance._process(key, classes, new LifecycleEvent());
    }

    public static void process(String key, String[] classes, HttpServletRequest request, HttpServletResponse response) throws ActionException {
        _instance._process(key, classes, new LifecycleEvent(request, response));
    }

    public static void process(String key, String[] classes, HttpSession session) throws ActionException {
        _instance._process(key, classes, new LifecycleEvent(session));
    }

    public static void process(String key, String[] classes, LifecycleEvent lifecycleEvent) throws ActionException {
        _instance._process(key, classes, lifecycleEvent);
    }

    public static void process(String key, String[] classes, String[] ids) throws ActionException {
        _instance._process(key, classes, new LifecycleEvent(ids));
    }

    public static void processEvent(LifecycleAction lifecycleAction, LifecycleEvent lifecycleEvent) throws ActionException {
        _instance._processEvent(lifecycleAction, lifecycleEvent);
    }

    public static void registerEvent(String key, Object event) {
        _instance._registerEvent(key, event);
    }

    public static void unregisterEvent(String key, Object event) {
        _instance._unregisterEvent(key, event);
    }

    private EventsProcessorUtil() {
    }

    private Collection<LifecycleAction> _getLifecycleActions(String key) {
        Collection lifecycleActions = (Collection)this._lifecycleActions.get(key);
        if (lifecycleActions == null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("key", key);
            lifecycleActions = ServiceTrackerCollections.list(LifecycleAction.class, (String)("(key=" + key + ")"), properties);
            this._lifecycleActions.putIfAbsent(key, lifecycleActions);
        }
        return lifecycleActions;
    }

    private void _process(String key, String[] classes, LifecycleEvent lifecycleEvent) throws ActionException {
        for (String className : classes) {
            if (Validator.isNull((String)className)) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Process event " + className));
            }
            LifecycleAction lifecycleAction = (LifecycleAction)InstancePool.get((String)className);
            lifecycleAction.processLifecycleEvent(lifecycleEvent);
        }
        if (Validator.isNull((String)key)) {
            return;
        }
        for (LifecycleAction lifecycleAction : _instance._getLifecycleActions(key)) {
            lifecycleAction.processLifecycleEvent(lifecycleEvent);
        }
    }

    private void _processEvent(LifecycleAction lifecycleAction, LifecycleEvent lifecycleEvent) throws ActionException {
        lifecycleAction.processLifecycleEvent(lifecycleEvent);
    }

    private void _registerEvent(String key, Object event) {
        Collection<LifecycleAction> lifecycleActions = _instance._getLifecycleActions(key);
        lifecycleActions.add((LifecycleAction)event);
    }

    private void _unregisterEvent(String key, Object event) {
        Collection<LifecycleAction> lifecycleActions = _instance._getLifecycleActions(key);
        lifecycleActions.remove(event);
    }
}

