/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.BaseDefaultLayoutPrototypesAction;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class AddDefaultLayoutSetPrototypesAction
extends BaseDefaultLayoutPrototypesAction {
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(GetterUtil.getLong((String)ids[0]));
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected LayoutSet addLayoutSetPrototype(long companyId, long defaultUserId, String nameKey, String descriptionKey, List<LayoutSetPrototype> layoutSetPrototypes) throws Exception {
        Locale[] locales;
        String name = LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)nameKey);
        String description = LanguageUtil.get((Locale)LocaleUtil.getDefault(), (String)descriptionKey);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            String curName = layoutSetPrototype.getName(LocaleUtil.getDefault());
            String curDescription = layoutSetPrototype.getDescription(LocaleUtil.getDefault());
            if (!name.equals(curName) || !description.equals(curDescription)) continue;
            return null;
        }
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        for (Locale locale : locales = LanguageUtil.getAvailableLocales()) {
            nameMap.put(locale, LanguageUtil.get((Locale)locale, (String)nameKey));
            descriptionMap.put(locale, LanguageUtil.get((Locale)locale, (String)descriptionKey));
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)defaultUserId, (long)companyId, nameMap, descriptionMap, (boolean)true, (boolean)true, (ServiceContext)new ServiceContext());
        LayoutSet layoutSet = layoutSetPrototype.getLayoutSet();
        ServiceContext serviceContext = new ServiceContext();
        LayoutLocalServiceUtil.deleteLayouts((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (ServiceContext)serviceContext);
        return layoutSetPrototype.getLayoutSet();
    }

    protected void addPrivateSite(long companyId, long defaultUserId, List<LayoutSetPrototype> layoutSetPrototypes) throws Exception {
        Locale[] locales;
        LayoutSet layoutSet = this.addLayoutSetPrototype(companyId, defaultUserId, "layout-set-prototype-intranet-site-title", "layout-set-prototype-intranet-site-description", layoutSetPrototypes);
        if (layoutSet == null) {
            return;
        }
        Layout layout = this.addLayout(layoutSet, "home", "/home", "2_columns_i");
        String portletId = this.addPortletId(layout, "3", "column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("portletSetupShowBorders", Boolean.FALSE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "82", "column-2");
        preferences = new HashMap();
        preferences.put("displayStyle", "3");
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "101", "column-2");
        preferences = new HashMap();
        for (Locale locale : locales = LanguageUtil.getAvailableLocales()) {
            preferences.put("portletSetupTitle_" + locale, LanguageUtil.get((Locale)locale, (String)"recent-content"));
        }
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        layout = this.addLayout(layoutSet, "documents-and-media", "/documents", "1_column");
        portletId = this.addPortletId(layout, "20", "column-1");
        preferences = new HashMap();
        preferences.put("portletSetupShowBorders", Boolean.FALSE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "101", "column-2");
        preferences = new HashMap();
        preferences.put("anyAssetType", Boolean.FALSE.toString());
        for (Locale locale : locales) {
            preferences.put("portletSetupTitle_" + locale, LanguageUtil.get((Locale)locale, (String)"upcoming-events"));
        }
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        layout = this.addLayout(layoutSet, "news", "/news", "2_columns_iii");
        portletId = this.addPortletId(layout, "39", "column-1");
        preferences = new HashMap();
        preferences.put("expandedEntriesPerFeed", "3");
        for (Locale locale : locales) {
            preferences.put("portletSetupTitle_" + locale, LanguageUtil.get((Locale)locale, (String)"technology-news"));
        }
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        preferences.put("urls", "http://partners.userland.com/nytRss/technology.xml");
        this.updatePortletSetup(layout, portletId, preferences);
        portletId = this.addPortletId(layout, "39", "column-2");
        preferences = new HashMap();
        preferences.put("expandedEntriesPerFeed", "0");
        for (Locale locale : locales) {
            preferences.put("portletSetupTitle_" + locale, LanguageUtil.get((Locale)locale, (String)"liferay-news"));
        }
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        preferences.put("urls", "http://www.liferay.com/en/about-us/news/-/blogs/rss");
        preferences.put("titles", "Liferay Press Releases");
        this.updatePortletSetup(layout, portletId, preferences);
    }

    protected void addPublicSite(long companyId, long defaultUserId, List<LayoutSetPrototype> layoutSetPrototypes) throws Exception {
        Locale[] locales;
        LayoutSet layoutSet = this.addLayoutSetPrototype(companyId, defaultUserId, "layout-set-prototype-community-site-title", "layout-set-prototype-community-site-description", layoutSetPrototypes);
        if (layoutSet == null) {
            return;
        }
        Layout layout = this.addLayout(layoutSet, "home", "/home", "2_columns_iii");
        this.addPortletId(layout, "19", "column-1");
        String portletId = this.addPortletId(layout, "3", "column-2");
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("portletSetupShowBorders", Boolean.FALSE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        this.addPortletId(layout, "180", "column-2");
        portletId = this.addPortletId(layout, "101", "column-2");
        preferences = new HashMap();
        preferences.put("anyAssetType", Boolean.FALSE.toString());
        for (Locale locale : locales = LanguageUtil.getAvailableLocales()) {
            preferences.put("portletSetupTitle_" + locale, LanguageUtil.get((Locale)locale, (String)"upcoming-events"));
        }
        preferences.put("portletSetupUseCustomTitle", Boolean.TRUE.toString());
        this.updatePortletSetup(layout, portletId, preferences);
        layout = this.addLayout(layoutSet, "wiki", "/wiki", "2_columns_iii");
        this.addPortletId(layout, "36", "column-1");
        this.addPortletId(layout, "122", "column-2");
        this.addPortletId(layout, "148", "column-2");
    }

    protected void doRun(long companyId) throws Exception {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        List layoutSetPrototypes = LayoutSetPrototypeLocalServiceUtil.search((long)companyId, null, (int)-1, (int)-1, null);
        this.addPublicSite(companyId, defaultUserId, layoutSetPrototypes);
        this.addPrivateSite(companyId, defaultUserId, layoutSetPrototypes);
    }
}

