/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.events.BaseDefaultDDMStructureAction;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryTypeException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.RawMetadataProcessor;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AddDefaultDocumentLibraryStructuresAction
extends BaseDefaultDDMStructureAction {
    public void run(String[] ids) throws ActionException {
        try {
            this.doRun(GetterUtil.getLong((String)ids[0]));
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    protected void addDLFileEntryType(long userId, long groupId, String dlFileEntryTypeKey, List<String> ddmStructureNames, ServiceContext serviceContext) throws Exception {
        ArrayList<Long> ddmStructureIds = new ArrayList<Long>();
        Iterator<String> i$ = ddmStructureNames.iterator();
        while (i$.hasNext()) {
            String ddmStructureName;
            String ddmStructureKey = ddmStructureName = i$.next();
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)PortalUtil.getClassNameId(DLFileEntryMetadata.class), (String)ddmStructureKey);
            if (ddmStructure == null) continue;
            ddmStructureIds.add(ddmStructure.getStructureId());
        }
        Locale locale = PortalUtil.getSiteDefaultLocale((long)groupId);
        String definition = this.getDynamicDDMStructureDefinition("document-library-structures.xml", dlFileEntryTypeKey, locale);
        serviceContext.setAttribute("definition", (Serializable)((Object)definition));
        try {
            DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)groupId, (String)dlFileEntryTypeKey);
        }
        catch (NoSuchFileEntryTypeException nsfete) {
            DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)groupId, (String)dlFileEntryTypeKey, this.getLocalizationMap(dlFileEntryTypeKey, locale), this.getLocalizationMap(dlFileEntryTypeKey, locale), (long[])ArrayUtil.toArray((Long[])ddmStructureIds.toArray(new Long[ddmStructureIds.size()])), (ServiceContext)serviceContext);
        }
    }

    protected void addDLFileEntryTypes(long userId, long groupId, ServiceContext serviceContext) throws Exception {
        ArrayList<String> ddmStructureNames = new ArrayList<String>();
        this.addDLFileEntryType(userId, groupId, "contract", ddmStructureNames, serviceContext);
        ddmStructureNames.clear();
        ddmStructureNames.add("Marketing Campaign Theme Metadata");
        this.addDLFileEntryType(userId, groupId, "marketing-banner", ddmStructureNames, serviceContext);
        ddmStructureNames.clear();
        ddmStructureNames.add("Learning Module Metadata");
        this.addDLFileEntryType(userId, groupId, "online-training", ddmStructureNames, serviceContext);
        ddmStructureNames.clear();
        ddmStructureNames.add("Meeting Metadata");
        this.addDLFileEntryType(userId, groupId, "sales-presentation", ddmStructureNames, serviceContext);
        if (UpgradeProcessUtil.isCreateIGImageDocumentType()) {
            this.addDLFileEntryType(userId, groupId, "image-gallery-image", ddmStructureNames, serviceContext);
        }
    }

    protected void addDLRawMetadataStructures(long userId, long groupId, ServiceContext serviceContext) throws Exception {
        Locale locale = PortalUtil.getSiteDefaultLocale((long)groupId);
        String xsd = this.buildDLRawMetadataXML(RawMetadataProcessorUtil.getFields(), locale);
        Document document = SAXReaderUtil.read((Reader)new StringReader(xsd));
        Element rootElement = document.getRootElement();
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            String name = structureElement.elementText("name");
            String description = structureElement.elementText("description");
            Element structureElementRootElement = structureElement.element("root");
            String structureElementRootXML = structureElementRootElement.asXML();
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)PortalUtil.getClassNameId(RawMetadataProcessor.class), (String)name);
            if (ddmStructure != null) {
                ddmStructure.setDefinition(structureElementRootXML);
                DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)ddmStructure);
                continue;
            }
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(locale, name);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(locale, description);
            DDMStructureLocalServiceUtil.addStructure((long)userId, (long)groupId, (long)0L, (long)PortalUtil.getClassNameId(RawMetadataProcessor.class), (String)name, nameMap, descriptionMap, (String)structureElementRootXML, (String)"xml", (int)0, (ServiceContext)serviceContext);
        }
    }

    protected String buildDLRawMetadataElementXML(Field field, Locale locale) {
        StringBundler sb = new StringBundler(15);
        sb.append("<dynamic-element dataType=\"string\" indexType=\"text\" ");
        sb.append("name=\"");
        Class<?> fieldClass = field.getDeclaringClass();
        sb.append(fieldClass.getSimpleName());
        sb.append("_");
        sb.append(field.getName());
        sb.append("\" required=\"false\" showLabel=\"true\" type=\"text\">");
        sb.append("<meta-data locale=\"");
        sb.append((Object)locale);
        sb.append("\">");
        sb.append("<entry name=\"label\"><![CDATA[metadata.");
        sb.append(fieldClass.getSimpleName());
        sb.append(".");
        sb.append(field.getName());
        sb.append("]]></entry><entry name=\"predefinedValue\">");
        sb.append("<![CDATA[]]></entry></meta-data></dynamic-element>");
        return sb.toString();
    }

    protected String buildDLRawMetadataStructureXML(String name, Field[] fields, Locale locale) {
        StringBundler sb = new StringBundler(12 + fields.length);
        sb.append("<structure><name><![CDATA[");
        sb.append(name);
        sb.append("]]></name>");
        sb.append("<description><![CDATA[");
        sb.append(name);
        sb.append("]]></description>");
        sb.append("<root available-locales=\"");
        sb.append((Object)locale);
        sb.append("\" default-locale=\"");
        sb.append((Object)locale);
        sb.append("\">");
        for (Field field : fields) {
            sb.append(this.buildDLRawMetadataElementXML(field, locale));
        }
        sb.append("</root></structure>");
        return sb.toString();
    }

    protected String buildDLRawMetadataXML(Map<String, Field[]> fields, Locale locale) {
        StringBundler sb = new StringBundler(2 + fields.size());
        sb.append("<?xml version=\"1.0\"?><root>");
        for (String key : fields.keySet()) {
            sb.append(this.buildDLRawMetadataStructureXML(key, fields.get(key), locale));
        }
        sb.append("</root>");
        return sb.toString();
    }

    protected void doRun(long companyId) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
        serviceContext.setScopeGroupId(group.getGroupId());
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        serviceContext.setUserId(defaultUserId);
        this.addDDMStructures(defaultUserId, group.getGroupId(), PortalUtil.getClassNameId(DLFileEntryMetadata.class), "document-library-structures.xml", serviceContext);
        this.addDLFileEntryTypes(defaultUserId, group.getGroupId(), serviceContext);
        this.addDLRawMetadataStructures(defaultUserId, group.getGroupId(), serviceContext);
    }

    protected Map<Locale, String> getLocalizationMap(String content, Locale locale) {
        HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
        localizationMap.put(locale, content);
        return localizationMap;
    }
}

