/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.service.ServiceWrapper;
import java.lang.reflect.InvocationHandler;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.target.SingletonTargetSource;

public class ServiceBag<V> {
    private AdvisedSupport _advisedSupport;
    private ServiceWrapper<?> _serviceWrapper;

    public ServiceBag(ClassLoader classLoader, AdvisedSupport advisedSupport, Class<?> serviceTypeClass, final ServiceWrapper<V> serviceWrapper) {
        this._advisedSupport = advisedSupport;
        Object previousService = serviceWrapper.getWrappedService();
        if (!(previousService instanceof ServiceWrapper)) {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            previousService = ProxyUtil.newProxyInstance((ClassLoader)portalClassLoader, (Class[])new Class[]{serviceTypeClass}, (InvocationHandler)new ClassLoaderBeanHandler(previousService, portalClassLoader));
            serviceWrapper.setWrappedService(previousService);
        }
        Object nextTarget = ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])new Class[]{serviceTypeClass, ServiceWrapper.class}, (InvocationHandler)new ClassLoaderBeanHandler(serviceWrapper, classLoader));
        SingletonTargetSource nextTargetSource = new SingletonTargetSource(nextTarget){

            public Class<?> getTargetClass() {
                return serviceWrapper.getClass();
            }
        };
        this._advisedSupport.setTargetSource((TargetSource)nextTargetSource);
        this._serviceWrapper = (ServiceWrapper)nextTarget;
    }

    public <T> void replace() throws Exception {
        TargetSource targetSource = this._advisedSupport.getTargetSource();
        Object currentService = targetSource.getTarget();
        ServiceWrapper previousService = null;
        while (true) {
            if (currentService == this._serviceWrapper) {
                Object wrappedService = this._serviceWrapper.getWrappedService();
                if (previousService == null) {
                    InvocationHandler invocationHandler;
                    if (!(wrappedService instanceof ServiceWrapper) && ProxyUtil.isProxyClass(wrappedService.getClass()) && (invocationHandler = ProxyUtil.getInvocationHandler((Object)wrappedService)) instanceof ClassLoaderBeanHandler) {
                        ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
                        wrappedService = classLoaderBeanHandler.getBean();
                    }
                    SingletonTargetSource previousTargetSource = new SingletonTargetSource(wrappedService);
                    this._advisedSupport.setTargetSource((TargetSource)previousTargetSource);
                    break;
                }
                previousService.setWrappedService(wrappedService);
                break;
            }
            if (!(currentService instanceof ServiceWrapper)) break;
            previousService = (ServiceWrapper)currentService;
            currentService = previousService.getWrappedService();
        }
    }
}

