/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.StorageTypeAware;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;

public class SchedulerEntryRegistry {
    private static Log _log = LogFactoryUtil.getLog(SchedulerEntryRegistry.class);
    private final ServiceTracker<SchedulerEntry, SchedulerEntry> _serviceTracker;

    public SchedulerEntryRegistry() {
        if (!PropsValues.SCHEDULER_ENABLED) {
            this._serviceTracker = null;
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=*)(objectClass=" + SchedulerEntry.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new SchedulerEntryServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        this._serviceTracker.close();
    }

    private class SchedulerEntryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SchedulerEntry, SchedulerEntry> {
        private SchedulerEntryServiceTrackerCustomizer() {
        }

        public SchedulerEntry addingService(ServiceReference<SchedulerEntry> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            SchedulerEntry schedulerEntry = (SchedulerEntry)registry.getService(serviceReference);
            StorageType storageType = StorageType.MEMORY_CLUSTERED;
            if (schedulerEntry instanceof StorageTypeAware) {
                StorageTypeAware storageTypeAware = (StorageTypeAware)schedulerEntry;
                storageType = storageTypeAware.getStorageType();
            }
            this.addTrigger(schedulerEntry, serviceReference);
            String portletId = (String)serviceReference.getProperty("javax.portlet.name");
            try {
                SchedulerEngineHelperUtil.schedule((SchedulerEntry)schedulerEntry, (StorageType)storageType, (String)portletId, (int)0);
                return schedulerEntry;
            }
            catch (SchedulerException e) {
                _log.error((Object)e, (Throwable)e);
                return null;
            }
        }

        public void modifiedService(ServiceReference<SchedulerEntry> serviceReference, SchedulerEntry schedulerEntry) {
        }

        public void removedService(ServiceReference<SchedulerEntry> serviceReference, SchedulerEntry schedulerEntry) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            StorageType storageType = StorageType.MEMORY_CLUSTERED;
            if (schedulerEntry instanceof StorageTypeAware) {
                StorageTypeAware storageTypeAware = (StorageTypeAware)schedulerEntry;
                storageType = storageTypeAware.getStorageType();
            }
            try {
                SchedulerEngineHelperUtil.unschedule((SchedulerEntry)schedulerEntry, (StorageType)storageType);
            }
            catch (SchedulerException e) {
                _log.error((Object)e, (Throwable)e);
            }
        }

        protected void addTrigger(SchedulerEntry schedulerEntry, ServiceReference<SchedulerEntry> serviceReference) {
            String propertyKey = schedulerEntry.getPropertyKey();
            if (Validator.isNull((String)propertyKey)) {
                return;
            }
            long bundleId = GetterUtil.getLong((Object)serviceReference.getProperty("bundle.id"), (long)-1L);
            String triggerValue = null;
            if (bundleId != 0L) {
                Class<?> clazz = schedulerEntry.getClass();
                ClassLoader classloader = clazz.getClassLoader();
                triggerValue = this.getPluginPropertyValue(classloader, propertyKey);
            } else {
                triggerValue = PrefsPropsUtil.getString((String)propertyKey);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Scheduler property key " + propertyKey + " has trigger value " + triggerValue));
            }
            if (Validator.isNotNull((String)triggerValue)) {
                schedulerEntry.setTriggerValue(triggerValue);
            }
        }

        protected String getPluginPropertyValue(ClassLoader classLoader, String propertyKey) {
            Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
            return configuration.get(propertyKey);
        }
    }
}

