/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;

public class IndexerPostProcessorRegistry {
    private static Log _log = LogFactoryUtil.getLog(IndexerPostProcessorRegistry.class);
    private ServiceTracker<IndexerPostProcessor, IndexerPostProcessor> _serviceTracker;

    public IndexerPostProcessorRegistry() {
        Registry registry = RegistryUtil.getRegistry();
        Filter indexerPostProcessorFilter = registry.getFilter("(&(indexer.class.name=*)(objectClass=" + IndexerPostProcessor.class.getName() + "))");
        this._serviceTracker = registry.trackServices(indexerPostProcessorFilter, (ServiceTrackerCustomizer)new IndexerPostProcessorServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    private class IndexerPostProcessorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<IndexerPostProcessor, IndexerPostProcessor> {
        private IndexerPostProcessorServiceTrackerCustomizer() {
        }

        public IndexerPostProcessor addingService(ServiceReference<IndexerPostProcessor> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            IndexerPostProcessor indexerPostProcessor = (IndexerPostProcessor)registry.getService(serviceReference);
            String indexerClassName = (String)serviceReference.getProperty("indexer.class.name");
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)indexerClassName);
            if (indexer == null) {
                _log.error((Object)("No indexer for " + indexerClassName + " was found"));
                return null;
            }
            indexer.registerIndexerPostProcessor(indexerPostProcessor);
            return indexerPostProcessor;
        }

        public void modifiedService(ServiceReference<IndexerPostProcessor> serviceReference, IndexerPostProcessor indexerPostProcessor) {
        }

        public void removedService(ServiceReference<IndexerPostProcessor> serviceReference, IndexerPostProcessor indexerPostProcessor) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String indexerClassName = (String)serviceReference.getProperty("indexer.class.name");
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)indexerClassName);
            indexer.unregisterIndexerPostProcessor(indexerPostProcessor);
        }
    }
}

