/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto.exploded.tomcat;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SystemConfiguration;

public abstract class BaseExplodedTomcatListener
implements AutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(BaseExplodedTomcatListener.class);
    private static SystemConfiguration _systemConfiguration = new SystemConfiguration();

    public void copyContextFile(File file) throws AutoDeployException {
        try {
            String tomcatConfDir = PrefsPropsUtil.getString("auto.deploy.tomcat.conf.dir", PropsValues.AUTO_DEPLOY_TOMCAT_CONF_DIR);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Copying file " + file.getPath() + " to " + tomcatConfDir));
            }
            FileUtil.copyFile((File)file, (File)new File(tomcatConfDir + "/" + file.getName()));
        }
        catch (Exception e) {
            throw new AutoDeployException(e.getMessage());
        }
    }

    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        return this.deploy(file);
    }

    public File getDocBaseDir(File file, String checkXmlFile) throws AutoDeployException {
        if (!this.isMatchingFileExtension(file)) {
            return null;
        }
        String docBase = null;
        try {
            String content = FileUtil.read((File)file);
            Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            docBase = rootElement.attributeValue("docBase");
            docBase = String.valueOf(PropertyConverter.interpolate((Object)docBase, (AbstractConfiguration)_systemConfiguration));
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
        if (Validator.isNull((String)docBase)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(file.getPath() + " does not have a docBase defined"));
            }
            return null;
        }
        File docBaseDir = new File(docBase);
        if (!docBaseDir.exists()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(docBase + " does not exist"));
            }
            return null;
        }
        if (!docBaseDir.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(docBase + " is not a directory"));
            }
            return null;
        }
        if (!FileUtil.exists((String)(docBase + "/" + checkXmlFile))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(docBase + " does not have " + checkXmlFile));
            }
            return null;
        }
        return docBaseDir;
    }

    public boolean isMatchingFileExtension(File file) {
        if (file.getName().endsWith(".xml")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(file.getPath() + " has a matching extension"));
            }
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(file.getPath() + " does not have a matching extension"));
        }
        return false;
    }

    protected abstract int deploy(File var1) throws AutoDeployException;
}

