/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import com.liferay.portal.deploy.auto.ModuleAutoDeployer;
import com.liferay.portal.deploy.auto.ThreadSafeAutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.BaseAutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ModuleAutoDeployListener
extends BaseAutoDeployListener {
    private static Log _log = LogFactoryUtil.getLog(ModuleAutoDeployListener.class);
    private AutoDeployer _autoDeployer = new ThreadSafeAutoDeployer(new ModuleAutoDeployer());

    public int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        int code;
        File file = autoDeploymentContext.getFile();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + file.getPath()));
        }
        if (!this.isModule(file)) {
            return 0;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Copied module for " + file.getPath()));
        }
        if ((code = this._autoDeployer.autoDeploy(autoDeploymentContext)) == 1 && _log.isInfoEnabled()) {
            _log.info((Object)("Module for " + file.getPath() + " copied successfully. " + "Deployment will start in a few seconds."));
        }
        return code;
    }

    protected boolean isModule(File file) throws AutoDeployException {
        if (!this.isJarFile(file)) {
            return false;
        }
        JarInputStream jarInputStream = null;
        Manifest manifest = null;
        try {
            jarInputStream = new JarInputStream(new FileInputStream(file));
            manifest = jarInputStream.getManifest();
        }
        catch (IOException ioe) {
            try {
                throw new AutoDeployException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{jarInputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{jarInputStream});
        if (manifest == null) {
            return false;
        }
        Attributes attributes = manifest.getMainAttributes();
        String bundleSymbolicNameAttributeValue = attributes.getValue("Bundle-SymbolicName");
        Parameters bundleSymbolicNameMap = OSGiHeader.parseHeader((String)bundleSymbolicNameAttributeValue);
        Set bundleSymbolicNameSet = bundleSymbolicNameMap.keySet();
        if (bundleSymbolicNameSet.isEmpty()) {
            return false;
        }
        Iterator bundleSymbolicNameIterator = bundleSymbolicNameSet.iterator();
        String bundleSymbolicName = (String)bundleSymbolicNameIterator.next();
        return Validator.isNotNull((String)bundleSymbolicName);
    }
}

