/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LiferayPackageAutoDeployer
implements AutoDeployer {
    private static Log _log = LogFactoryUtil.getLog(LiferayPackageAutoDeployer.class);
    private final String _baseDir;

    public LiferayPackageAutoDeployer() {
        String baseDir = null;
        try {
            baseDir = PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._baseDir = baseDir;
    }

    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        ZipFile zipFile = null;
        try {
            File file = autoDeploymentContext.getFile();
            zipFile = new ZipFile(file);
            ArrayList<String> fileNames = new ArrayList<String>(zipFile.size());
            String propertiesString = null;
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                String zipEntryFileName = zipEntry.getName();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Extracting " + zipEntryFileName + " from " + file.getName()));
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                if (zipEntryFileName.equals("liferay-marketplace.properties")) {
                    inputStream = zipFile.getInputStream(zipEntry);
                    propertiesString = StringUtil.read((InputStream)inputStream);
                    continue;
                }
                fileNames.add(zipEntryFileName);
                FileUtil.write((String)(this._baseDir + "/" + zipEntryFileName), (InputStream)inputStream);
            }
            if (propertiesString != null) {
                Message message = new Message();
                message.put("command", (Object)"deploy");
                message.put("fileNames", fileNames);
                message.put("properties", propertiesString);
                MessageBusUtil.sendMessage((String)"liferay/marketplace", (Message)message);
            }
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new AutoDeployException((Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public AutoDeployer cloneAutoDeployer() {
        return new LiferayPackageAutoDeployer();
    }
}

