/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShardIterativelyAdvice
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(ShardIterativelyAdvice.class);
    private ShardAdvice _shardAdvice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object returnValue = null;
        for (String shardName : ShardUtil.getAvailableShardNames()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Invoking shard " + shardName + " for " + methodInvocation.toString()));
            }
            this._shardAdvice.pushCompanyService(shardName);
            try {
                Object value = methodInvocation.proceed();
                if (!shardName.equals(ShardUtil.getDefaultShardName())) continue;
                returnValue = value;
            }
            finally {
                this._shardAdvice.popCompanyService();
                CacheRegistryUtil.clear();
            }
        }
        return returnValue;
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        this._shardAdvice = shardAdvice;
    }
}

