/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.spring.hibernate.PortalHibernateConfiguration;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.aop.TargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class ShardSessionFactoryTargetSource
implements BeanFactoryAware,
TargetSource {
    private static Map<String, SessionFactory> _sessionFactories = new HashMap<String, SessionFactory>();
    private static ThreadLocal<SessionFactory> _sessionFactory = new CentralizedThreadLocal<SessionFactory>(false){

        protected SessionFactory initialValue() {
            return (SessionFactory)_sessionFactories.get(PropsValues.SHARD_DEFAULT_NAME);
        }
    };
    private BeanFactory _beanFactory;
    private ShardDataSourceTargetSource _shardDataSourceTargetSource;

    public void afterPropertiesSet() throws Exception {
        Map<String, DataSource> dataSources = this._shardDataSourceTargetSource.getDataSources();
        for (String shardName : dataSources.keySet()) {
            DataSource dataSource = dataSources.get(shardName);
            PortalHibernateConfiguration portalHibernateConfiguration = new PortalHibernateConfiguration();
            portalHibernateConfiguration.setBeanFactory(this._beanFactory);
            portalHibernateConfiguration.setDataSource(dataSource);
            SessionFactory sessionFactory = portalHibernateConfiguration.buildSessionFactory();
            _sessionFactories.put(shardName, sessionFactory);
        }
    }

    public Map<String, SessionFactory> getSessionFactories() {
        return _sessionFactories;
    }

    public SessionFactory getSessionFactory() {
        return _sessionFactory.get();
    }

    public Object getTarget() throws Exception {
        return this.getSessionFactory();
    }

    public Class<?> getTargetClass() {
        return _sessionFactories.get(PropsValues.SHARD_DEFAULT_NAME).getClass();
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this._beanFactory = beanFactory;
    }

    public void setSessionFactory(String shardName) {
        _sessionFactory.set(_sessionFactories.get(shardName));
    }

    public void setShardDataSourceTargetSource(ShardDataSourceTargetSource shardDataSourceTargetSource) {
        this._shardDataSourceTargetSource = shardDataSourceTargetSource;
    }
}

