/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.region;

import com.liferay.portal.cache.ehcache.CacheManagerUtil;
import com.liferay.portal.cache.ehcache.EhcacheConfigurationUtil;
import com.liferay.portal.cache.ehcache.EhcachePortalCache;
import com.liferay.portal.cache.ehcache.ModifiableEhcacheWrapper;
import com.liferay.portal.dao.orm.hibernate.region.CollectionRegionWrapper;
import com.liferay.portal.dao.orm.hibernate.region.EntityRegionWrapper;
import com.liferay.portal.dao.orm.hibernate.region.MBeanRegisteringPortalLifecycle;
import com.liferay.portal.dao.orm.hibernate.region.QueryResultsRegionWrapper;
import com.liferay.portal.dao.orm.hibernate.region.TimestampsRegionWrapper;
import com.liferay.portal.kernel.cache.CacheManagerListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.hibernate.EhCacheRegionFactory;
import net.sf.ehcache.hibernate.regions.EhcacheCollectionRegion;
import net.sf.ehcache.hibernate.regions.EhcacheEntityRegion;
import net.sf.ehcache.hibernate.regions.EhcacheQueryResultsRegion;
import net.sf.ehcache.hibernate.regions.EhcacheTimestampsRegion;
import net.sf.ehcache.util.FailSafeTimer;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;

public class LiferayEhcacheRegionFactory
extends EhCacheRegionFactory {
    private static final String _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE = "/ehcache/hibernate-clustered.xml";
    private static Log _log = LogFactoryUtil.getLog(LiferayEhcacheRegionFactory.class);
    private MBeanRegisteringPortalLifecycle _mBeanRegisteringPortalLifecycle;
    private boolean _usingDefault;

    public LiferayEhcacheRegionFactory(Properties properties) {
        super(properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription cacheDataDescription) throws CacheException {
        this.configureCache(regionName);
        EhcacheCollectionRegion ehcacheCollectionRegion = (EhcacheCollectionRegion)super.buildCollectionRegion(regionName, properties, cacheDataDescription);
        return new CollectionRegionWrapper(ehcacheCollectionRegion);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription cacheDataDescription) throws CacheException {
        this.configureCache(regionName);
        EhcacheEntityRegion ehcacheEntityRegion = (EhcacheEntityRegion)super.buildEntityRegion(regionName, properties, cacheDataDescription);
        return new EntityRegionWrapper(ehcacheEntityRegion);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        this.configureCache(regionName);
        EhcacheQueryResultsRegion ehcacheQueryResultsRegion = (EhcacheQueryResultsRegion)super.buildQueryResultsRegion(regionName, properties);
        return new QueryResultsRegionWrapper(ehcacheQueryResultsRegion);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        this.configureCache(regionName);
        EhcacheTimestampsRegion ehcacheTimestampsRegion = (EhcacheTimestampsRegion)super.buildTimestampsRegion(regionName, properties);
        TimestampsRegionWrapper timestampsRegion = new TimestampsRegionWrapper(ehcacheTimestampsRegion);
        return timestampsRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigureCaches(URL cacheConfigFile) {
        if (this.manager == null) {
            return;
        }
        CacheManager cacheManager = this.manager;
        synchronized (cacheManager) {
            Configuration configuration = EhcacheConfigurationUtil.getConfiguration(cacheConfigFile, true, this._usingDefault);
            Map cacheConfigurations = configuration.getCacheConfigurations();
            for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
                Cache ehcache = new Cache(cacheConfiguration);
                this.reconfigureCache((Ehcache)ehcache);
            }
        }
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        try {
            String configurationPath = null;
            if (properties != null) {
                configurationPath = (String)properties.get("net.sf.ehcache.configurationResourceName");
            }
            if (Validator.isNull(configurationPath)) {
                configurationPath = _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE;
            }
            Configuration configuration = null;
            if (Validator.isNull((String)configurationPath)) {
                configuration = ConfigurationFactory.parseConfiguration();
            } else {
                this._usingDefault = configurationPath.equals(_DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE);
                configuration = EhcacheConfigurationUtil.getConfiguration(configurationPath, true, this._usingDefault);
            }
            this.manager = CacheManagerUtil.createCacheManager(configuration);
            boolean skipUpdateCheck = GetterUtil.getBoolean((String)SystemProperties.get((String)"net.sf.ehcache.skipUpdateCheck"));
            boolean tcActive = GetterUtil.getBoolean((String)SystemProperties.get((String)"tc.active"));
            if (skipUpdateCheck && !tcActive) {
                FailSafeTimer failSafeTimer = this.manager.getTimer();
                failSafeTimer.cancel();
                try {
                    Field cacheManagerTimerField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"cacheManagerTimer");
                    cacheManagerTimerField.set(this.manager, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.mbeanRegistrationHelper.registerMBean(this.manager, properties);
            this._mBeanRegisteringPortalLifecycle = new MBeanRegisteringPortalLifecycle(this.manager);
            this._mBeanRegisteringPortalLifecycle.registerPortalLifecycle(2);
            PortalCacheProvider.registerPortalCacheManager((PortalCacheManager)new HibernatePortalCacheManager(this.manager));
        }
        catch (net.sf.ehcache.CacheException ce) {
            throw new CacheException((Throwable)ce);
        }
    }

    public void stop() {
        PortalCacheProvider.unregisterPortalCacheManager((String)this.manager.getName());
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureCache(String regionName) {
        CacheManager cacheManager = this.manager;
        synchronized (cacheManager) {
            Ehcache ehcache = this.manager.getEhcache(regionName);
            if (ehcache == null) {
                this.manager.addCache(regionName);
                ehcache = this.manager.getEhcache(regionName);
            }
            if (!(ehcache instanceof ModifiableEhcacheWrapper)) {
                ModifiableEhcacheWrapper modifiableEhcacheWrapper = new ModifiableEhcacheWrapper(ehcache);
                this.manager.replaceCacheWithDecoratedCache(ehcache, (Ehcache)modifiableEhcacheWrapper);
            }
        }
    }

    protected void reconfigureCache(Ehcache replacementCache) {
        String cacheName = replacementCache.getName();
        Ehcache ehcache = this.manager.getEhcache(cacheName);
        if (ehcache != null && ehcache instanceof ModifiableEhcacheWrapper) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Reconfiguring Hibernate cache " + cacheName));
            }
            ModifiableEhcacheWrapper modifiableEhcacheWrapper = (ModifiableEhcacheWrapper)ehcache;
            this.manager.replaceCacheWithDecoratedCache(ehcache, modifiableEhcacheWrapper.getWrappedCache());
            this.manager.removeCache(cacheName);
            this.manager.addCache(replacementCache);
            modifiableEhcacheWrapper.setWrappedCache(replacementCache);
            this.manager.replaceCacheWithDecoratedCache(replacementCache, (Ehcache)modifiableEhcacheWrapper);
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Configuring Hibernate cache " + cacheName));
            }
            if (ehcache != null) {
                this.manager.removeCache(cacheName);
            }
            ehcache = new ModifiableEhcacheWrapper(replacementCache);
            this.manager.addCache(replacementCache);
            this.manager.replaceCacheWithDecoratedCache(replacementCache, ehcache);
        }
    }

    private class HibernatePortalCacheManager
    implements PortalCacheManager<Serializable, Serializable> {
        private CacheManager _cacheManager;
        private Map<String, PortalCache<Serializable, Serializable>> _portalCaches = new HashMap<String, PortalCache<Serializable, Serializable>>();

        public HibernatePortalCacheManager(CacheManager cacheManager) {
            this._cacheManager = cacheManager;
        }

        public void clearAll() {
            throw new UnsupportedOperationException();
        }

        public void destroy() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PortalCache<Serializable, Serializable> getCache(String name) {
            Object portalCache = this._portalCaches.get(name);
            if (portalCache != null) {
                return portalCache;
            }
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                portalCache = this._portalCaches.get(name);
                if (portalCache == null) {
                    if (!this._cacheManager.cacheExists(name)) {
                        return null;
                    }
                    Cache cache = this._cacheManager.getCache(name);
                    portalCache = new EhcachePortalCache<Serializable, Serializable>(this, (Ehcache)cache);
                    this._portalCaches.put(name, (PortalCache<Serializable, Serializable>)portalCache);
                }
            }
            return portalCache;
        }

        public PortalCache<Serializable, Serializable> getCache(String name, boolean blocking) {
            throw new UnsupportedOperationException();
        }

        public Set<CacheManagerListener> getCacheManagerListeners() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return this._cacheManager.getName();
        }

        public boolean isClusterAware() {
            return true;
        }

        public void reconfigureCaches(URL configurationURL) {
            throw new UnsupportedOperationException();
        }

        public boolean registerCacheManagerListener(CacheManagerListener cacheManagerListener) {
            throw new UnsupportedOperationException();
        }

        public void removeCache(String name) {
            throw new UnsupportedOperationException();
        }

        public boolean unregisterCacheManagerListener(CacheManagerListener cacheManagerListener) {
            throw new UnsupportedOperationException();
        }

        public void unregisterCacheManagerListeners() {
            throw new UnsupportedOperationException();
        }
    }
}

