/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.impl.SessionImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class PortletSessionFactoryImpl
extends SessionFactoryImpl
implements BeanFactoryAware {
    private static Log _log = LogFactoryUtil.getLog(PortletSessionFactoryImpl.class);
    private BeanFactory _beanFactory;
    private DataSource _dataSource;
    private Map<DataSource, SessionFactory> _sessionFactories = new HashMap<DataSource, SessionFactory>();

    @Override
    public void closeSession(Session session) throws ORMException {
        if (session != null) {
            session.flush();
            if (!PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) {
                session.close();
            }
        }
    }

    @Override
    public Session openSession() throws ORMException {
        Connection connection;
        SessionFactory sessionFactory = this.getSessionFactory();
        org.hibernate.classic.Session session = null;
        session = PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED ? ((connection = CurrentConnectionUtil.getConnection((DataSource)this.getDataSource())) == null ? sessionFactory.getCurrentSession() : sessionFactory.openSession(connection)) : sessionFactory.openSession();
        if (_log.isDebugEnabled()) {
            SessionImpl sessionImpl = (SessionImpl)session;
            _log.debug((Object)("Session is using connection release mode " + sessionImpl.getConnectionReleaseMode()));
        }
        return this.wrapSession((org.hibernate.Session)session);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this._beanFactory = beanFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionFactory createSessionFactory(DataSource dataSource) {
        String servletContextName = PortletClassLoaderUtil.getServletContextName();
        ClassLoader classLoader = this.getSessionFactoryClassLoader();
        PortletClassLoaderUtil.setServletContextName((String)ClassLoaderPool.getContextName((ClassLoader)classLoader));
        try {
            PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration();
            portletHibernateConfiguration.setBeanFactory(this._beanFactory);
            portletHibernateConfiguration.setDataSource(dataSource);
            SessionFactory sessionFactory = null;
            try {
                sessionFactory = portletHibernateConfiguration.buildSessionFactory();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                SessionFactory sessionFactory2 = null;
                PortletClassLoaderUtil.setServletContextName((String)servletContextName);
                return sessionFactory2;
            }
            SessionFactory sessionFactory3 = sessionFactory;
            return sessionFactory3;
        }
        finally {
            PortletClassLoaderUtil.setServletContextName((String)servletContextName);
        }
    }

    protected BeanFactory getBeanFactory() {
        return this._beanFactory;
    }

    protected DataSource getDataSource() {
        ShardDataSourceTargetSource shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
        if (shardDataSourceTargetSource != null) {
            return shardDataSourceTargetSource.getDataSource();
        }
        return this._dataSource;
    }

    protected SessionFactory getSessionFactory() {
        ShardDataSourceTargetSource shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
        if (shardDataSourceTargetSource == null) {
            return this.getSessionFactoryImplementor();
        }
        DataSource dataSource = shardDataSourceTargetSource.getDataSource();
        SessionFactory sessionFactory = this.getSessionFactory(dataSource);
        if (sessionFactory != null) {
            return sessionFactory;
        }
        sessionFactory = this.createSessionFactory(dataSource);
        if (sessionFactory != null) {
            this.putSessionFactory(dataSource, sessionFactory);
        }
        return sessionFactory;
    }

    protected SessionFactory getSessionFactory(DataSource dataSource) {
        return this._sessionFactories.get(dataSource);
    }

    protected void putSessionFactory(DataSource dataSource, SessionFactory sessionFactory) {
        this._sessionFactories.put(dataSource, sessionFactory);
    }

    @Override
    protected Session wrapSession(org.hibernate.Session session) {
        return DoPrivilegedUtil.wrapWhenActive(super.wrapSession(session));
    }
}

