/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.ObjectNotFoundException;
import com.liferay.portal.model.BaseModel;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;

public class ExceptionTranslator {
    public static ORMException translate(Exception e) {
        if (e instanceof org.hibernate.ObjectNotFoundException) {
            return new ObjectNotFoundException((Throwable)e);
        }
        return new ORMException((Throwable)e);
    }

    public static ORMException translate(Exception e, Session session, Object object) {
        if (e instanceof StaleObjectStateException) {
            BaseModel baseModel = (BaseModel)object;
            Object currentObject = session.get(object.getClass(), baseModel.getPrimaryKeyObj());
            return new ORMException(object + " is stale in comparison to " + currentObject, (Throwable)e);
        }
        return new ORMException((Throwable)e);
    }
}

