/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.DynamicQueryImpl;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.criterion.DetachedCriteria;

public class DynamicQueryFactoryImpl
implements DynamicQueryFactory {
    private static Log _log = LogFactoryUtil.getLog(DynamicQueryFactoryImpl.class);
    private Map<ClassLoader, Map<String, Class<?>>> _classes = new HashMap();
    private ClassLoader _portalClassLoader = DynamicQueryFactoryImpl.class.getClassLoader();

    public DynamicQuery forClass(Class<?> clazz) {
        clazz = this.getImplClass(clazz, null);
        return (DynamicQuery)DoPrivilegedUtil.wrap(new DynamicQueryPrivilegedAction(clazz, null));
    }

    public DynamicQuery forClass(Class<?> clazz, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        return (DynamicQuery)DoPrivilegedUtil.wrap(new DynamicQueryPrivilegedAction(clazz, null));
    }

    public DynamicQuery forClass(Class<?> clazz, String alias) {
        clazz = this.getImplClass(clazz, null);
        return (DynamicQuery)DoPrivilegedUtil.wrap(new DynamicQueryPrivilegedAction(clazz, alias));
    }

    public DynamicQuery forClass(Class<?> clazz, String alias, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        return (DynamicQuery)DoPrivilegedUtil.wrap(new DynamicQueryPrivilegedAction(clazz, alias));
    }

    protected Class<?> getImplClass(Class<?> clazz, ClassLoader classLoader) {
        Class<?> implClass = clazz;
        String className = clazz.getName();
        if (!className.endsWith("Impl")) {
            if (classLoader == null) {
                classLoader = ClassLoaderUtil.getContextClassLoader();
            }
            Package pkg = clazz.getPackage();
            String implClassName = pkg.getName() + ".impl." + clazz.getSimpleName() + "Impl";
            try {
                implClass = this.getImplClass(implClassName, classLoader);
            }
            catch (Exception e1) {
                if (classLoader != this._portalClassLoader) {
                    try {
                        implClass = this.getImplClass(implClassName, this._portalClassLoader);
                    }
                    catch (Exception e2) {
                        _log.error((Object)("Unable find model " + implClassName), (Throwable)e2);
                    }
                }
                _log.error((Object)("Unable find model " + implClassName), (Throwable)e1);
            }
        }
        PortalRuntimePermission.checkDynamicQuery(implClass);
        return implClass;
    }

    protected Class<?> getImplClass(String implClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        Map<String, Class<?>> classes = this._classes.get(classLoader);
        if (classes == null) {
            classes = new HashMap();
            this._classes.put(classLoader, classes);
        }
        if ((clazz = classes.get(implClassName)) == null) {
            clazz = classLoader.loadClass(implClassName);
            classes.put(implClassName, clazz);
        }
        return clazz;
    }

    private class DynamicQueryPrivilegedAction
    implements PrivilegedAction<DynamicQuery> {
        private String _alias;
        private Class<?> _clazz;

        public DynamicQueryPrivilegedAction(Class<?> clazz, String alias) {
            this._clazz = clazz;
            this._alias = alias;
        }

        @Override
        public DynamicQuery run() {
            if (this._alias != null) {
                return new DynamicQueryImpl(DetachedCriteria.forClass(this._clazz, (String)this._alias));
            }
            return new DynamicQueryImpl(DetachedCriteria.forClass(this._clazz));
        }
    }
}

