/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLTransformer {
    private static final String _HQL_COMPOSITE_ID_MARKER = "\\.id\\.";
    private static final String _HQL_COUNT_SQL = "SELECT COUNT(*) FROM $2 $3";
    private static final String _HQL_NOT_EQUALS = "!=";
    private static final String _JPQL_DOT_SEPARTOR = ".";
    private static final String _JPQL_NOT_EQUALS = "<>";
    private static final String _LOWER_CLOSE = ")";
    private static final String _LOWER_OPEN = "lower(";
    private static Log _log = LogFactoryUtil.getLog(SQLTransformer.class);
    private static SQLTransformer _instance = new SQLTransformer();
    private static Pattern _bitwiseCheckPattern = Pattern.compile("BITAND\\((.+?),(.+?)\\)");
    private static Pattern _castLongPattern = Pattern.compile("CAST_LONG\\((.+?)\\)", 2);
    private static Pattern _castTextPattern = Pattern.compile("CAST_TEXT\\((.+?)\\)", 2);
    private static Pattern _integerDivisionPattern = Pattern.compile("INTEGER_DIV\\((.+?),(.+?)\\)", 2);
    private static Pattern _jpqlCountPattern = Pattern.compile("SELECT COUNT\\((\\S+)\\) FROM (\\S+) (\\S+)");
    private static Pattern _likePattern = Pattern.compile("LIKE \\?", 2);
    private static Pattern _modPattern = Pattern.compile("MOD\\((.+?),(.+?)\\)", 2);
    private static Pattern _negativeComparisonPattern = Pattern.compile("(!?=)( -([0-9]+)?)", 2);
    private static Pattern _unionAllPattern = Pattern.compile("SELECT \\* FROM(.*)TEMP_TABLE(.*)", 2);
    private DB _db;
    private Map<String, String> _transformedSqls;
    private boolean _vendorDB2;
    private boolean _vendorDerby;
    private boolean _vendorFirebird;
    private boolean _vendorHypersonic;
    private boolean _vendorInformix;
    private boolean _vendorIngres;
    private boolean _vendorInterbase;
    private boolean _vendorMySQL;
    private boolean _vendorOracle;
    private boolean _vendorPostgreSQL;
    private boolean _vendorSQLServer;
    private boolean _vendorSybase;

    public static void reloadSQLTransformer() {
        _instance._reloadSQLTransformer();
    }

    public static String transform(String sql) {
        return _instance._transform(sql);
    }

    public static String transformFromHqlToJpql(String sql) {
        return _instance._transformFromHqlToJpql(sql);
    }

    public static String transformFromJpqlToHql(String sql) {
        return _instance._transformFromJpqlToHql(sql);
    }

    private SQLTransformer() {
        this._reloadSQLTransformer();
    }

    private void _reloadSQLTransformer() {
        if (this._transformedSqls == null) {
            this._transformedSqls = new ConcurrentHashMap<String, String>();
        } else {
            this._transformedSqls.clear();
        }
        this._vendorDB2 = false;
        this._vendorDerby = false;
        this._vendorFirebird = false;
        this._vendorHypersonic = false;
        this._vendorInformix = false;
        this._vendorIngres = false;
        this._vendorInterbase = false;
        this._vendorMySQL = false;
        this._vendorOracle = false;
        this._vendorPostgreSQL = false;
        this._vendorSQLServer = false;
        this._vendorSybase = false;
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        this._db = db;
        if (dbType.equals("db2")) {
            this._vendorDB2 = true;
        } else if (dbType.equals("derby")) {
            this._vendorDerby = true;
        } else if (dbType.equals("firebird")) {
            this._vendorFirebird = true;
        } else if (dbType.equals("hypersonic")) {
            this._vendorHypersonic = true;
        } else if (dbType.equals("informix")) {
            this._vendorInformix = true;
        } else if (dbType.equals("ingres")) {
            this._vendorIngres = true;
        } else if (dbType.equals("interbase")) {
            this._vendorInterbase = true;
        } else if (dbType.equals("mysql")) {
            this._vendorMySQL = true;
        } else if (db.getType().equals("oracle")) {
            this._vendorOracle = true;
        } else if (dbType.equals("postgresql")) {
            this._vendorPostgreSQL = true;
        } else if (dbType.equals("sqlserver")) {
            this._vendorSQLServer = true;
        } else if (dbType.equals("sybase")) {
            this._vendorSybase = true;
        }
    }

    private String _removeLower(String sql) {
        StringBuilder sb;
        block3: {
            int x = sql.indexOf(_LOWER_OPEN);
            if (x == -1) {
                return sql;
            }
            sb = new StringBuilder(sql.length());
            int y = 0;
            do {
                sb.append(sql.substring(y, x));
                y = sql.indexOf(_LOWER_CLOSE, x);
                if (y == -1) {
                    sb.append(sql.substring(x));
                    break block3;
                }
                sb.append(sql.substring(x + _LOWER_OPEN.length(), y));
            } while ((x = sql.indexOf(_LOWER_OPEN, ++y)) != -1);
            sb.append(sql.substring(y));
        }
        sql = sb.toString();
        return sql;
    }

    private String _replaceBitwiseCheck(String sql) {
        Matcher matcher = _bitwiseCheckPattern.matcher(sql);
        if (this._vendorDerby) {
            return matcher.replaceAll("MOD($1 / $2, 2) != 0");
        }
        if (this._vendorInformix || this._vendorIngres) {
            return matcher.replaceAll("BIT_AND($1, $2)");
        }
        if (this._vendorFirebird || this._vendorInterbase) {
            return matcher.replaceAll("BIN_AND($1, $2)");
        }
        if (this._vendorMySQL || this._vendorPostgreSQL || this._vendorSQLServer || this._vendorSybase) {
            return matcher.replaceAll("($1 & $2)");
        }
        return sql;
    }

    private String _replaceBoolean(String newSQL) {
        return StringUtil.replace((String)newSQL, (String[])new String[]{"[$FALSE$]", "[$TRUE$]"}, (String[])new String[]{this._db.getTemplateFalse(), this._db.getTemplateTrue()});
    }

    private String _replaceCastLong(String sql) {
        Matcher matcher = _castLongPattern.matcher(sql);
        if (this._vendorHypersonic) {
            return matcher.replaceAll("CONVERT($1, SQL_BIGINT)");
        }
        if (this._vendorSybase) {
            return matcher.replaceAll("CONVERT(BIGINT, $1)");
        }
        return matcher.replaceAll("$1");
    }

    private String _replaceCastText(String sql) {
        Matcher matcher = _castTextPattern.matcher(sql);
        if (this._vendorDB2 || this._vendorDerby) {
            return matcher.replaceAll("CAST($1 AS CHAR(254))");
        }
        if (this._vendorHypersonic) {
            return matcher.replaceAll("CONVERT($1, SQL_VARCHAR)");
        }
        if (this._vendorOracle) {
            return matcher.replaceAll("CAST($1 AS VARCHAR(4000))");
        }
        if (this._vendorPostgreSQL) {
            return matcher.replaceAll("CAST($1 AS TEXT)");
        }
        if (this._vendorSQLServer) {
            return matcher.replaceAll("CAST($1 AS NVARCHAR(MAX))");
        }
        if (this._vendorSybase) {
            return matcher.replaceAll("CAST($1 AS NVARCHAR(5461))");
        }
        return matcher.replaceAll("$1");
    }

    private String _replaceCrossJoin(String sql) {
        if (this._vendorSybase) {
            return StringUtil.replace((String)sql, (String)"CROSS JOIN", (String)",");
        }
        return sql;
    }

    private String _replaceEscape(String sql) {
        return StringUtil.replace((String)sql, (String)"LIKE ?", (String)"LIKE ? ESCAPE '\\'");
    }

    private String _replaceIntegerDivision(String sql) {
        Matcher matcher = _integerDivisionPattern.matcher(sql);
        if (this._vendorMySQL) {
            return matcher.replaceAll("$1 DIV $2");
        }
        if (this._vendorOracle) {
            return matcher.replaceAll("TRUNC($1 / $2)");
        }
        return matcher.replaceAll("$1 / $2");
    }

    private String _replaceLike(String sql) {
        Matcher matcher = _likePattern.matcher(sql);
        return matcher.replaceAll("LIKE COALESCE(CAST(? AS VARCHAR(32672)),'')");
    }

    private String _replaceMod(String sql) {
        Matcher matcher = _modPattern.matcher(sql);
        return matcher.replaceAll("$1 % $2");
    }

    private String _replaceNegativeComparison(String sql) {
        Matcher matcher = _negativeComparisonPattern.matcher(sql);
        return matcher.replaceAll("$1 ($2)");
    }

    private String _replaceNotEqualsBlankStringComparison(String sql) {
        return StringUtil.replace((String)sql, (String)" != ''", (String)" IS NOT NULL");
    }

    private String _replaceReplace(String newSQL) {
        return newSQL.replaceAll("(?i)replace\\(", "str_replace(");
    }

    private String _replaceUnion(String sql) {
        Matcher matcher = _unionAllPattern.matcher(sql);
        return matcher.replaceAll("$1 $2");
    }

    private String _transform(String sql) {
        if (sql == null) {
            return sql;
        }
        String newSQL = sql;
        newSQL = this._replaceBitwiseCheck(newSQL);
        newSQL = this._replaceBoolean(newSQL);
        newSQL = this._replaceCastLong(newSQL);
        newSQL = this._replaceCastText(newSQL);
        newSQL = this._replaceCrossJoin(newSQL);
        newSQL = this._replaceIntegerDivision(newSQL);
        if (this._vendorDB2) {
            newSQL = this._replaceLike(newSQL);
        } else if (this._vendorDerby) {
            newSQL = this._replaceUnion(newSQL);
        } else if (this._vendorMySQL) {
            DB db = DBFactoryUtil.getDB();
            if (!db.isSupportsStringCaseSensitiveQuery()) {
                newSQL = this._removeLower(newSQL);
            }
        } else if (this._vendorOracle) {
            newSQL = this._replaceEscape(newSQL);
            newSQL = this._replaceNotEqualsBlankStringComparison(newSQL);
        } else if (this._vendorPostgreSQL) {
            newSQL = this._replaceNegativeComparison(newSQL);
        } else if (this._vendorSQLServer) {
            newSQL = this._replaceMod(newSQL);
        } else if (this._vendorSybase) {
            newSQL = this._replaceMod(newSQL);
            newSQL = this._replaceReplace(newSQL);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Original SQL " + sql));
            _log.debug((Object)("Modified SQL " + newSQL));
        }
        return newSQL;
    }

    private String _transformFromHqlToJpql(String sql) {
        String newSQL = this._transformedSqls.get(sql);
        if (newSQL != null) {
            return newSQL;
        }
        newSQL = this._transform(sql);
        newSQL = this._transformPositionalParams(newSQL);
        newSQL = StringUtil.replace((String)newSQL, (String)_HQL_NOT_EQUALS, (String)_JPQL_NOT_EQUALS);
        newSQL = StringUtil.replace((String)newSQL, (String)_HQL_COMPOSITE_ID_MARKER, (String)_JPQL_DOT_SEPARTOR);
        this._transformedSqls.put(sql, newSQL);
        return newSQL;
    }

    private String _transformFromJpqlToHql(String sql) {
        String newSQL = this._transformedSqls.get(sql);
        if (newSQL != null) {
            return newSQL;
        }
        newSQL = this._transform(sql);
        Matcher matcher = _jpqlCountPattern.matcher(newSQL);
        if (matcher.find()) {
            String countExpression = matcher.group(1);
            String entityAlias = matcher.group(3);
            if (entityAlias.equals(countExpression)) {
                newSQL = matcher.replaceFirst(_HQL_COUNT_SQL);
            }
        }
        this._transformedSqls.put(sql, newSQL);
        return newSQL;
    }

    private String _transformPositionalParams(String queryString) {
        if (queryString.indexOf(63) == -1) {
            return queryString;
        }
        StringBundler sb = new StringBundler();
        int i = 1;
        int from = 0;
        int to = 0;
        while ((to = queryString.indexOf(63, from)) != -1) {
            sb.append(queryString.substring(from, to));
            sb.append("?");
            sb.append(i++);
            from = to + 1;
        }
        sb.append(queryString.substring(from));
        return sb.toString();
    }
}

