/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.cache.CacheManagerListener;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;

@DoPrivileged
public class FinderCacheImpl
implements CacheManagerListener,
CacheRegistryItem,
FinderCache {
    public static final String CACHE_NAME = FinderCache.class.getName();
    private static final String _GROUP_KEY_PREFIX = CACHE_NAME.concat(".");
    private static final boolean _LOCAL_CACHE_AVAILABLE;
    private static final ThreadLocal<LRUMap> _localCache;
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();

    public void afterPropertiesSet() {
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(className, true);
        if (portalCache != null) {
            portalCache.removeAll();
        }
    }

    public void clearLocalCache() {
        if (_LOCAL_CACHE_AVAILABLE) {
            _localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Object getResult(FinderPath finderPath, Object[] args, BasePersistenceImpl<? extends BaseModel<?>> basePersistenceImpl) {
        Serializable cacheKey;
        PortalCache<Serializable, Serializable> portalCache;
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return null;
        }
        Serializable primaryKey = null;
        Map localCache = null;
        Serializable localCacheKey = null;
        if (_LOCAL_CACHE_AVAILABLE) {
            localCache = (Map)_localCache.get();
            localCacheKey = finderPath.encodeLocalCacheKey(args);
            primaryKey = (Serializable)localCache.get(localCacheKey);
        }
        if (primaryKey == null && (primaryKey = (Serializable)(portalCache = this._getPortalCache(finderPath.getCacheName(), true)).get(cacheKey = finderPath.encodeCacheKey(args))) != null && _LOCAL_CACHE_AVAILABLE) {
            localCache.put(localCacheKey, primaryKey);
        }
        if (primaryKey != null) {
            return this._primaryKeyToResult(finderPath, basePersistenceImpl, primaryKey);
        }
        return null;
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyCacheAdded(String name) {
    }

    public void notifyCacheRemoved(String name) {
        this._portalCaches.remove(name);
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        this.putResult(finderPath, args, result, true);
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result, boolean quiet) {
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        Serializable primaryKey = this._resultToPrimaryKey((Serializable)result);
        if (_LOCAL_CACHE_AVAILABLE) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = finderPath.encodeLocalCacheKey(args);
            localCache.put(localCacheKey, primaryKey);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName(), true);
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        if (quiet) {
            portalCache.putQuiet(cacheKey, (Object)primaryKey);
        } else {
            portalCache.put(cacheKey, (Object)primaryKey);
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removeCache(groupKey);
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return;
        }
        if (_LOCAL_CACHE_AVAILABLE) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = finderPath.encodeLocalCacheKey(args);
            localCache.remove(localCacheKey);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName(), true);
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        portalCache.remove(cacheKey);
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
        PortalCacheManager portalCacheManager = this._multiVMPool.getCacheManager();
        portalCacheManager.registerCacheManagerListener((CacheManagerListener)this);
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className, boolean createIfAbsent) {
        String groupKey;
        PortalCache<Serializable, Serializable> previousPortalCache;
        PortalCache<Serializable, Serializable> portalCache = (PortalCache<Serializable, Serializable>)this._portalCaches.get(className);
        if (portalCache == null && createIfAbsent && (previousPortalCache = this._portalCaches.putIfAbsent(className, portalCache = this._multiVMPool.getCache(groupKey = _GROUP_KEY_PREFIX.concat(className), PropsValues.VALUE_OBJECT_FINDER_BLOCKING_CACHE))) != null) {
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    private Serializable _primaryKeyToResult(FinderPath finderPath, BasePersistenceImpl<? extends BaseModel<?>> basePersistenceImpl, Serializable primaryKey) {
        if (primaryKey instanceof List) {
            List primaryKeys = (List)((Object)primaryKey);
            if (primaryKeys.isEmpty()) {
                return (Serializable)((Object)Collections.emptyList());
            }
            HashSet primaryKeysSet = new HashSet(primaryKeys);
            Map map = basePersistenceImpl.fetchByPrimaryKeys(primaryKeysSet);
            if (map.size() < primaryKeysSet.size()) {
                return null;
            }
            ArrayList list = new ArrayList(primaryKeys.size());
            for (Serializable curPrimaryKey : primaryKeys) {
                list.add(map.get(curPrimaryKey));
            }
            return (Serializable)((Object)Collections.unmodifiableList(list));
        }
        if (BaseModel.class.isAssignableFrom(finderPath.getResultClass())) {
            return EntityCacheUtil.loadResult((boolean)finderPath.isEntityCacheEnabled(), (Class)finderPath.getResultClass(), (Serializable)primaryKey, basePersistenceImpl);
        }
        return primaryKey;
    }

    private Serializable _resultToPrimaryKey(Serializable result) {
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            return model.getPrimaryKeyObj();
        }
        if (result instanceof List) {
            List list = (List)((Object)result);
            if (list.isEmpty()) {
                return (Serializable)((Object)Collections.emptyList());
            }
            ArrayList<Serializable> cachedList = new ArrayList<Serializable>(list.size());
            for (Serializable curResult : list) {
                Serializable primaryKey = this._resultToPrimaryKey(curResult);
                cachedList.add(primaryKey);
            }
            return cachedList;
        }
        return result;
    }

    static {
        if (PropsValues.VALUE_OBJECT_FINDER_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _LOCAL_CACHE_AVAILABLE = true;
            _localCache = new AutoResetThreadLocal(FinderCacheImpl.class + "._localCache", (Object)new LRUMap(PropsValues.VALUE_OBJECT_FINDER_THREAD_LOCAL_CACHE_MAX_SIZE));
        } else {
            _LOCAL_CACHE_AVAILABLE = false;
            _localCache = null;
        }
    }
}

