/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.cache.mvcc.MVCCPortalCacheFactory;
import com.liferay.portal.kernel.cache.CacheManagerListener;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.MVCCModel;
import com.liferay.portal.util.PropsValues;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;

@DoPrivileged
public class EntityCacheImpl
implements CacheManagerListener,
CacheRegistryItem,
EntityCache {
    public static final String CACHE_NAME = EntityCache.class.getName();
    private static final String _GROUP_KEY_PREFIX = CACHE_NAME.concat(".");
    private static final boolean _LOCAL_CACHE_AVAILABLE;
    private static Log _log;
    private static final ThreadLocal<LRUMap> _localCache;
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();

    public void afterPropertiesSet() {
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(Class<?> clazz) {
        this.clearLocalCache();
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz, true);
        if (portalCache != null) {
            portalCache.removeAll();
        }
    }

    public void clearLocalCache() {
        if (_LOCAL_CACHE_AVAILABLE) {
            _localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public PortalCache<Serializable, Serializable> getPortalCache(Class<?> clazz) {
        return this._getPortalCache(clazz, true);
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Serializable getResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return null;
        }
        Object result = null;
        Map localCache = null;
        Serializable localCacheKey = null;
        if (_LOCAL_CACHE_AVAILABLE) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        if (result == null) {
            Serializable cacheKey;
            PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz, true);
            result = (Serializable)portalCache.get(cacheKey = this._encodeCacheKey(primaryKey));
            if (result == null) {
                result = "";
            }
            if (_LOCAL_CACHE_AVAILABLE) {
                localCache.put(localCacheKey, result);
            }
        }
        return this._toEntityModel((Serializable)result);
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable loadResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, SessionFactory sessionFactory) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            Session session = null;
            try {
                session = sessionFactory.openSession();
                Serializable serializable = (Serializable)session.load(clazz, primaryKey);
                return serializable;
            }
            finally {
                sessionFactory.closeSession(session);
            }
        }
        Object result = null;
        Map localCache = null;
        Serializable localCacheKey = null;
        if (_LOCAL_CACHE_AVAILABLE) {
            localCache = (Map)_localCache.get();
            localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            result = (Serializable)localCache.get(localCacheKey);
        }
        Serializable loadResult = null;
        if (result == null) {
            Serializable cacheKey;
            PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz, true);
            result = (Serializable)portalCache.get(cacheKey = this._encodeCacheKey(primaryKey));
            if (result == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Load " + clazz + " " + primaryKey + " from session"));
                }
                Session session = null;
                try {
                    session = sessionFactory.openSession();
                    loadResult = (Serializable)session.load(clazz, primaryKey);
                }
                finally {
                    result = loadResult == null ? "" : ((BaseModel)loadResult).toCacheModel();
                    portalCache.putQuiet(cacheKey, result);
                    sessionFactory.closeSession(session);
                }
            }
            if (_LOCAL_CACHE_AVAILABLE) {
                localCache.put(localCacheKey, result);
            }
        }
        if (loadResult != null) {
            return loadResult;
        }
        return this._toEntityModel((Serializable)result);
    }

    public void notifyCacheAdded(String name) {
    }

    public void notifyCacheRemoved(String name) {
        this._portalCaches.remove(name);
    }

    public void putResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, Serializable result) {
        this.putResult(entityCacheEnabled, clazz, primaryKey, result, true);
    }

    public void putResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey, Serializable result, boolean quiet) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        result = ((BaseModel)result).toCacheModel();
        if (_LOCAL_CACHE_AVAILABLE) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            localCache.put(localCacheKey, result);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz, true);
        Serializable cacheKey = this._encodeCacheKey(primaryKey);
        if (quiet) {
            portalCache.putQuiet(cacheKey, (Object)result);
        } else {
            portalCache.put(cacheKey, (Object)result);
        }
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removeCache(groupKey);
    }

    public void removeResult(boolean entityCacheEnabled, Class<?> clazz, Serializable primaryKey) {
        if (!(PropsValues.VALUE_OBJECT_ENTITY_CACHE_ENABLED && entityCacheEnabled && CacheRegistryUtil.isActive())) {
            return;
        }
        if (_LOCAL_CACHE_AVAILABLE) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = this._encodeLocalCacheKey(clazz, primaryKey);
            localCache.remove(localCacheKey);
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(clazz, true);
        Serializable cacheKey = this._encodeCacheKey(primaryKey);
        portalCache.remove(cacheKey);
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
        PortalCacheManager portalCacheManager = this._multiVMPool.getCacheManager();
        portalCacheManager.registerCacheManagerListener((CacheManagerListener)this);
    }

    private Serializable _encodeCacheKey(Serializable primaryKey) {
        if (ShardUtil.isEnabled()) {
            return new CacheKey(ShardUtil.getCurrentShardName(), primaryKey);
        }
        return primaryKey;
    }

    private Serializable _encodeLocalCacheKey(Class<?> clazz, Serializable primaryKey) {
        if (ShardUtil.isEnabled()) {
            return new ShardLocalCacheKey(ShardUtil.getCurrentShardName(), clazz.getName(), primaryKey);
        }
        return new LocalCacheKey(clazz.getName(), primaryKey);
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(Class<?> clazz, boolean createIfAbsent) {
        String className = clazz.getName();
        Object portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache == null && createIfAbsent) {
            PortalCache<Serializable, Serializable> previousPortalCache;
            String groupKey = _GROUP_KEY_PREFIX.concat(className);
            portalCache = this._multiVMPool.getCache(groupKey, PropsValues.VALUE_OBJECT_ENTITY_BLOCKING_CACHE);
            if (PropsValues.VALUE_OBJECT_MVCC_ENTITY_CACHE_ENABLED && MVCCModel.class.isAssignableFrom(clazz)) {
                portalCache = MVCCPortalCacheFactory.createMVCCEhcachePortalCache(portalCache);
            }
            if ((previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)portalCache)) != null) {
                portalCache = previousPortalCache;
            }
        }
        return portalCache;
    }

    private Serializable _toEntityModel(Serializable result) {
        if (result == "") {
            return null;
        }
        CacheModel cacheModel = (CacheModel)result;
        BaseModel entityModel = (BaseModel)cacheModel.toEntityModel();
        entityModel.setCachedModel(true);
        return entityModel;
    }

    static {
        _log = LogFactoryUtil.getLog(EntityCacheImpl.class);
        if (PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _LOCAL_CACHE_AVAILABLE = true;
            _localCache = new AutoResetThreadLocal(EntityCacheImpl.class + "._localCache", (Object)new LRUMap(PropsValues.VALUE_OBJECT_ENTITY_THREAD_LOCAL_CACHE_MAX_SIZE));
        } else {
            _LOCAL_CACHE_AVAILABLE = false;
            _localCache = null;
        }
    }

    private static class ShardLocalCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _className;
        private final Serializable _primaryKey;
        private final String _shardName;

        public ShardLocalCacheKey(String shardName, String className, Serializable primaryKey) {
            this._shardName = shardName;
            this._className = className;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            ShardLocalCacheKey shardLocalCacheKey = (ShardLocalCacheKey)obj;
            return shardLocalCacheKey._shardName.equals(this._shardName) && shardLocalCacheKey._className.equals(this._className) && shardLocalCacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (Object)this._shardName);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._className);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._primaryKey);
            return hashCode;
        }
    }

    private static class LocalCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _className;
        private final Serializable _primaryKey;

        public LocalCacheKey(String className, Serializable primaryKey) {
            this._className = className;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            LocalCacheKey localCacheKey = (LocalCacheKey)obj;
            return localCacheKey._className.equals(this._className) && localCacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            return this._className.hashCode() * 11 + this._primaryKey.hashCode();
        }
    }

    private static class CacheKey
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Serializable _primaryKey;
        private String _shardName;

        public CacheKey() {
        }

        public CacheKey(String shardName, Serializable primaryKey) {
            this._shardName = shardName;
            this._primaryKey = primaryKey;
        }

        public boolean equals(Object obj) {
            CacheKey cacheKey = (CacheKey)obj;
            return cacheKey._shardName.equals(this._shardName) && cacheKey._primaryKey.equals(this._primaryKey);
        }

        public int hashCode() {
            return this._shardName.hashCode() * 11 + this._primaryKey.hashCode();
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
            this._primaryKey = (Serializable)objectInput.readObject();
            this._shardName = objectInput.readUTF();
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this._primaryKey);
            objectOutput.writeUTF(this._shardName);
        }
    }
}

