/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc;

import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactory;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.HttpImpl;
import com.liferay.portal.util.JarUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.lang.management.ManagementFactory;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import jodd.bean.BeanUtil;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

@DoPrivileged
public class DataSourceFactoryImpl
implements DataSourceFactory {
    private static final String _TOMCAT_JDBC_POOL_OBJECT_NAME_PREFIX = "TomcatJDBCPool:type=ConnectionPool,name=";
    private static Log _log = LogFactoryUtil.getLog(DataSourceFactoryImpl.class);
    private static PACL _pacl = new NoPACL();

    public void destroyDataSource(javax.sql.DataSource dataSource) throws Exception {
        while (dataSource instanceof DataSourceWrapper) {
            DataSourceWrapper dataSourceWrapper = (DataSourceWrapper)dataSource;
            dataSource = dataSourceWrapper.getWrappedDataSource();
        }
        if (dataSource instanceof ComboPooledDataSource) {
            ComboPooledDataSource comboPooledDataSource = (ComboPooledDataSource)dataSource;
            comboPooledDataSource.close();
        } else if (dataSource instanceof DataSource) {
            DataSource tomcatDataSource = (DataSource)dataSource;
            tomcatDataSource.close();
        }
    }

    public javax.sql.DataSource initDataSource(Properties properties) throws Exception {
        Properties defaultProperties = PropsUtil.getProperties("jdbc.default.", true);
        PropertiesUtil.merge((Properties)defaultProperties, (Properties)properties);
        properties = defaultProperties;
        String jndiName = properties.getProperty("jndi.name");
        if (Validator.isNotNull((String)jndiName)) {
            try {
                Properties jndiEnvironmentProperties = PropsUtil.getProperties("jndi.environment.", true);
                InitialContext context = new InitialContext(jndiEnvironmentProperties);
                return (javax.sql.DataSource)JNDIUtil.lookup((Context)context, (String)jndiName);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to lookup " + jndiName), (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Data source properties:\n");
            SortedProperties sortedProperties = new SortedProperties(properties);
            _log.debug((Object)PropertiesUtil.toString((Properties)sortedProperties));
        }
        this.testClassForName(properties);
        javax.sql.DataSource dataSource = null;
        String liferayPoolProvider = PropsValues.JDBC_DEFAULT_LIFERAY_POOL_PROVIDER;
        if (StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"c3p0") || StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"c3po")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing C3P0 data source");
            }
            dataSource = this.initDataSourceC3PO(properties);
        } else if (StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"dbcp")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing DBCP data source");
            }
            dataSource = this.initDataSourceDBCP(properties);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing Tomcat data source");
            }
            dataSource = this.initDataSourceTomcat(properties);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Created data source " + dataSource.getClass()));
        }
        return _pacl.getDataSource(dataSource);
    }

    public javax.sql.DataSource initDataSource(String driverClassName, String url, String userName, String password, String jndiName) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", driverClassName);
        properties.setProperty("url", url);
        properties.setProperty("username", userName);
        properties.setProperty("password", password);
        properties.setProperty("jndi.name", jndiName);
        return this.initDataSource(properties);
    }

    protected javax.sql.DataSource initDataSourceC3PO(Properties properties) throws Exception {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        String identityToken = StringUtil.randomString();
        comboPooledDataSource.setIdentityToken(identityToken);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            if (StringUtil.equalsIgnoreCase((String)key, (String)"driverClassName")) {
                key = "driverClass";
            } else if (StringUtil.equalsIgnoreCase((String)key, (String)"url")) {
                key = "jdbcUrl";
            } else if (StringUtil.equalsIgnoreCase((String)key, (String)"username")) {
                key = "user";
            }
            if (this.isPropertyLiferay(key) || this.isPropertyDBCP(key) || this.isPropertyTomcat(key)) continue;
            try {
                BeanUtil.setProperty((Object)comboPooledDataSource, (String)key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Property " + key + " is not a valid C3PO property"));
            }
        }
        return comboPooledDataSource;
    }

    protected javax.sql.DataSource initDataSourceDBCP(Properties properties) throws Exception {
        return BasicDataSourceFactory.createDataSource((Properties)properties);
    }

    protected javax.sql.DataSource initDataSourceTomcat(Properties properties) throws Exception {
        PoolProperties poolProperties = new PoolProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.isPropertyLiferay(key) || this.isPropertyC3PO(key)) continue;
            try {
                BeanUtil.setProperty((Object)poolProperties, (String)key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Property " + key + " is not a valid Tomcat JDBC " + "Connection Pool property"));
            }
        }
        String poolName = StringUtil.randomString();
        poolProperties.setName(poolName);
        DataSource dataSource = new DataSource((PoolConfiguration)poolProperties);
        if (poolProperties.isJmxEnabled()) {
            ConnectionPool jdbcConnectionPool = dataSource.createPool();
            org.apache.tomcat.jdbc.pool.jmx.ConnectionPool jmxConnectionPool = jdbcConnectionPool.getJmxPool();
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(_TOMCAT_JDBC_POOL_OBJECT_NAME_PREFIX + poolName);
            mBeanServer.registerMBean(jmxConnectionPool, objectName);
        }
        return dataSource;
    }

    protected boolean isPropertyC3PO(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"acquireIncrement") || StringUtil.equalsIgnoreCase((String)key, (String)"acquireRetryAttempts") || StringUtil.equalsIgnoreCase((String)key, (String)"acquireRetryDelay") || StringUtil.equalsIgnoreCase((String)key, (String)"connectionCustomizerClassName") || StringUtil.equalsIgnoreCase((String)key, (String)"idleConnectionTestPeriod") || StringUtil.equalsIgnoreCase((String)key, (String)"maxIdleTime") || StringUtil.equalsIgnoreCase((String)key, (String)"maxPoolSize") || StringUtil.equalsIgnoreCase((String)key, (String)"minPoolSize") || StringUtil.equalsIgnoreCase((String)key, (String)"numHelperThreads") || StringUtil.equalsIgnoreCase((String)key, (String)"preferredTestQuery");
    }

    protected boolean isPropertyDBCP(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"defaultTransactionIsolation") || StringUtil.equalsIgnoreCase((String)key, (String)"maxActive") || StringUtil.equalsIgnoreCase((String)key, (String)"minIdle") || StringUtil.equalsIgnoreCase((String)key, (String)"removeAbandonedTimeout");
    }

    protected boolean isPropertyLiferay(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"jndi.name") || StringUtil.equalsIgnoreCase((String)key, (String)"liferay.pool.provider");
    }

    protected boolean isPropertyTomcat(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"fairQueue") || StringUtil.equalsIgnoreCase((String)key, (String)"jdbcInterceptors") || StringUtil.equalsIgnoreCase((String)key, (String)"jmxEnabled") || StringUtil.equalsIgnoreCase((String)key, (String)"timeBetweenEvictionRunsMillis") || StringUtil.equalsIgnoreCase((String)key, (String)"useEquals");
    }

    protected void testClassForName(Properties properties) throws Exception {
        String driverClassName = properties.getProperty("driverClassName");
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException cnfe) {
            if (!(ServerDetector.isGeronimo() || ServerDetector.isJetty() || ServerDetector.isTomcat())) {
                throw cnfe;
            }
            String url = PropsUtil.get("setup.database.jar.url", new Filter(driverClassName));
            String name = PropsUtil.get("setup.database.jar.name", new Filter(driverClassName));
            if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
                throw cnfe;
            }
            if (HttpUtil.getHttp() == null) {
                HttpUtil httpUtil = new HttpUtil();
                httpUtil.setHttp((Http)new HttpImpl());
            }
            if (FileUtil.getFile() == null) {
                FileUtil fileUtil = new FileUtil();
                fileUtil.setFile((File)new FileImpl());
            }
            JarUtil.downloadAndInstallJar(true, url, name, null);
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public javax.sql.DataSource getDataSource(javax.sql.DataSource dataSource) {
            return dataSource;
        }
    }

    public static interface PACL {
        public javax.sql.DataSource getDataSource(javax.sql.DataSource var1);
    }
}

